/*
 * Decompiled with CFR 0.152.
 */
package bean;

import bean.ProjectSta;
import data.Projectdata;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.ArrayList;

public class CmiiSta
implements Serializable {
    ArrayList<ProjectSta> cmiipjr = new ArrayList();

    public void setCmiipjr(ArrayList<ProjectSta> cmiipjr) {
        this.cmiipjr = cmiipjr;
    }

    public ArrayList<ProjectSta> getCmiipjr() {
        return this.cmiipjr;
    }

    public String toString() {
        return "CmiiSta [cmiipjr=" + this.cmiipjr.size() + "]";
    }

    public boolean checkexist(String keyname) {
        boolean result = false;
        ArrayList<ProjectSta> lists = this.cmiipjr;
        for (ProjectSta projectsta : lists) {
            if (!projectsta.getName().trim().equals(keyname.trim())) continue;
            result = true;
        }
        return result;
    }

    public void upstaPJR(String keyname, boolean sta) {
        ArrayList<ProjectSta> lists = this.cmiipjr;
        ArrayList<ProjectSta> newlists = new ArrayList<ProjectSta>();
        for (ProjectSta projectsta : lists) {
            if (projectsta.getName().trim().equals(keyname.trim())) {
                projectsta.setSta(sta);
                newlists.add(projectsta);
                continue;
            }
            newlists.add(projectsta);
        }
        this.cmiipjr = newlists;
    }

    public void updaetSta(String keyname, boolean sta, String path) {
        if (!this.checkexist(keyname)) {
            ProjectSta psta = new ProjectSta();
            psta.setName(keyname);
            psta.setPath(path);
            psta.setSta(sta);
            this.cmiipjr.add(psta);
        } else {
            this.upstaPJR(keyname, sta);
        }
    }

    public void writeobj(CmiiSta obj) throws Exception {
        String filename = String.valueOf(Projectdata.getPathSep("cmiilog")) + "cmiista.txt";
        try {
            File f = new File(filename);
            PrintWriter pw = new PrintWriter(f);
            for (ProjectSta psta : this.cmiipjr) {
                pw.println(String.valueOf(psta.getName()) + "\t" + psta.isSta() + "\t" + psta.getPath());
            }
            pw.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void remvoveRecoveryfile() {
        String filename = String.valueOf(Projectdata.getPathSep("cmiilog")) + "cmiista.txt";
        if (new File(filename).exists()) {
            new File(filename).delete();
        }
    }

    public static CmiiSta removeProject(String rmname) {
        CmiiSta cmiista = new CmiiSta();
        String filename = String.valueOf(Projectdata.getPathSep("cmiilog")) + "cmiista.txt";
        Object bufferedWriter = null;
        if (new File(filename).exists()) {
            try {
                String output;
                File f = new File(filename);
                FileReader fr = new FileReader(f);
                BufferedReader br = new BufferedReader(fr);
                while ((output = br.readLine()) != null) {
                    String[] tmp = output.split("\t");
                    if (tmp.length != 3) continue;
                    String name = tmp[0];
                    String value = tmp[1];
                    String path = tmp[2];
                    if (rmname.equals(name)) continue;
                    cmiista.updaetSta(name, Boolean.parseBoolean(value), path);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return cmiista;
    }

    public static CmiiSta clearcmiiSTA() {
        CmiiSta cmiista = new CmiiSta();
        String filename = String.valueOf(Projectdata.getPathSep("cmiilog")) + "cmiista.txt";
        Object bufferedWriter = null;
        if (new File(filename).exists()) {
            try {
                String output;
                File f = new File(filename);
                FileReader fr = new FileReader(f);
                BufferedReader br = new BufferedReader(fr);
                while ((output = br.readLine()) != null) {
                    String[] tmp = output.split("\t");
                    if (tmp.length != 3) continue;
                    String name = tmp[0];
                    String path = tmp[2];
                    cmiista.updaetSta(name, true, path);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return cmiista;
    }

    public static CmiiSta getobjwrite() {
        CmiiSta cmiista = new CmiiSta();
        String filename = String.valueOf(Projectdata.getPathSep("cmiilog")) + "cmiista.txt";
        Object bufferedWriter = null;
        if (new File(filename).exists()) {
            try {
                String output;
                File f = new File(filename);
                FileReader fr = new FileReader(f);
                BufferedReader br = new BufferedReader(fr);
                while ((output = br.readLine()) != null) {
                    String[] tmp = output.split("\t");
                    if (tmp.length != 3) continue;
                    String name = tmp[0];
                    String value = tmp[1];
                    String path = tmp[2];
                    cmiista.updaetSta(name, Boolean.parseBoolean(value), path);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return cmiista;
    }
}

