/*
 * Decompiled with CFR 0.152.
 */
package bean;

import bean.ReadFile;
import data.Projectdata;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Pattern;

public class DBList {
    String mature = "Release 14";
    String uniprot = "Release 15.11";
    String rfam = "Release 9.1";
    String uniref = "Release 15.11";
    TreeMap<String, TreeSet<String>> miRNAtm;
    TreeSet<String> mirnamember;
    TreeSet<String> sqpdcount;
    TreeSet<String> membertargettm;
    TreeMap<String, TreeSet<String>> targettm;

    public DBList() {
        this.update();
    }

    public int countfile(String filename, String pattern) {
        int count = 0;
        try {
            String output;
            File f = new File(filename);
            FileReader fr = new FileReader(f);
            BufferedReader bfr = new BufferedReader(fr);
            while ((output = bfr.readLine()) != null) {
                if (!Pattern.matches(pattern, output)) continue;
                ++count;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return count;
    }

    public TreeMap<String, String> countTargetfile(String filename, TreeMap<String, String> tm) {
        try {
            String output;
            File f = new File(filename);
            FileReader fr = new FileReader(f);
            BufferedReader bfr = new BufferedReader(fr);
            int count = 0;
            while ((output = bfr.readLine()) != null) {
                String[] outputs = output.split("\t");
                try {
                    if (outputs.length <= 1) continue;
                    String predictedtarget = outputs[0].trim();
                    tm.put(predictedtarget, "-");
                    ++count;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            bfr.close();
            fr.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return tm;
    }

    public TreeMap<String, TreeSet<String>> countmirnafile(String filename, TreeMap<String, TreeSet<String>> tm) {
        try {
            String output;
            File f = new File(filename);
            FileReader fr = new FileReader(f);
            BufferedReader bfr = new BufferedReader(fr);
            while ((output = bfr.readLine()) != null) {
                String[] outputs = output.split("\t");
                try {
                    TreeSet<Object> sqList;
                    if (outputs.length <= 1 || outputs[4].equals("*") || outputs[5].equals("*") || outputs[6].equals("*") || outputs[7].equals("*") || outputs[8].equals("*")) continue;
                    String sqkey = String.valueOf(outputs[0].split("-")[0].trim()) + "-" + outputs[13].trim();
                    String miRNAValue = outputs[9].trim().split("-")[1];
                    this.mirnamember.add(miRNAValue);
                    miRNAValue = Projectdata.chgmirnafamily(miRNAValue);
                    if (tm.containsKey(miRNAValue)) {
                        sqList = tm.get(miRNAValue);
                        sqList.add(sqkey);
                        tm.put(miRNAValue, sqList);
                        continue;
                    }
                    sqList = new TreeSet();
                    sqList.add(sqkey);
                    tm.put(miRNAValue, sqList);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            bfr.close();
            fr.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return tm;
    }

    public void loadsequence() {
    }

    public String getNumOfInputSeq() {
        String summary;
        String[] outputs;
        String output = "0";
        String filestatus = String.valueOf(Projectdata.getPathSep("sequence")) + Projectdata.sequencename;
        if (new File(String.valueOf(filestatus) + ".status").exists() && (outputs = (summary = ReadFile.readfile(String.valueOf(filestatus) + ".status", "Get number of input sequences", "DBlist.java").trim()).split("\n")).length == 3) {
            output = outputs[1].split(":")[1].trim();
        }
        return output;
    }

    public String getNumOfexcludedInputSeq() {
        String summary;
        String[] outputs;
        String output = "0";
        String filestatus = String.valueOf(Projectdata.getPathSep("sequence")) + Projectdata.sequencename;
        if (new File(String.valueOf(filestatus) + ".status").exists() && (outputs = (summary = ReadFile.readfile(String.valueOf(filestatus) + ".status", "Get number of input sequences", "DBlist.java").trim()).split("\n")).length == 3) {
            output = outputs[2].split(":")[1].trim();
        }
        return output;
    }

    public String getNumOfInputTargetSeq() {
        String summary;
        String[] outputs;
        String output = "0";
        String filestatus = String.valueOf(Projectdata.getPathSep("targetsequence")) + Projectdata.targetsequencename;
        if (new File(String.valueOf(filestatus) + ".status").exists() && (outputs = (summary = ReadFile.readfile(String.valueOf(filestatus) + ".status", "Get number of target input sequences", "DBlist.java").trim()).split("\n")).length == 3) {
            output = outputs[1].split(":")[1].trim();
        }
        return output;
    }

    public String getNumOfexcludedInputTargetSeq() {
        String summary;
        String[] outputs;
        String output = "0";
        String filestatus = String.valueOf(Projectdata.getPathSep("targetsequence")) + Projectdata.targetsequencename;
        if (new File(String.valueOf(filestatus) + ".status").exists() && (outputs = (summary = ReadFile.readfile(String.valueOf(filestatus) + ".status", "Get number of target input sequences", "DBlist.java").trim()).split("\n")).length == 3) {
            output = outputs[2].split(":")[1].trim();
        }
        return output;
    }

    public String getNumOfpredictedmiRNAs() {
        String output = "";
        String filename = String.valueOf(Projectdata.getPathSep("targetsequence")) + Projectdata.targetsequencename;
        int count = this.countfile(filename, ".*>.*");
        output = Integer.toString(count);
        return output;
    }

    public TreeSet<String> getSqCount() {
        return this.sqpdcount;
    }

    public TreeSet<String> getMirnamember() {
        return this.mirnamember;
    }

    public TreeMap<String, TreeSet<String>> getMiRNAmodel() {
        return this.miRNAtm;
    }

    public void loadmiRNAmodel(String output) {
        this.mirnamember = new TreeSet();
        String filename = "";
        TreeMap<String, TreeSet<String>> tm = new TreeMap<String, TreeSet<String>>();
        if (Projectdata.isprefolding) {
            String[] outputs;
            String[] stringArray = outputs = Projectdata.prefoldingfile.split(",");
            int n = outputs.length;
            int n2 = 0;
            while (n2 < n) {
                String name = stringArray[n2];
                if (name.equals(output) || output.equals("All")) {
                    filename = String.valueOf(Projectdata.getPathSep("prefolding")) + name;
                    tm = this.countmirnafile(filename, tm);
                }
                ++n2;
            }
        }
        this.sqpdcount = new TreeSet();
        Set set = tm.entrySet();
        for (Map.Entry me : set) {
            TreeSet sqnames = (TreeSet)tm.get(me.getKey().toString());
            for (String sqname : sqnames) {
                String name = sqname.split("-")[0].trim();
                this.sqpdcount.add(name);
            }
        }
        this.miRNAtm = tm;
    }

    public String getNumOfmiRNAs(TreeMap<String, TreeSet<String>> miRNAtm) {
        return String.valueOf(miRNAtm.size());
    }

    public String getNumOfmiRNAsFamily(TreeSet<String> mirnafamily) {
        return String.valueOf(mirnafamily.size());
    }

    public TreeMap<String, Integer> getmiRNADBGraph() {
        TreeMap<String, Integer> tmdb = new TreeMap<String, Integer>();
        Set<Map.Entry<String, TreeSet<String>>> set = this.miRNAtm.entrySet();
        for (Map.Entry<String, TreeSet<String>> me : set) {
            TreeSet<String> al = this.miRNAtm.get(me.getKey());
            tmdb.put(me.getKey().toString(), al.size());
        }
        return tmdb;
    }

    public TreeMap<String, Integer> getTargetDBGraph(TreeMap<String, TreeSet<String>> model) {
        TreeSet al;
        TreeMap<String, Integer> tmdb = new TreeMap<String, Integer>();
        TreeMap<String, TreeSet> tranpose = new TreeMap<String, TreeSet>();
        Set<Map.Entry<String, TreeSet<String>>> set = model.entrySet();
        for (Map.Entry<String, TreeSet<String>> me : set) {
            al = model.get(me.getKey());
            for (String target : al) {
                TreeSet ts;
                if (tranpose.containsKey(target)) {
                    ts = (TreeSet)tranpose.get(target);
                    ts.add(me.getKey().toString());
                    tranpose.put(target, ts);
                    continue;
                }
                ts = new TreeSet();
                ts.add(me.getKey().toString());
                tranpose.put(target, ts);
            }
        }
        set = tranpose.entrySet();
        for (Map.Entry<String, TreeSet<String>> me : set) {
            al = (TreeSet)tranpose.get(me.getKey());
            tmdb.put(me.getKey().toString(), al.size());
        }
        return tmdb;
    }

    public TreeSet<String> getMembertargettm() {
        return this.membertargettm;
    }

    public void setMembertargettm(TreeSet<String> membertargettm) {
        this.membertargettm = membertargettm;
    }

    public TreeMap<String, TreeSet<String>> getTargetmodel() {
        return this.targettm;
    }

    public void loadTargetmodel(String output) {
        this.membertargettm = new TreeSet();
        String filename = "";
        TreeMap<String, String> tm = new TreeMap<String, String>();
        TreeMap<String, TreeSet> tmmap = new TreeMap<String, TreeSet>();
        TreeMap<String, TreeSet> tmmapmember = new TreeMap<String, TreeSet>();
        if (Projectdata.isanotation) {
            String[] outputs;
            String[] stringArray = outputs = Projectdata.anotationfile.split(",");
            int n = outputs.length;
            int n2 = 0;
            while (n2 < n) {
                String name = stringArray[n2];
                if (name.equals(output) || output.equals("All")) {
                    String[] mapoutputs;
                    filename = String.valueOf(Projectdata.getPathSep("anotation")) + name;
                    tm = this.countTargetfile(filename, tm);
                    filename = String.valueOf(filename) + ".map";
                    String mapoutput = ReadFile.readfile(filename, "Get anotation mapfile", "DBlist.java").trim();
                    String[] stringArray2 = mapoutputs = mapoutput.split("\n");
                    int n3 = mapoutputs.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        TreeSet ts;
                        String string = stringArray2[n4];
                        String[] strings = string.split("\t");
                        String cmpsq = strings[0].trim();
                        String mirnaname = strings[1].trim();
                        mirnaname = mirnaname.split("#")[0];
                        String member = mirnaname = mirnaname.split("-")[1].trim();
                        mirnaname = Projectdata.chgmirnafamily(mirnaname);
                        if (tmmap.containsKey(cmpsq)) {
                            ts = (TreeSet)tmmap.get(cmpsq);
                            ts.add(mirnaname);
                            tmmap.put(cmpsq, ts);
                        } else {
                            ts = new TreeSet();
                            ts.add(mirnaname);
                            tmmap.put(cmpsq, ts);
                        }
                        if (tmmapmember.containsKey(cmpsq)) {
                            ts = (TreeSet)tmmapmember.get(cmpsq);
                            ts.add(member);
                            tmmapmember.put(cmpsq, ts);
                        } else {
                            ts = new TreeSet();
                            ts.add(member);
                            tmmapmember.put(cmpsq, ts);
                        }
                        ++n4;
                    }
                }
                ++n2;
            }
        }
        TreeMap<String, TreeSet> targettmlocal = new TreeMap<String, TreeSet>();
        Set set = tmmap.entrySet();
        for (Map.Entry me : set) {
            if (!tm.containsKey(me.getKey().toString().trim())) continue;
            TreeSet ts = (TreeSet)tmmap.get(me.getKey());
            targettmlocal.put(me.getKey().toString(), ts);
            TreeSet ts1 = (TreeSet)tmmapmember.get(me.getKey());
            for (String member : ts1) {
                this.membertargettm.add(member);
            }
        }
        this.targettm = targettmlocal;
    }

    public String getNumOfTarget(String targetname) {
        String output = "0";
        String filename = "";
        TreeMap<String, String> tm = new TreeMap<String, String>();
        if (Projectdata.isanotation) {
            String[] outputs;
            String[] stringArray = outputs = Projectdata.anotationfile.split(",");
            int n = outputs.length;
            int n2 = 0;
            while (n2 < n) {
                String name = stringArray[n2];
                if (name.equals(targetname) || targetname.equals("All")) {
                    filename = String.valueOf(Projectdata.getPathSep("anotation")) + name;
                    tm = this.countTargetfile(filename, tm);
                }
                ++n2;
            }
        }
        TreeSet<String> size = new TreeSet<String>();
        Set set = tm.entrySet();
        for (Map.Entry me : set) {
            String sqname = me.getKey().toString();
            size.add(sqname.split("-")[0].trim());
        }
        output = String.valueOf(size.size());
        return output;
    }

    public String getMature() {
        return this.mature;
    }

    public void setMature(String mature) {
        this.mature = mature;
    }

    public String getUniprot() {
        return this.uniprot;
    }

    public void setUniprot(String uniprot) {
        this.uniprot = uniprot;
    }

    public String getRfam() {
        return this.rfam;
    }

    public void setRfam(String rfam) {
        this.rfam = rfam;
    }

    public String getUniref() {
        return this.uniref;
    }

    public void setUniref(String uniref) {
        this.uniref = uniref;
    }

    public void update() {
        String filename = "." + System.getProperty("file.separator") + "database" + System.getProperty("file.separator") + "DBList.txt";
        File f = new File(filename);
        if (f.exists()) {
            String[] outputs;
            String output = ReadFile.readfile(filename, "Update database", "DBlist.java");
            String[] stringArray = outputs = output.split("\n");
            int n = outputs.length;
            int n2 = 0;
            while (n2 < n) {
                String string = stringArray[n2];
                String[] tmp = string.split("\t");
                if (tmp.length == 2) {
                    if (tmp[0].equals("mature")) {
                        this.setMature(tmp[1]);
                    }
                    if (tmp[0].equals("uniprot")) {
                        this.setUniprot(tmp[1]);
                    }
                    if (tmp[0].equals("rfam")) {
                        this.setRfam(tmp[1]);
                    }
                    if (tmp[0].equals("uniref")) {
                        this.setUniref(tmp[1]);
                    }
                }
                ++n2;
            }
        }
    }

    public static void main(String[] args) {
        DBList list = new DBList();
        list.update();
        System.out.println(list.getNumOfInputSeq());
    }
}

