/*
 * Decompiled with CFR 0.152.
 */
package bean;

import frame.Custom;
import java.util.ArrayList;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.swing.JFrame;

public class GoGraph {
    int maxwidth = 0;

    public int getMaxwidth() {
        return this.maxwidth;
    }

    public void setMaxwidth(int maxwidth) {
        this.maxwidth = maxwidth;
    }

    public ArrayList<String> loadGo(ArrayList<String> cpf) {
        ArrayList<String> al = new ArrayList<String>();
        al.add("C,C/P/F");
        al.add("P,C/P/F");
        al.add("F,C/P/F");
        for (String string : cpf) {
            al.add(string);
        }
        return al;
    }

    public TreeSet<String> makeNode(ArrayList<String> al) {
        TreeSet<String> nodelist = new TreeSet<String>();
        for (String string : al) {
            String[] node = string.split(",");
            nodelist.add(node[0].trim());
            nodelist.add(node[1].trim());
        }
        return nodelist;
    }

    public TreeMap<String, Integer> makeNodeLeve(ArrayList<String> cpf) {
        TreeMap<String, Integer> nodelevel = new TreeMap<String, Integer>();
        nodelevel.put("C/P/F", 1);
        nodelevel.put("C", 2);
        nodelevel.put("P", 2);
        nodelevel.put("F", 2);
        for (String string : cpf) {
            nodelevel.put(string, 3);
        }
        return nodelevel;
    }

    public ArrayList<String> getNodeInLevel(String level, TreeMap<String, Integer> nodelevel, Set<String> keys) {
        ArrayList<String> nodeinlvl = new ArrayList<String>();
        for (String string : keys) {
            Integer value = nodelevel.get(string);
            if (!value.toString().trim().equals(level.trim())) continue;
            nodeinlvl.add(string);
        }
        return nodeinlvl;
    }

    public TreeMap<String, Integer> putNodeWidth(TreeMap<String, Integer> nodelvlwidth, String level, ArrayList<String> nodeinlvl) {
        if (this.maxwidth < nodeinlvl.size()) {
            this.maxwidth = nodeinlvl.size();
        }
        for (String string : nodeinlvl) {
            nodelvlwidth.put(string.trim(), Integer.parseInt(level.trim()));
        }
        return nodelvlwidth;
    }

    public TreeMap<String, Integer> makeNodeWidth(TreeSet<String> nodelist, TreeMap<String, Integer> nodelevel) {
        TreeMap<String, Integer> nodelvlwidth = new TreeMap<String, Integer>();
        Set<String> keys = nodelevel.keySet();
        TreeSet<Integer> numoflvl = new TreeSet<Integer>();
        for (String string : keys) {
            numoflvl.add(nodelevel.get(string));
        }
        for (Integer integer : numoflvl) {
            ArrayList<String> nodeinlvl = this.getNodeInLevel(integer.toString(), nodelevel, keys);
            nodelvlwidth = this.putNodeWidth(nodelvlwidth, integer.toString(), nodeinlvl);
        }
        nodelvlwidth = this.makeLvl(numoflvl, nodelvlwidth);
        return nodelvlwidth;
    }

    public TreeMap<String, Integer> makeLvl(TreeSet<Integer> numoflvl, TreeMap<String, Integer> nodelvlwidth) {
        TreeMap<String, Integer> newnodelvlwidth = new TreeMap<String, Integer>();
        Set<String> keys = nodelvlwidth.keySet();
        for (Integer value : numoflvl) {
            this.counttmp(value, nodelvlwidth, keys, newnodelvlwidth);
        }
        return newnodelvlwidth;
    }

    public void counttmp(int lvl, TreeMap<String, Integer> nodelvlwidth, Set<String> keys, TreeMap<String, Integer> newnodelvlwidth) {
        int output = 1;
        for (String string : keys) {
            int value = nodelvlwidth.get(string);
            if (lvl != value) continue;
            newnodelvlwidth.put(string, output);
            ++output;
        }
    }

    public ArrayList<String> preCPF(String cGo, String pGo, String fGo) {
        String string;
        String[] cGos = cGo.split(";");
        String[] pGos = pGo.split(";");
        String[] fGos = fGo.split(";");
        ArrayList<String> cpf = new ArrayList<String>();
        String[] stringArray = cGos;
        int n = cGos.length;
        int n2 = 0;
        while (n2 < n) {
            string = stringArray[n2];
            cpf.add("C" + string);
            ++n2;
        }
        stringArray = pGos;
        n = pGos.length;
        n2 = 0;
        while (n2 < n) {
            string = stringArray[n2];
            cpf.add("P" + string);
            ++n2;
        }
        stringArray = fGos;
        n = fGos.length;
        n2 = 0;
        while (n2 < n) {
            string = stringArray[n2];
            cpf.add("F" + string);
            ++n2;
        }
        return cpf;
    }

    public ArrayList<String> preCPFDePen(String cGo, String pGo, String fGo) {
        String string;
        String[] cGos = cGo.split(";");
        String[] pGos = pGo.split(";");
        String[] fGos = fGo.split(";");
        ArrayList<String> cpf = new ArrayList<String>();
        String[] stringArray = cGos;
        int n = cGos.length;
        int n2 = 0;
        while (n2 < n) {
            string = stringArray[n2];
            cpf.add("C" + string + ",C");
            ++n2;
        }
        stringArray = pGos;
        n = pGos.length;
        n2 = 0;
        while (n2 < n) {
            string = stringArray[n2];
            cpf.add("P" + string + ",P");
            ++n2;
        }
        stringArray = fGos;
        n = fGos.length;
        n2 = 0;
        while (n2 < n) {
            string = stringArray[n2];
            cpf.add("F" + string + ",F");
            ++n2;
        }
        return cpf;
    }

    public static void main(String[] args) {
        GoGraph gg = new GoGraph();
        String cGo = "GO:0016021;GO:0005886;GO:0005524";
        String pGo = "GO:0005515;GO:0004674";
        String fGo = "GO:0004714;GO:0006468";
        ArrayList<String> cpf = gg.preCPF(cGo, pGo, fGo);
        ArrayList<String> cpfdepen = gg.preCPFDePen(cGo, pGo, fGo);
        gg.setMaxwidth(0);
        ArrayList<String> al = gg.loadGo(cpfdepen);
        TreeSet<String> nodelist = gg.makeNode(al);
        TreeMap<String, Integer> nodelevel = gg.makeNodeLeve(cpf);
        TreeMap<String, Integer> nodelvlwidth = gg.makeNodeWidth(nodelist, nodelevel);
        Set<String> keys = nodelvlwidth.keySet();
        for (String string : keys) {
        }
        Custom applet = new Custom(al, nodelist, nodelevel, nodelvlwidth, gg.getMaxwidth());
        applet.init();
        JFrame frame = new JFrame();
        frame.add(applet);
        frame.setTitle("Go graph");
        frame.setDefaultCloseOperation(3);
        frame.setSize(800, 600);
        frame.setVisible(true);
    }
}

