/*
 * Decompiled with CFR 0.152.
 */
package bean;

import bean.BareBonesBrowserLaunch;
import bean.ClustalW;
import bean.CmdExec;
import bean.Helpclass;
import bean.ReadFile;
import data.Projectdata;
import data.Sequencedata;
import java.io.File;
import java.io.PrintWriter;
import java.util.ArrayList;

public class MUSCLE {
    public static void make(ArrayList<Sequencedata> newsm, String mode) {
        PrintWriter pw;
        File fout;
        String clustalwpath = Projectdata.getPathSep("addsw");
        File f = new File(clustalwpath);
        if (!f.exists()) {
            f.mkdir();
        }
        boolean chk = true;
        int i = 0;
        String namehtml = "";
        String name = "";
        while (chk) {
            String clustalwpathsub = String.valueOf(Projectdata.getPathSep("addsw")) + "output" + i + System.getProperty("file.separator");
            File f1 = new File(clustalwpathsub);
            if (f1.exists()) {
                ++i;
                continue;
            }
            namehtml = String.valueOf(Projectdata.getPathSep("addsw")) + "output" + i + System.getProperty("file.separator");
            f1.mkdir();
            String clustalwpathsubSQ = String.valueOf(Projectdata.getPathSep("addsw")) + "output" + i + System.getProperty("file.separator") + "files" + System.getProperty("file.separator");
            File f2 = new File(clustalwpathsubSQ);
            f2.mkdir();
            chk = false;
            name = clustalwpathsubSQ;
        }
        String infile = String.valueOf(name) + "seq.fasta";
        String outfile = String.valueOf(name) + "seq.aln";
        String outhtml = String.valueOf(namehtml) + "output.html";
        ClustalW.writeallsqfile(name, "seq.fasta", newsm);
        String musclepath = String.valueOf(System.getProperty("user.dir")) + System.getProperty("file.separator") + "addsw" + System.getProperty("file.separator") + "MUSCLE" + System.getProperty("file.separator");
        String cmd = "muscle -in " + infile + " -out " + outfile + "  -quiet";
        CmdExec.runExec(cmd, false);
        String alnfile = String.valueOf(namehtml) + "files" + System.getProperty("file.separator") + "seq.aln";
        StringBuffer labelname = new StringBuffer();
        if (new File(alnfile).exists()) {
            String buf = ReadFile.readfile(alnfile, "Read aln file", "MUSCLE.java");
            if (mode.equals("precursor miRNAs")) {
                labelname.append("<table border='1'><tr><td>Map name</td><td>Full name</td></tr>");
                for (Sequencedata sequencedata : newsm) {
                    if (!sequencedata.isChecklabelalignment()) continue;
                    labelname.append("<tr><td>" + sequencedata.getName().replaceAll(">", "").trim() + "</td><td>" + sequencedata.getFullname().trim() + "</td></tr>");
                }
                labelname.append("</table>");
            } else {
                labelname.append("<table border='1'><tr><td>Map name</td><td>Full name</td></tr>");
                for (Sequencedata sequencedata : newsm) {
                    if (!sequencedata.isChecklabelalignment()) continue;
                    labelname.append("<tr><td>" + sequencedata.getName().replaceAll(">", "").trim() + " (input_sequence_" + sequencedata.getName().replaceAll(">", "").trim().split("#")[1] + ")</td><td>" + sequencedata.getFullname().trim() + "</td></tr>");
                }
                labelname.append("</table>");
            }
            try {
                fout = new File(alnfile);
                pw = new PrintWriter(fout);
                pw.println(buf);
                pw.flush();
                pw.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        String appletcode = String.valueOf(ClustalW.getApplet()) + labelname.toString();
        try {
            fout = new File(outhtml);
            pw = new PrintWriter(fout);
            pw.println(appletcode);
            pw.flush();
            pw.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String fcopy1 = String.valueOf(Projectdata.getPathSep("home")) + "addsw" + System.getProperty("file.separator") + "CLUSTALW" + System.getProperty("file.separator") + "jalviewapplet.jar";
        String fcopy1out = String.valueOf(namehtml) + "jalviewApplet.jar";
        File fexist = new File(fcopy1);
        if (fexist.exists()) {
            Helpclass.copyfile(fcopy1, fcopy1out);
        }
        BareBonesBrowserLaunch.openURL(outhtml);
    }
}

