/*
 * Decompiled with CFR 0.152.
 */
package cellRender;

import data.Projectdata;
import frame.ViewGG;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultCellEditor;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import visualizeation.DemoGG;

public class AnnotationButtonEditor
extends DefaultCellEditor {
    protected JButton button;
    private String label;
    private boolean isPushed;
    private ViewGG vf;
    private String seqname;
    private String filename;
    private String infile;

    public AnnotationButtonEditor(JCheckBox checkBox, ViewGG vfin) {
        super(checkBox);
        this.vf = vfin;
        this.button = new JButton();
        this.button.setOpaque(true);
        this.button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AnnotationButtonEditor.this.fireEditingStopped();
            }
        });
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.label = value == null ? "" : value.toString();
        ImageIcon ic = new ImageIcon("images" + System.getProperty("file.separator") + "GO.gif");
        this.button.setForeground(table.getSelectionForeground());
        this.button.setBackground(table.getSelectionBackground());
        this.button.setIcon(ic);
        this.seqname = String.valueOf(table.getValueAt(row, 3).toString().trim()) + "-" + table.getValueAt(row, 4).toString().trim();
        this.filename = String.valueOf(Projectdata.getPathSep("anotation")) + Projectdata.anotationname;
        this.infile = String.valueOf(Projectdata.getPathSep("anotation")) + this.seqname + ".xml";
        if (value.toString().equals("*")) {
            this.isPushed = false;
            this.button.setEnabled(false);
        } else {
            this.isPushed = true;
            this.button.setEnabled(true);
        }
        return this.button;
    }

    @Override
    public Object getCellEditorValue() {
        if (this.isPushed) {
            System.gc();
            this.vf.makewait("Viewing GOs network");
            this.vf.view();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Projectdata.autoclear();
                    JPanel p = AnnotationButtonEditor.this.vf.getP();
                    AnnotationButtonEditor.this.vf.removeAll();
                    p = DemoGG.getGG(AnnotationButtonEditor.this.filename, AnnotationButtonEditor.this.seqname, AnnotationButtonEditor.this.infile);
                    AnnotationButtonEditor.this.vf.add((Component)p, "Center");
                    AnnotationButtonEditor.this.vf.validate();
                    AnnotationButtonEditor.this.vf.view();
                }
            });
        }
        this.isPushed = false;
        return new String(this.label);
    }

    @Override
    public boolean stopCellEditing() {
        this.isPushed = false;
        return super.stopCellEditing();
    }

    @Override
    protected void fireEditingStopped() {
        super.fireEditingStopped();
    }
}

