/*
 * Decompiled with CFR 0.152.
 */
package cellRender;

import cellRender.AnnotationPanelRender;
import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.net.URI;
import javax.swing.DefaultCellEditor;
import javax.swing.JCheckBox;
import javax.swing.JEditorPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.plaf.basic.BasicEditorPaneUI;
import javax.swing.text.html.HTMLEditorKit;

public class AnnotationPanelEditor
extends DefaultCellEditor {
    Object value = "";
    AnnotationPanelRender apr;

    public AnnotationPanelEditor(JCheckBox checkBox, AnnotationPanelRender apr) {
        super(checkBox);
        this.apr = apr;
    }

    @Override
    public Object getCellEditorValue() {
        return this.value;
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.value = value;
        JEditorPane jep = new JEditorPane();
        jep.setContentType("text/html");
        jep.setEditorKit(new HTMLEditorKit());
        jep.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
        jep.setEditable(false);
        jep.setOpaque(true);
        if (UIManager.getLookAndFeel().getName().equals("Nimbus")) {
            Color selFG = jep.getSelectedTextColor();
            Color selBG = jep.getSelectionColor();
            jep.setUI(new BasicEditorPaneUI());
            jep.setSelectedTextColor(selFG);
            jep.setSelectionColor(selBG);
        }
        jep.setBackground(table.getSelectionBackground());
        jep.setForeground(table.getSelectionForeground());
        if (value.toString().equals("*")) {
            jep.setText("*");
            jep.setForeground(Color.gray);
        } else {
            String str = this.apr.makString(value.toString(), table, row, "no");
            jep.setText(str);
        }
        jep.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent hle) {
                if (HyperlinkEvent.EventType.ACTIVATED.equals(hle.getEventType())) {
                    Desktop d = Desktop.getDesktop();
                    try {
                        URI uri = hle.getURL().toURI();
                        d.browse(uri);
                    }
                    catch (Exception e1) {
                        e1.printStackTrace();
                    }
                }
            }
        });
        JTextField test = new JTextField();
        jep.setFont(test.getFont());
        return jep;
    }
}

