/*
 * Decompiled with CFR 0.152.
 */
package cellRender;

import data.Projectdata;
import frame.ViewFold;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.DefaultCellEditor;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JTable;

public class ButtonTargetEditor
extends DefaultCellEditor {
    protected JButton button;
    private String label;
    private String targetlabel;
    private boolean isPushed;
    private String stamsg;
    private String stalength;
    private String stamsg2;
    private ViewFold vf;
    private boolean mode = false;

    public void setMode(boolean mode) {
        this.mode = mode;
    }

    public ButtonTargetEditor(JCheckBox checkBox, ViewFold vfin) {
        super(checkBox);
        this.vf = vfin;
        this.button = new JButton();
        this.button.setOpaque(true);
        this.button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ButtonTargetEditor.this.fireEditingStopped();
            }
        });
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        ImageIcon ic = new ImageIcon("images" + System.getProperty("file.separator") + "folding_view.gif");
        this.button.setForeground(table.getSelectionForeground());
        this.button.setBackground(table.getSelectionBackground());
        this.button.setIcon(ic);
        this.targetlabel = this.label = value == null ? "" : value.toString();
        if (this.mode) {
            this.label = value.toString().split("#")[1].trim();
            String filename = String.valueOf(Projectdata.outfileSep("targetfolding")) + this.label + "_1.ps";
            File f = new File(filename);
            if (f.exists()) {
                this.button.setEnabled(true);
            } else {
                this.button.setEnabled(false);
            }
            this.stamsg = this.label;
            this.stalength = "";
            this.stamsg2 = "";
        } else {
            this.button.setText("");
            if (this.label.equals("NA")) {
                this.button.setEnabled(false);
            } else {
                this.button.setEnabled(true);
            }
            this.stamsg = this.label;
            this.stalength = "";
            this.stamsg2 = "";
        }
        this.isPushed = true;
        return this.button;
    }

    @Override
    public Object getCellEditorValue() {
        if (this.isPushed) {
            this.vf.viewImage1(this.stamsg, this.stalength, this.stamsg2, "foldingoutput", "*", "*");
        }
        this.isPushed = false;
        return new String(this.targetlabel);
    }

    @Override
    public boolean stopCellEditing() {
        this.isPushed = false;
        return super.stopCellEditing();
    }

    @Override
    protected void fireEditingStopped() {
        super.fireEditingStopped();
    }
}

