/*
 * Decompiled with CFR 0.152.
 */
package cellRender;

import data.ProjectTree;
import data.Projectdata;
import data.Sequencedata;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultCellEditor;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JTable;

public class SummaryButtonEditor
extends DefaultCellEditor {
    protected JButton button;
    private String label;
    private boolean isPushed;
    public String outputname;
    public String mode;
    private boolean vfview;

    public SummaryButtonEditor(JCheckBox checkBox, String outputname, String mode, boolean vfview) {
        super(checkBox);
        this.outputname = outputname;
        this.mode = mode;
        this.vfview = vfview;
        this.button = new JButton();
        this.button.setOpaque(true);
        this.button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SummaryButtonEditor.this.fireEditingStopped();
            }
        });
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        ImageIcon ic = new ImageIcon("images" + System.getProperty("file.separator") + "view_detail.gif");
        this.button.setForeground(table.getSelectionForeground());
        this.button.setBackground(table.getSelectionBackground());
        this.button.setIcon(ic);
        String string = this.label = value == null ? "" : value.toString();
        if (this.outputname.equals("All")) {
            this.button.setEnabled(false);
        } else {
            this.button.setEnabled(true);
        }
        this.isPushed = true;
        return this.button;
    }

    @Override
    public Object getCellEditorValue() {
        if (this.isPushed) {
            boolean tmpisbusy = Projectdata.isbusy;
            Projectdata.isbusy = true;
            Projectdata.chgcurrentproject(Projectdata.projectname, this.mode, true);
            Projectdata.isbusy = tmpisbusy;
            String fullname = Sequencedata.getFullname(Projectdata.sm, this.label.split("-")[0].trim());
            if (this.mode.equals("mirna")) {
                ProjectTree.setfoucusnode1leve3("Precursor miRNA folding", this.mode, this.outputname);
                Projectdata.plprefoldingdes.setSearchtxt(fullname);
            } else {
                ProjectTree.setfoucusnode1leve3("Target annotation", this.mode, this.outputname);
                Projectdata.planotationtargetdes.setSearchtxt(fullname, this.vfview);
            }
        }
        this.isPushed = false;
        return new String(this.label);
    }

    @Override
    public boolean stopCellEditing() {
        this.isPushed = false;
        return super.stopCellEditing();
    }

    @Override
    protected void fireEditingStopped() {
        super.fireEditingStopped();
    }
}

