/*
 * Decompiled with CFR 0.152.
 */
package chart;

import bean.ZipClass;
import cellRender.BooleanRender;
import cellRender.CheckBoxHeader;
import cellRender.DefaultGrayTableCellRenderer;
import cellRender.JLabelMapGOLink;
import cellRender.JLabelSortRender;
import cellRender.SummaryButtonEditor;
import cellRender.SummaryButtonRenderer;
import cellRender.TooltipPictureRenderAddon;
import data.Projectdata;
import data.Sequencedata;
import data.Summarysqdata;
import frame.ExportOptionSummary;
import frame.PreFoldingdes;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.RowSorter;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import listener.MyItemListener;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.CategoryLabelPositions;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.labels.CategoryItemLabelGenerator;
import org.jfree.chart.labels.CategoryToolTipGenerator;
import org.jfree.chart.labels.StandardCategoryItemLabelGenerator;
import org.jfree.chart.labels.StandardCategoryToolTipGenerator;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.BarRenderer;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.ui.ApplicationFrame;
import org.jfree.ui.RefineryUtilities;
import visualizeation.GoBuildPath;

public class BarChartDemo
extends ApplicationFrame {
    JFrame f;
    JTable sequencetable;
    TreeMap<String, TreeSet<String>> sequencetablets;
    JTable mirnatable;
    JTable sqdetailtable;
    JPanel godetailpanel;
    DefaultTableModel model;
    CategoryDataset clustomdatabase;
    int maxvalue = 0;

    public BarChartDemo(String title) {
        super(title);
    }

    public BarChartDemo(String title, boolean mode) {
        super(title);
        if (mode) {
            CategoryDataset dataset = this.createDataset();
            JFreeChart chart = this.createChart(dataset, 20);
            ChartPanel chartPanel = new ChartPanel(chart);
            this.setContentPane((Container)chartPanel);
        }
    }

    public JPanel make() {
        CategoryDataset dataset = this.getClustomdatabase();
        JFreeChart chart = this.createChart(dataset, this.maxvalue);
        ChartPanel chartPanel = new ChartPanel(chart);
        TitledBorder tb = new TitledBorder("GO summary");
        tb.setTitleColor(Color.blue);
        tb.setTitleFont(Projectdata.fnornmal);
        chartPanel.setBorder((Border)tb);
        JPanel pcenter = new JPanel();
        pcenter.setLayout(new BorderLayout());
        pcenter.add((Component)chartPanel, "Center");
        final JTable table = new JTable(this.model);
        table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (SwingUtilities.isLeftMouseButton(e)) {
                    Point p = e.getPoint();
                    int rowNumber = table.rowAtPoint(p);
                    int colNumber = table.columnAtPoint(p);
                    if (colNumber == 3) {
                        String gonum = table.getValueAt(rowNumber, 1).toString();
                        String filename = String.valueOf(Projectdata.getPathSep("anotation")) + Projectdata.anotationname;
                        TreeMap<String, TreeSet<String>> gomap = GoBuildPath.loadGo2SEQDic(filename);
                        TreeSet<String> seqlist = gomap.get(gonum);
                        if (BarChartDemo.this.f != null) {
                            BarChartDemo.this.f.dispose();
                        }
                        BarChartDemo.this.f = new JFrame("Sequences with " + gonum);
                        TitledBorder tb = new TitledBorder(LineBorder.createGrayLineBorder(), "");
                        tb.setTitleColor(Color.blue);
                        tb.setTitleFont(Projectdata.fnornmal);
                        DefaultTableModel model = new DefaultTableModel();
                        model.addColumn("");
                        model.addColumn("Sequence name");
                        model.addColumn("Sequence detail");
                        for (String seqname : seqlist) {
                            String fullname = Sequencedata.getFullname(Projectdata.sm, seqname.split("-")[0].trim());
                            Vector<String> r1 = new Vector<String>();
                            r1.add("1");
                            r1.add(fullname);
                            r1.add(seqname);
                            model.addRow(r1);
                        }
                        JTable table2 = new JTable(model);
                        table2.setAutoResizeMode(0);
                        table2.setRowHeight(30);
                        table2.getColumnModel().getColumn(0).setCellRenderer(new JLabelSortRender());
                        table2.getColumnModel().getColumn(1).setCellRenderer(new DefaultGrayTableCellRenderer());
                        table2.getColumnModel().getColumn(2).setCellRenderer(new SummaryButtonRenderer("NA", "NA"));
                        table2.getColumnModel().getColumn(2).setCellEditor(new SummaryButtonEditor(new JCheckBox(), Projectdata.anotationname, "target", true));
                        JScrollPane jsp = new JScrollPane(table2);
                        BarChartDemo.this.f.add(jsp);
                        BarChartDemo.this.f.pack();
                        BarChartDemo.this.f.setVisible(true);
                        int sizewd = jsp.getViewport().getWidth();
                        table2.getColumnModel().getColumn(0).setPreferredWidth(Projectdata.getFontWidth(String.valueOf(table2.getRowCount()) + " "));
                        table2.getColumnModel().getColumn(2).setPreferredWidth(50);
                        ArrayList<Integer> columns = new ArrayList<Integer>();
                        columns.add(0);
                        columns.add(2);
                        int usewd = Projectdata.gettablewidth(table2, jsp, columns);
                        int remainwd = sizewd - usewd;
                        table2.getColumnModel().getColumn(1).setPreferredWidth(remainwd);
                    }
                }
            }
        });
        TableRowSorter<TableModel> sorter = new TableRowSorter<TableModel>(table.getModel()){

            @Override
            public boolean isSortable(int column) {
                return column != 0;
            }
        };
        table.setRowSorter((RowSorter<? extends TableModel>)sorter);
        table.getColumnModel().getColumn(0).setCellRenderer(new JLabelSortRender());
        table.getColumnModel().getColumn(3).setCellRenderer(new JLabelMapGOLink());
        table.getColumnModel().getColumn(1).setCellRenderer(new DefaultGrayTableCellRenderer());
        table.getColumnModel().getColumn(2).setCellRenderer(new DefaultGrayTableCellRenderer());
        TitledBorder tb1 = new TitledBorder("GO detail");
        tb1.setTitleColor(Color.blue);
        tb1.setTitleFont(Projectdata.fnornmal);
        JPanel godetailpanel = new JPanel();
        godetailpanel.setBorder(tb1);
        godetailpanel.setLayout(new BorderLayout());
        godetailpanel.add(new JScrollPane(table));
        table.getColumnModel().getColumn(0).setPreferredWidth(Projectdata.getFontWidth(String.valueOf(this.model.getRowCount())));
        table.getColumnModel().getColumn(0).setMaxWidth(Projectdata.getFontWidth(String.valueOf(this.model.getRowCount())));
        table.getColumnModel().getColumn(0).setMinWidth(Projectdata.getFontWidth(String.valueOf(this.model.getRowCount())));
        table.getColumnModel().getColumn(1).setPreferredWidth(Projectdata.getFontWidth("GO:0005634xx"));
        table.getColumnModel().getColumn(1).setMaxWidth(Projectdata.getFontWidth("GO:0005634xx"));
        table.getColumnModel().getColumn(1).setMinWidth(Projectdata.getFontWidth("GO:0005634xx"));
        table.getColumnModel().getColumn(3).setPreferredWidth(Projectdata.getFontWidth("countxxxxxxx"));
        table.getColumnModel().getColumn(3).setMaxWidth(Projectdata.getFontWidth("countxxxxxxx"));
        table.getColumnModel().getColumn(3).setMinWidth(Projectdata.getFontWidth("countxxxxxxx"));
        pcenter.add((Component)godetailpanel, "East");
        return pcenter;
    }

    public void setSequencetablets(TreeMap<String, TreeSet<String>> sequencetablets) {
        this.sequencetablets = sequencetablets;
    }

    public void setMirnatable(JTable mirnatable) {
        this.mirnatable = mirnatable;
    }

    public JTable getMirnatable() {
        return this.mirnatable;
    }

    public void setSequencetable(JTable sequencetable) {
        this.sequencetable = sequencetable;
    }

    public JTable getSequencetable() {
        return this.sequencetable;
    }

    public void setSqDetailtable(JTable sqdetailtable) {
        this.sqdetailtable = sqdetailtable;
    }

    public JTable getSqDetailtable() {
        return this.sqdetailtable;
    }

    public JPanel makeSummary(String xlabel, String ylabel, String lableofgraph, String labeloftable, int max, String labelpanel, String outputname, final String mode) {
        this.model.getRowCount();
        CategoryDataset dataset = this.getClustomdatabase();
        JFreeChart chart = this.createChartSummary(dataset, max, ylabel, xlabel);
        ChartPanel chartPanel = new ChartPanel(chart);
        TitledBorder tb = new TitledBorder(LineBorder.createGrayLineBorder(), "");
        tb.setTitleColor(Color.blue);
        tb.setTitleFont(Projectdata.fnornmal);
        chartPanel.setBorder((Border)tb);
        JPanel pcenter = new JPanel();
        pcenter.setLayout(new BorderLayout());
        pcenter.add((Component)chartPanel, "Center");
        final JTable table = new JTable(this.model);
        table.getColumnModel().getColumn(0).setHeaderRenderer(new TooltipPictureRenderAddon("NA"));
        table.getColumnModel().getColumn(1).setHeaderRenderer(new TooltipPictureRenderAddon("NA"));
        table.getColumnModel().getColumn(2).setHeaderRenderer(new TooltipPictureRenderAddon("NA"));
        table.getColumnModel().getColumn(3).setHeaderRenderer(new TooltipPictureRenderAddon("Number of predicted sequences"));
        table.setAutoResizeMode(1);
        table.getTableHeader().setReorderingAllowed(false);
        TableRowSorter<TableModel> sorter = new TableRowSorter<TableModel>(table.getModel()){

            @Override
            public boolean isSortable(int column) {
                return column != 0;
            }
        };
        table.setRowSorter((RowSorter<? extends TableModel>)sorter);
        CheckBoxHeader checkboxheader = new CheckBoxHeader(new MyItemListener(table));
        checkboxheader.setSelected(Boolean.TRUE);
        table.getColumnModel().getColumn(0).setHeaderRenderer(checkboxheader);
        table.getColumnModel().getColumn(0).setCellRenderer(new BooleanRender());
        table.getColumnModel().getColumn(0).setCellEditor(table.getDefaultEditor(Boolean.class));
        table.getColumnModel().getColumn(1).setCellRenderer(new JLabelSortRender());
        table.getColumnModel().getColumn(2).setCellRenderer(new DefaultGrayTableCellRenderer());
        table.getColumnModel().getColumn(3).setCellRenderer(new DefaultGrayTableCellRenderer());
        table.getColumnModel().getColumn(0).setPreferredWidth(Projectdata.getCBWidth());
        table.getColumnModel().getColumn(1).setPreferredWidth(Projectdata.getFontWidth(String.valueOf(this.model.getRowCount())));
        table.getColumnModel().getColumn(2).setPreferredWidth(Projectdata.getFontWidth("miRNA family           "));
        table.getColumnModel().getColumn(3).setPreferredWidth(Projectdata.getFontWidth("NPS             "));
        table.setSelectionMode(0);
        table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent event) {
                if (event.getValueIsAdjusting()) {
                    return;
                }
                if (table.getSelectedColumn() != 3) {
                    return;
                }
            }
        });
        TitledBorder tb1 = new TitledBorder(LineBorder.createGrayLineBorder(), "");
        tb1.setTitleColor(Color.blue);
        tb1.setTitleFont(Projectdata.fnornmal);
        this.godetailpanel = new JPanel(new FlowLayout());
        this.godetailpanel.setBorder(tb1);
        this.godetailpanel.setLayout(new BorderLayout());
        JScrollPane js = new JScrollPane(table);
        table.setPreferredScrollableViewportSize(table.getPreferredSize());
        this.godetailpanel.add(js);
        pcenter.add((Component)this.godetailpanel, "East");
        TitledBorder tball = new TitledBorder(labelpanel);
        tball.setTitleColor(Color.blue);
        tball.setTitleFont(Projectdata.fnornmal);
        pcenter.setBorder(tball);
        JPanel menu = new JPanel(new FlowLayout(2));
        JButton btviewsq = new JButton();
        btviewsq.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                boolean dofilter = false;
                TreeSet<String> mirnalist = new TreeSet<String>();
                int rowcount = table.getRowCount();
                int i = 0;
                while (i < rowcount) {
                    Object cmp = table.getValueAt(i, 0);
                    if (cmp == Boolean.TRUE) {
                        dofilter = true;
                        String mirna = table.getValueAt(i, 2).toString();
                        mirnalist.add(mirna);
                    }
                    ++i;
                }
                if (dofilter) {
                    DefaultTableModel sequencetablemodel = (DefaultTableModel)BarChartDemo.this.sequencetable.getModel();
                    sequencetablemodel.getDataVector().removeAllElements();
                    sequencetablemodel.fireTableDataChanged();
                    DefaultTableModel mirnatablemodel = (DefaultTableModel)BarChartDemo.this.mirnatable.getModel();
                    mirnatablemodel.getDataVector().removeAllElements();
                    mirnatablemodel.fireTableDataChanged();
                    DefaultTableModel sqdetailtablemodel = (DefaultTableModel)BarChartDemo.this.sqdetailtable.getModel();
                    sqdetailtablemodel.getDataVector().removeAllElements();
                    sqdetailtablemodel.fireTableDataChanged();
                    TreeMap<String, TreeSet> sqmap = new TreeMap<String, TreeSet>();
                    TreeMap<String, TreeSet> mirnamap = new TreeMap<String, TreeSet>();
                    ArrayList<Summarysqdata> datamodel = new ArrayList<Summarysqdata>();
                    Set<Map.Entry<String, TreeSet<String>>> set = BarChartDemo.this.sequencetablets.entrySet();
                    for (Map.Entry<String, TreeSet<String>> me : set) {
                        String family = me.getKey().toString();
                        TreeSet<String> ts = BarChartDemo.this.sequencetablets.get(me.getKey());
                        if (!mirnalist.contains(me.getKey())) continue;
                        StringBuffer sbsq = new StringBuffer();
                        StringBuffer sbstrand = new StringBuffer();
                        String mirnaname = me.getKey().toString();
                        for (String string : ts) {
                            TreeSet tsmirna;
                            TreeSet mirnalistsub;
                            if (sqmap.containsKey(string)) {
                                mirnalistsub = (TreeSet)sqmap.get(string);
                                mirnalistsub.add(mirnaname);
                                sqmap.put(string, mirnalistsub);
                            } else {
                                mirnalistsub = new TreeSet();
                                mirnalistsub.add(mirnaname);
                                sqmap.put(string, mirnalistsub);
                            }
                            if (mirnamap.containsKey(mirnaname)) {
                                tsmirna = (TreeSet)mirnamap.get(mirnaname);
                                tsmirna.add(string);
                                mirnamap.put(mirnaname, tsmirna);
                                continue;
                            }
                            tsmirna = new TreeSet();
                            tsmirna.add(string);
                            mirnamap.put(mirnaname, tsmirna);
                        }
                    }
                    set = mirnamap.entrySet();
                    for (Map.Entry<String, TreeSet<String>> me : set) {
                        StringBuffer sbsq = new StringBuffer();
                        StringBuffer sbstrand = new StringBuffer();
                        String mirnaname = me.getKey().toString();
                        TreeSet ts = (TreeSet)mirnamap.get(mirnaname);
                        for (String sqname : ts) {
                            String name = sqname.split("-")[0].trim();
                            String strand = sqname.split("-")[1];
                            sbsq.append(String.valueOf(name) + ",");
                            sbstrand.append(String.valueOf(strand) + ",");
                        }
                        String sqappend = sbsq.toString().substring(0, sbsq.toString().length() - 1);
                        String string = sbstrand.toString().substring(0, sbstrand.toString().length() - 1);
                        Vector<Object> r1 = new Vector<Object>();
                        r1.addElement("1");
                        r1.addElement(mirnaname);
                        r1.addElement(sqappend);
                        r1.addElement(string);
                        r1.addElement(mirnaname);
                        mirnatablemodel.addRow(r1);
                    }
                    mirnatablemodel.fireTableDataChanged();
                    set = sqmap.entrySet();
                    for (Map.Entry<String, TreeSet<String>> me : set) {
                        String sqname = me.getKey().toString();
                        TreeSet mirnalistsub = (TreeSet)sqmap.get(sqname);
                        StringBuffer sb = new StringBuffer();
                        for (String name : mirnalistsub) {
                            sb.append(String.valueOf(name) + ",");
                        }
                        String mirnaappen = sb.toString().substring(0, sb.toString().length() - 1);
                        Summarysqdata sdata = new Summarysqdata(sqname, mirnaappen);
                        datamodel.add(sdata);
                    }
                    for (Summarysqdata sdata : datamodel) {
                        Vector<String> r1 = new Vector<String>();
                        r1.addElement("1");
                        String sqname = sdata.getSqname().split("-")[0].trim();
                        String strand = sdata.getSqname().split("-")[1];
                        r1.addElement(sqname);
                        r1.addElement(strand);
                        r1.addElement(sdata.getMirnafamily());
                        r1.addElement(sdata.getSqname());
                        sequencetablemodel.addRow(r1);
                        Vector<String> r2 = new Vector<String>();
                        r2.addElement("1");
                        r2.addElement(sqname);
                        r2.addElement(strand);
                        r2.addElement(sdata.getSqname());
                        sqdetailtablemodel.addRow(r2);
                    }
                    sequencetablemodel.fireTableDataChanged();
                    sqdetailtablemodel.fireTableDataChanged();
                } else {
                    JOptionPane.showMessageDialog(null, "Please select at least a miRNA to proceed", "Warning", 2);
                }
            }
        });
        btviewsq.setToolTipText("Filter");
        ImageIcon icviewsq = Projectdata.getICFilter();
        btviewsq.setPreferredSize(new Dimension(icviewsq.getIconWidth(), icviewsq.getIconHeight()));
        btviewsq.setIcon(icviewsq);
        btviewsq.setFont(Projectdata.fnornmal);
        JButton btexport = new JButton();
        btexport.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                Projectdata.sumexpsta = false;
                new ExportOptionSummary(null, true);
                if (Projectdata.sumexpsta) {
                    boolean tmpisbusy = Projectdata.isbusy;
                    Projectdata.isbusy = true;
                    Projectdata.chgcurrentproject(Projectdata.projectname, mode, true);
                    Projectdata.isbusy = tmpisbusy;
                    boolean exprt = true;
                    JFileChooser jf = new JFileChooser(String.valueOf(Projectdata.projectpath) + System.getProperty("file.separator") + Projectdata.projectname + System.getProperty("file.separator"));
                    PreFoldingdes.setFileChooserFont(jf.getComponents());
                    int r = jf.showDialog(null, "Save");
                    if (r == 0) {
                        String output3;
                        String exstr2;
                        String exstr1;
                        PrintWriter pwsq;
                        File sqf;
                        String savefilename;
                        String savepath = jf.getSelectedFile().getAbsolutePath();
                        ArrayList<String> ziplist = new ArrayList<String>();
                        StringBuffer sb1 = new StringBuffer();
                        sb1.append("miRNA family\tNumber of predicted sequences\n");
                        JTable tbexp = table;
                        int rowcount = tbexp.getRowCount();
                        int i = 0;
                        while (i < rowcount) {
                            String exstr22 = tbexp.getValueAt(i, 2).toString();
                            String exstr3 = tbexp.getValueAt(i, 3).toString();
                            String output2 = String.valueOf(exstr22) + "\t" + exstr3 + "\n";
                            sb1.append(output2);
                            ++i;
                        }
                        try {
                            savefilename = String.valueOf(Projectdata.getPathSep("home")) + "summary.txt";
                            sqf = new File(savefilename);
                            pwsq = new PrintWriter(sqf);
                            pwsq.println(sb1.toString());
                            pwsq.close();
                            ziplist.add("summary.txt");
                        }
                        catch (FileNotFoundException e) {
                            e.printStackTrace();
                            exprt = false;
                        }
                        if (Projectdata.gbsexp) {
                            sb1 = new StringBuffer();
                            sb1.append("Input sequence name\tStrand\tmiRNA family\n");
                            tbexp = BarChartDemo.this.getSequencetable();
                            rowcount = tbexp.getRowCount();
                            i = 0;
                            while (i < rowcount) {
                                exstr1 = tbexp.getValueAt(i, 1).toString();
                                exstr2 = tbexp.getValueAt(i, 2).toString();
                                exstr1 = Sequencedata.getFullname(Projectdata.sm, exstr1.trim());
                                String exstr3 = tbexp.getValueAt(i, 3).toString();
                                String[] exstr3s = exstr3.split(",");
                                int j = 0;
                                while (j < exstr3s.length) {
                                    output3 = String.valueOf(exstr1) + "\t" + exstr2 + "\t" + exstr3s[j] + "\n";
                                    sb1.append(output3);
                                    ++j;
                                }
                                ++i;
                            }
                            try {
                                savefilename = String.valueOf(Projectdata.getPathSep("home")) + "group_by_sequences.txt";
                                sqf = new File(savefilename);
                                pwsq = new PrintWriter(sqf);
                                pwsq.println(sb1.toString());
                                pwsq.close();
                                ziplist.add("group_by_sequences.txt");
                            }
                            catch (FileNotFoundException e) {
                                e.printStackTrace();
                                exprt = false;
                            }
                        }
                        if (Projectdata.gbmexp) {
                            StringBuffer sb2 = new StringBuffer();
                            sb2.append("miRNA family\tInput sequence name\tStrand\n");
                            tbexp = BarChartDemo.this.getMirnatable();
                            rowcount = tbexp.getRowCount();
                            i = 0;
                            while (i < rowcount) {
                                exstr1 = tbexp.getValueAt(i, 1).toString();
                                exstr2 = tbexp.getValueAt(i, 2).toString();
                                String[] mapsq = exstr2.split(",");
                                StringBuffer sbtmp = new StringBuffer();
                                String[] stringArray = mapsq;
                                int n = mapsq.length;
                                int output3 = 0;
                                while (output3 < n) {
                                    String name = stringArray[output3];
                                    sbtmp.append(String.valueOf(Sequencedata.getFullname(Projectdata.sm, name.trim())) + ",");
                                    ++output3;
                                }
                                exstr2 = sbtmp.toString().substring(0, sbtmp.toString().length() - 1);
                                String exstr3 = tbexp.getValueAt(i, 3).toString();
                                String[] exstr2s = exstr2.split(",");
                                String[] exstr3s = exstr3.split(",");
                                int j = 0;
                                while (j < exstr3s.length) {
                                    String output4 = String.valueOf(exstr1) + "\t" + exstr2s[j] + "\t" + exstr3s[j] + "\n";
                                    sb2.append(output4);
                                    ++j;
                                }
                                ++i;
                            }
                            try {
                                savefilename = String.valueOf(Projectdata.getPathSep("home")) + "group_by_miRNAs.txt";
                                sqf = new File(savefilename);
                                pwsq = new PrintWriter(sqf);
                                pwsq.println(sb2.toString());
                                pwsq.close();
                                ziplist.add("group_by_miRNAs.txt");
                            }
                            catch (FileNotFoundException e) {
                                e.printStackTrace();
                                exprt = false;
                            }
                        }
                        if (Projectdata.sqsumexp) {
                            StringBuffer sb3 = new StringBuffer();
                            sb3.append("Input sequence name\tStrand\tDetail\n");
                            tbexp = BarChartDemo.this.getSqDetailtable();
                            rowcount = tbexp.getRowCount();
                            i = 0;
                            while (i < rowcount) {
                                exstr1 = tbexp.getValueAt(i, 1).toString();
                                Sequencedata datatoclone = Projectdata.sqtm.get(">" + exstr1.trim());
                                Sequencedata data = null;
                                try {
                                    data = (Sequencedata)datatoclone.clone();
                                }
                                catch (CloneNotSupportedException sbtmp) {
                                    // empty catch block
                                }
                                exstr1 = Sequencedata.getFullname(Projectdata.sm, exstr1.trim());
                                String exstr23 = tbexp.getValueAt(i, 2).toString();
                                String exstr3 = tbexp.getValueAt(i, 3).toString();
                                data.setStrand(exstr23.trim());
                                exstr3 = data.getexportsq();
                                output3 = String.valueOf(exstr1) + "\t" + exstr23 + "\t" + exstr3 + "\n";
                                sb3.append(output3);
                                ++i;
                            }
                            try {
                                String savefilename2 = String.valueOf(Projectdata.getPathSep("home")) + "sequence_detail.txt";
                                sqf = new File(savefilename2);
                                pwsq = new PrintWriter(sqf);
                                pwsq.println(sb3.toString());
                                pwsq.close();
                                ziplist.add("sequence_detail.txt");
                            }
                            catch (FileNotFoundException e) {
                                e.printStackTrace();
                                exprt = false;
                            }
                        }
                        ZipClass.summaryzip(ziplist, String.valueOf(savepath) + ".zip");
                        if (exprt) {
                            JOptionPane.showMessageDialog(null, "Export complete.");
                        } else {
                            JOptionPane.showMessageDialog(null, "Error while export", "Error", 0);
                        }
                    }
                }
            }
        });
        btexport.setToolTipText("Export results");
        ImageIcon icexp = Projectdata.getICExport_result();
        btexport.setPreferredSize(new Dimension(icexp.getIconWidth(), icexp.getIconHeight()));
        btexport.setIcon(icexp);
        menu.add(btviewsq);
        menu.add(btexport);
        pcenter.add((Component)menu, "North");
        return pcenter;
    }

    private CategoryDataset getClustomdatabase() {
        return this.clustomdatabase;
    }

    private void setClustomdatabase(CategoryDataset clustomdatabase) {
        this.clustomdatabase = clustomdatabase;
    }

    public void createSummaryDataset(TreeMap<String, Integer> treecal) {
        DefaultCategoryDataset dataset = new DefaultCategoryDataset();
        this.model = new DefaultTableModel(){

            public Class getColumnClass(int column) {
                if (column >= 0 && column <= this.getColumnCount()) {
                    return this.getValueAt(0, column).getClass();
                }
                return Object.class;
            }

            @Override
            public boolean isCellEditable(int row, int col) {
                return col == 0;
            }
        };
        this.model.addColumn(" ");
        this.model.addColumn("");
        this.model.addColumn("miRNA family");
        this.model.addColumn("NPS");
        for (Map.Entry<String, Integer> entry : treecal.entrySet()) {
            dataset.addValue((double)Integer.parseInt(((Object)entry.getValue()).toString()), (Comparable)((Object)"TYPE"), (Comparable)((Object)entry.getKey().toString()));
            Vector<Object> r1 = new Vector<Object>();
            r1.addElement(Boolean.TRUE);
            r1.addElement("1");
            r1.addElement(entry.getKey().toString());
            r1.addElement(Integer.parseInt(((Object)entry.getValue()).toString()));
            this.model.addRow(r1);
        }
        this.setClustomdatabase((CategoryDataset)dataset);
    }

    public void createClustomDataset(TreeMap<String, Integer> treecal) {
        TreeMap<String, String> gomapcpf = GoBuildPath.loadGoCPF();
        String keyc = "C";
        String keyp = "P";
        String keyf = "F";
        DefaultCategoryDataset dataset = new DefaultCategoryDataset();
        TreeMap<String, String> gomapfunction2go = GoBuildPath.loadMapFunction();
        this.model = new DefaultTableModel(){

            public Class getColumnClass(int column) {
                if (column >= 0 && column <= this.getColumnCount()) {
                    return this.getValueAt(0, column).getClass();
                }
                return Object.class;
            }

            @Override
            public boolean isCellEditable(int row, int col) {
                return false;
            }
        };
        this.model.addColumn(" ");
        this.model.addColumn("GO ID");
        this.model.addColumn("GO term");
        this.model.addColumn("Counts");
        int max = 0;
        for (Map.Entry<String, Integer> entry : treecal.entrySet()) {
            String type = "C";
            if (gomapcpf.containsKey(entry.getKey().toString())) {
                type = gomapcpf.get(entry.getKey().toString());
            }
            dataset.addValue((double)Integer.parseInt(((Object)entry.getValue()).toString()), (Comparable)((Object)type), (Comparable)((Object)entry.getKey().toString()));
            ++max;
            Vector<Object> r1 = new Vector<Object>();
            r1.addElement("1");
            r1.addElement(entry.getKey().toString());
            String description = "-";
            if (gomapfunction2go.containsKey(entry.getKey().toString())) {
                description = gomapfunction2go.get(entry.getKey().toString());
            }
            r1.addElement(description);
            r1.addElement(Integer.parseInt(((Object)entry.getValue()).toString()));
            this.model.addRow(r1);
        }
        this.setClustomdatabase((CategoryDataset)dataset);
        this.maxvalue = max;
    }

    private CategoryDataset createDataset() {
        String series1 = "First";
        String series2 = "Second";
        String series3 = "Third";
        String category1 = "Category 1";
        String category2 = "Category 2";
        String category3 = "Category 3";
        String category4 = "Category 4";
        String category5 = "Category 5";
        DefaultCategoryDataset dataset = new DefaultCategoryDataset();
        dataset.addValue(1.0, (Comparable)((Object)"First"), (Comparable)((Object)"Category 1"));
        dataset.addValue(4.0, (Comparable)((Object)"First"), (Comparable)((Object)"Category 2"));
        dataset.addValue(3.0, (Comparable)((Object)"First"), (Comparable)((Object)"Category 3"));
        dataset.addValue(5.0, (Comparable)((Object)"First"), (Comparable)((Object)"Category 4"));
        dataset.addValue(5.0, (Comparable)((Object)"First"), (Comparable)((Object)"Category 5"));
        dataset.addValue(5.0, (Comparable)((Object)"Second"), (Comparable)((Object)"Category 1"));
        dataset.addValue(7.0, (Comparable)((Object)"Second"), (Comparable)((Object)"Category 2"));
        dataset.addValue(6.0, (Comparable)((Object)"Second"), (Comparable)((Object)"Category 3"));
        dataset.addValue(8.0, (Comparable)((Object)"Second"), (Comparable)((Object)"Category 4"));
        dataset.addValue(4.0, (Comparable)((Object)"Second"), (Comparable)((Object)"Category 5"));
        dataset.addValue(4.0, (Comparable)((Object)"Third"), (Comparable)((Object)"Category 1"));
        dataset.addValue(3.0, (Comparable)((Object)"Third"), (Comparable)((Object)"Category 2"));
        dataset.addValue(2.0, (Comparable)((Object)"Third"), (Comparable)((Object)"Category 3"));
        dataset.addValue(3.0, (Comparable)((Object)"Third"), (Comparable)((Object)"Category 4"));
        dataset.addValue(6.0, (Comparable)((Object)"Third"), (Comparable)((Object)"Category 5"));
        return dataset;
    }

    private JFreeChart createChart(CategoryDataset dataset, int max) {
        JFreeChart chart = ChartFactory.createBarChart3D((String)"", (String)"GO ID", (String)"Number of targets found with specific GO ID", (CategoryDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
        CategoryPlot plot = chart.getCategoryPlot();
        CategoryAxis axis = plot.getDomainAxis();
        axis.setCategoryLabelPositions(CategoryLabelPositions.createUpRotationLabelPositions((double)0.39269908169872414));
        if (max > 10) {
            axis.setVisible(false);
        } else {
            axis.setVisible(true);
        }
        NumberAxis rangeAxis = (NumberAxis)plot.getRangeAxis();
        rangeAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        plot.setRangeAxis((ValueAxis)rangeAxis);
        plot.getRenderer().setBaseItemLabelGenerator((CategoryItemLabelGenerator)new StandardCategoryItemLabelGenerator());
        plot.getRenderer().setBaseItemLabelsVisible(false);
        final TreeMap<String, String> gomapfunction2go = GoBuildPath.loadMapFunction();
        StandardCategoryToolTipGenerator toolTipGenerator = new StandardCategoryToolTipGenerator(){

            public String generateToolTip(CategoryDataset arg0, int arg1, int arg2) {
                String goterm = arg0.getColumnKey(arg2).toString().trim();
                if (gomapfunction2go.containsKey(arg0.getColumnKey(arg2).toString().trim())) {
                    goterm = (String)gomapfunction2go.get(arg0.getColumnKey(arg2).toString().trim());
                }
                String count = ("" + arg0.getValue(arg1, arg2)).trim().replaceAll(".0", "");
                return arg0.getColumnKey(arg2) + " (" + goterm + ") = " + count;
            }
        };
        plot.getRenderer().setBaseToolTipGenerator((CategoryToolTipGenerator)toolTipGenerator);
        return chart;
    }

    private JFreeChart createChartSummary(CategoryDataset dataset, int max, String xlabel, String ylabel) {
        JFreeChart chart = ChartFactory.createBarChart3D((String)"", (String)xlabel, (String)ylabel, (CategoryDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)true, (boolean)false);
        CategoryPlot plot = chart.getCategoryPlot();
        CategoryAxis axis = plot.getDomainAxis();
        CategoryAxis xline = plot.getDomainAxis();
        if (max > 10) {
            xline.setTickLabelPaint((Paint)Color.white);
            xline.setTickLabelFont(new Font(" Tahoma ", 1, 1));
        } else {
            axis.setCategoryLabelPositions(CategoryLabelPositions.createUpRotationLabelPositions((double)0.39269908169872414));
        }
        NumberAxis rangeAxis = (NumberAxis)plot.getRangeAxis();
        rangeAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        plot.setRangeAxis((ValueAxis)rangeAxis);
        return chart;
    }

    public static void main(String[] args) {
        BarChartDemo demo = new BarChartDemo("Bar Chart Demo", true);
        demo.pack();
        RefineryUtilities.centerFrameOnScreen((Window)((Object)demo));
        demo.setVisible(true);
    }

    static class CustomBarRenderer
    extends BarRenderer {
        private static final long serialVersionUID = 1L;

        CustomBarRenderer() {
        }

        public Paint getItemPaint(int i, int j) {
            return Color.blue;
        }
    }
}

