/*
 * Decompiled with CFR 0.152.
 */
package data;

import data.Projectdata;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;

public class Anotateparameter {
    String dbname;
    String noofthread;
    String evalue;
    String hitvalue;

    public String getHitvalue() {
        return this.hitvalue;
    }

    public void setHitvalue(String hitvalue) {
        this.hitvalue = hitvalue;
    }

    public String getEvalue() {
        return this.evalue;
    }

    public void setEvalue(String evalue) {
        this.evalue = evalue;
    }

    public String getDbname() {
        return this.dbname;
    }

    public String getFullDbname() {
        String output = "";
        if (this.dbname.equals("uniprot_sprot")) {
            output = "UniProt/Swiss-Prot";
        }
        if (this.dbname.equals("uniprot_sprot_plants")) {
            output = "UniProt/Swiss-Prot (Plants only)";
        }
        if (this.dbname.equals("uniprot_trembl_plants")) {
            output = "UniProt/TrEMBL (Plants only)";
        }
        return output;
    }

    public void setDbname(String dbname) {
        this.dbname = dbname;
    }

    public String getNoofthread() {
        return this.noofthread;
    }

    public void setNoofthread(String noofthread) {
        this.noofthread = noofthread;
    }

    public void save(String name) {
        String filename = String.valueOf(Projectdata.getPathSep("anotation")) + name + ".paramenter";
        this.savefile(filename);
    }

    public void savefile(String filename) {
        BufferedWriter bufferedWriter = null;
        try {
            try {
                bufferedWriter = new BufferedWriter(new FileWriter(filename));
                String str = "dbname;" + this.getDbname();
                bufferedWriter.write(str);
                bufferedWriter.newLine();
                str = "evalue;" + this.getEvalue();
                bufferedWriter.write(str);
                bufferedWriter.newLine();
                str = "hit;" + this.getHitvalue();
                bufferedWriter.write(str);
                bufferedWriter.newLine();
                str = "noofthread;" + this.getNoofthread();
                bufferedWriter.write(str);
                bufferedWriter.newLine();
            }
            catch (FileNotFoundException ex) {
                ex.printStackTrace();
                try {
                    if (bufferedWriter != null) {
                        bufferedWriter.flush();
                        bufferedWriter.close();
                    }
                }
                catch (IOException ex2) {
                    ex2.printStackTrace();
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
                try {
                    if (bufferedWriter != null) {
                        bufferedWriter.flush();
                        bufferedWriter.close();
                    }
                }
                catch (IOException ex3) {
                    ex3.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (bufferedWriter != null) {
                    bufferedWriter.flush();
                    bufferedWriter.close();
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    public String getParameterTxt() {
        StringBuffer sb = new StringBuffer();
        String str = "Search method;BLASTX";
        sb.append(String.valueOf(str) + "\n");
        str = "E-value;" + this.getEvalue();
        sb.append(String.valueOf(str) + "\n");
        str = "Database name;" + this.getDbname();
        sb.append(String.valueOf(str) + "\n");
        return sb.toString();
    }

    public static Anotateparameter loadparameter(String name) {
        String filename = String.valueOf(Projectdata.getPathSep("anotation")) + name + ".paramenter";
        return Anotateparameter.load(filename);
    }

    public static Anotateparameter load(String filename) {
        Anotateparameter data = new Anotateparameter();
        data.setEvalue("1e-20");
        try {
            File f = new File(filename);
            if (f.exists()) {
                String output;
                FileReader fr = new FileReader(f);
                BufferedReader br = new BufferedReader(fr);
                while ((output = br.readLine()) != null) {
                    String[] tmp = output.split(";");
                    if (tmp[0].trim().equals("dbname")) {
                        data.setDbname(tmp[1].trim());
                    }
                    if (tmp[0].trim().equals("evalue")) {
                        data.setEvalue(tmp[1].trim());
                    }
                    if (tmp[0].trim().equals("hit")) {
                        data.setHitvalue(tmp[1].trim());
                    }
                    if (!tmp[0].trim().equals("noofthread")) continue;
                    data.setNoofthread(tmp[1].trim());
                }
                br.close();
                fr.close();
            } else {
                data.setDbname("1e-20");
                data.setEvalue("1e-20");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return data;
    }
}

