/*
 * Decompiled with CFR 0.152.
 */
package data;

import java.io.File;
import javax.swing.filechooser.FileFilter;

public class ExtensionFileFilter
extends FileFilter {
    String description;
    String[] extensions;

    public ExtensionFileFilter(String description, String extension) {
        this(description, new String[]{extension});
    }

    public ExtensionFileFilter(String description, String[] extensions) {
        this.description = description == null ? extensions[0] : description;
        this.extensions = (String[])extensions.clone();
        this.toLower(this.extensions);
    }

    private void toLower(String[] array) {
        int i = 0;
        int n = array.length;
        while (i < n) {
            array[i] = array[i].toLowerCase();
            ++i;
        }
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public boolean accept(File file) {
        if (file.isDirectory()) {
            return true;
        }
        String path = file.getAbsolutePath().toLowerCase();
        int i = 0;
        int n = this.extensions.length;
        while (i < n) {
            String extension = this.extensions[i];
            if (path.endsWith(extension) && path.charAt(path.length() - extension.length() - 1) == '.') {
                return true;
            }
            ++i;
        }
        return false;
    }
}

