/*
 * Decompiled with CFR 0.152.
 */
package data;

import data.Projectdata;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;

public class Foldingdata {
    String sqname;
    int thread;
    boolean isblastx;
    boolean isblastn;
    int max;
    int maxbp = 0;
    int maxloop;
    String blasxdb;
    String blasndb;
    String evalue1;
    String evalue2;

    public String toString() {
        return "Foldingdata [evalue1=" + this.evalue1 + ", evalue2=" + this.evalue2 + "]";
    }

    public String getEvalue1() {
        return this.evalue1;
    }

    public void setEvalue1(String evalue1) {
        this.evalue1 = evalue1;
    }

    public String getEvalue2() {
        return this.evalue2;
    }

    public void setEvalue2(String evluae2) {
        this.evalue2 = evluae2;
    }

    public int getThread() {
        return this.thread;
    }

    public void setThread(int thread) {
        this.thread = thread;
    }

    public boolean isIsblastx() {
        return this.isblastx;
    }

    public int getMax() {
        return this.max;
    }

    public void setMax(int max) {
        this.max = max;
    }

    public int getMaxbp() {
        return this.maxbp;
    }

    public void setMaxbp(int maxbp) {
        this.maxbp = maxbp;
    }

    public int getMaxloop() {
        return this.maxloop;
    }

    public void setMaxloop(int maxloop) {
        this.maxloop = maxloop;
    }

    public void setIsblastx(boolean isblastx) {
        this.isblastx = isblastx;
    }

    public boolean isIsblastn() {
        return this.isblastn;
    }

    public void setIsblastn(boolean isblastn) {
        this.isblastn = isblastn;
    }

    public String getBlasxdb() {
        return this.blasxdb;
    }

    public void setBlasxdb(String blasxdb) {
        this.blasxdb = blasxdb;
    }

    public String getBlasndb() {
        return this.blasndb;
    }

    public String getFullBlasxdb() {
        String output = "";
        if (this.blasxdb.equals("uniprot_sprot")) {
            output = "UniProt/Swiss-Prot";
        }
        if (this.blasxdb.equals("uniprot_sprot_plants")) {
            output = "UniProt/Swiss-Prot (Plants only)";
        }
        if (this.blasxdb.equals("uniprot_trembl_plants")) {
            output = "UniProt/TrEMBL (Plants only)";
        }
        return output;
    }

    public void setBlasndb(String blasndb) {
        this.blasndb = blasndb;
    }

    public String getSqname() {
        return this.sqname;
    }

    public void setSqname(String sqname) {
        this.sqname = sqname;
    }

    public String getParameterTxt() {
        StringBuffer sb = new StringBuffer();
        String str = "";
        if (this.isIsblastn()) {
            str = "BLASTN database;" + this.getBlasndb();
            sb.append(String.valueOf(str) + "\n");
        }
        if (this.isIsblastx()) {
            str = "BLASTX database;" + this.getBlasxdb();
            sb.append(String.valueOf(str) + "\n");
        }
        str = "Temperature;" + this.getMax();
        sb.append(String.valueOf(str) + "\n");
        str = "Maximum basepair distance;" + this.getMaxbp();
        sb.append(String.valueOf(str) + "\n");
        str = "Maximum blug/interior loop size;" + this.getMaxloop();
        sb.append(String.valueOf(str) + "\n");
        return sb.toString();
    }

    public String getParameterPreTxt() {
        StringBuffer sb = new StringBuffer();
        String str = "";
        if (this.isIsblastn()) {
            str = "BLASTN database;" + this.getBlasndb();
            sb.append(String.valueOf(str) + "\n");
        }
        if (this.isIsblastx()) {
            str = "BLASTX database;" + this.getBlasxdb();
            sb.append(String.valueOf(str) + "\n");
        }
        str = "Maximum distance between paired bases;" + this.getMaxbp();
        sb.append(String.valueOf(str) + "\n");
        str = "Maximum blug/interior loop size;" + this.getMaxloop();
        sb.append(String.valueOf(str) + "\n");
        return sb.toString();
    }

    public String getParameterTargetTxt() {
        StringBuffer sb = new StringBuffer();
        String str = "";
        str = "Temperature;" + this.getMax();
        sb.append(String.valueOf(str) + "\n");
        return sb.toString();
    }

    public void save(String mode) {
        String filename = String.valueOf(Projectdata.getPathSep(mode)) + this.getSqname().trim() + ".foldparamenter";
        this.save(mode, filename);
    }

    public void save(String mode, String filename) {
        BufferedWriter bufferedWriter = null;
        try {
            try {
                bufferedWriter = new BufferedWriter(new FileWriter(filename));
                String str = "isblastn;" + this.isIsblastn();
                bufferedWriter.write(str);
                bufferedWriter.newLine();
                str = "isblastx;" + this.isIsblastx();
                bufferedWriter.write(str);
                bufferedWriter.newLine();
                str = "ndb;" + this.getBlasndb();
                bufferedWriter.write(str);
                bufferedWriter.newLine();
                str = "xdb;" + this.getBlasxdb();
                bufferedWriter.write(str);
                bufferedWriter.newLine();
                str = "max;" + this.getMax();
                bufferedWriter.write(str);
                bufferedWriter.newLine();
                str = "maxbb;" + this.getMaxbp();
                bufferedWriter.write(str);
                bufferedWriter.newLine();
                str = "maxloop;" + this.getMaxloop();
                bufferedWriter.write(str);
                bufferedWriter.newLine();
                str = "noofthread;" + this.getThread();
                bufferedWriter.write(str);
                bufferedWriter.newLine();
                str = "evalue1;" + this.getEvalue1();
                bufferedWriter.write(str);
                bufferedWriter.newLine();
                str = "evalue2;" + this.getEvalue2();
                bufferedWriter.write(str);
                bufferedWriter.newLine();
            }
            catch (FileNotFoundException ex) {
                ex.printStackTrace();
                try {
                    if (bufferedWriter != null) {
                        bufferedWriter.flush();
                        bufferedWriter.close();
                    }
                }
                catch (IOException ex2) {
                    ex2.printStackTrace();
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
                try {
                    if (bufferedWriter != null) {
                        bufferedWriter.flush();
                        bufferedWriter.close();
                    }
                }
                catch (IOException ex3) {
                    ex3.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (bufferedWriter != null) {
                    bufferedWriter.flush();
                    bufferedWriter.close();
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    public static Foldingdata loadparameter(String mode, String name) {
        String filename = String.valueOf(Projectdata.getPathSep(mode)) + name.trim() + ".foldparamenter";
        return Foldingdata.loadparameter(filename);
    }

    public static Foldingdata loadparameter(String filename) {
        Foldingdata data = new Foldingdata();
        try {
            File f = new File(filename);
            if (f.exists()) {
                String output;
                FileReader fr = new FileReader(f);
                BufferedReader br = new BufferedReader(fr);
                while ((output = br.readLine()) != null) {
                    String[] tmp = output.split(";");
                    if (tmp[0].equals("isblastn")) {
                        data.setIsblastn(Boolean.parseBoolean(tmp[1].trim()));
                    }
                    if (tmp[0].equals("isblastx")) {
                        data.setIsblastx(Boolean.parseBoolean(tmp[1].trim()));
                    }
                    if (tmp[0].equals("ndb")) {
                        data.setBlasndb(tmp[1].trim());
                    }
                    if (tmp[0].equals("xdb")) {
                        data.setBlasxdb(tmp[1].trim());
                    }
                    if (tmp[0].equals("max")) {
                        data.setMax(Integer.parseInt(tmp[1].trim()));
                    }
                    if (tmp[0].equals("maxbb")) {
                        data.setMaxbp(Integer.parseInt(tmp[1].trim()));
                    }
                    if (tmp[0].equals("maxloop")) {
                        data.setMaxloop(Integer.parseInt(tmp[1].trim()));
                    }
                    if (tmp[0].equals("noofthread")) {
                        data.setThread(Integer.parseInt(tmp[1].trim()));
                    }
                    if (tmp[0].equals("evalue1")) {
                        data.setEvalue1(tmp[1].trim());
                    }
                    if (!tmp[0].equals("evalue2")) continue;
                    data.setEvalue2(tmp[1].trim());
                }
                br.close();
                fr.close();
            } else {
                data.setIsblastn(false);
                data.setIsblastx(false);
                data.setMax(0);
                data.setMaxbp(0);
                data.setMaxloop(0);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return data;
    }
}

