/*
 * Decompiled with CFR 0.152.
 */
package frame;

import bean.AnotationOutput;
import bean.CheckDbInstall;
import bean.Helpclass;
import bean.ReadFile;
import data.Anotateparameter;
import data.Projectdata;
import data.Systeminfo;
import frame.Homolog;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;

public class Annotation
extends JDialog {
    private static final long serialVersionUID = 1L;
    JTextField tfevalue;

    public Annotation(Frame owner, boolean modal) {
        super(owner, modal);
        this.setTitle("Target annotation");
        JPanel p0 = new JPanel(new FlowLayout(2));
        ImageIcon ic = new ImageIcon("images" + System.getProperty("file.separator") + "annotation.gif");
        JLabel lbheader = new JLabel("Target annotation");
        p0.add(lbheader);
        p0.add(new JLabel(ic));
        p0.setBackground(Color.white);
        p0.setBorder(new TitledBorder(""));
        JPanel p1 = new JPanel();
        TitledBorder tb = new TitledBorder("Target annotation parameters");
        tb.setTitleColor(Color.blue);
        tb.setTitleFont(Projectdata.fnornmal);
        p1.setBorder(tb);
        this.setLayout(new BorderLayout());
        JPanel p11 = new JPanel();
        p11.setLayout(new GridLayout(1, 2));
        p11.add(new JLabel("E value"));
        final JTextField jt = new JTextField(5);
        jt.setText("10");
        p11.add(jt);
        p11.setVisible(false);
        JPanel p12 = new JPanel();
        p12.setLayout(new GridLayout(1, 2));
        p12.add(new JLabel("Word size"));
        String[] s = new String[]{"4"};
        JComboBox<String> cb = new JComboBox<String>(s);
        p12.add(cb);
        p12.setVisible(false);
        JPanel p13 = new JPanel();
        p13.setLayout(new GridLayout(1, 2));
        p13.add(new JLabel("mismatch "));
        String[] s1 = new String[]{"0", "<=1", "<=2", "<=3", "<=4"};
        final JComboBox<String> cb1 = new JComboBox<String>(s1);
        p13.add(cb1);
        int tcount = Integer.parseInt(new Systeminfo().getCpunum());
        Object[] ts = new Object[]{"1", "2", "3", "4", "5", "6", "7", "8", "9"};
        if (tcount < 9) {
            ArrayList<String> al = new ArrayList<String>();
            int i = 1;
            while (i <= tcount) {
                al.add(Integer.toString(i));
                ++i;
            }
            ts = al.toArray();
        }
        cb1.setSelectedItem("<=4");
        Object[] s2 = new Object[]{"UniProt/Swiss-Prot", "UniProt/Swiss-Prot (Plants only)", "UniProt/TrEMBL (Plants only)"};
        CheckDbInstall cdbins = new CheckDbInstall();
        if (cdbins.getUniprot_sprot().booleanValue() || cdbins.getUniprot_sprot_plant().booleanValue() || cdbins.getUniprot_sprot_trembl().booleanValue()) {
            s2 = cdbins.getListBLASTX();
        }
        final JComboBox<Object> cb3 = new JComboBox<Object>(s2);
        cb3.setFont(Projectdata.fnornmal);
        JLabel labelcb1 = new JLabel("BLASTX.\t");
        labelcb1.setFont(Projectdata.fnornmal);
        JLabel labelcb11 = new JLabel("\tAnnotate against database\t");
        labelcb11.setFont(Projectdata.fnornmal);
        Box p14 = Box.createVerticalBox();
        final JComboBox<Object> tcb = new JComboBox<Object>(ts);
        tcb.setFont(Projectdata.fnornmal);
        JLabel thread = new JLabel("Number of processors       ");
        thread.setFont(Projectdata.fnornmal);
        JPanel p141 = new JPanel(new FlowLayout(0));
        p141.add(labelcb11);
        p141.add(cb3);
        JPanel p142 = new JPanel(new FlowLayout(0));
        p142.add(thread);
        p142.add(tcb);
        JLabel labelcb111 = new JLabel("E-value                                    ");
        labelcb111.setFont(Projectdata.fnornmal);
        this.tfevalue = new JTextField(5);
        this.tfevalue.setText("1e-20");
        this.tfevalue.setFont(Projectdata.fnornmal);
        JPanel p143 = new JPanel(new FlowLayout(0));
        p143.add(labelcb111);
        p143.add(this.tfevalue);
        JPanel p144 = new JPanel(new FlowLayout(0));
        JLabel maxdis = new JLabel("Maximum number of hits    ");
        maxdis.setFont(Projectdata.fnornmal);
        Object[] tshit = new Object[]{"1", "2", "3", "4", "5"};
        final JComboBox<Object> cbhit = new JComboBox<Object>(tshit);
        cbhit.setSelectedIndex(4);
        cbhit.setFont(Projectdata.fnornmal);
        p144.add(maxdis);
        p144.add(cbhit);
        p14.add(p143);
        p14.add(p141);
        p14.add(p144);
        p14.add(p142);
        Systeminfo info = Projectdata.info;
        Box pinpjut = Box.createVerticalBox();
        pinpjut.add(p14);
        JLabel msg = new JLabel();
        msg.setForeground(Color.red);
        msg.setVisible(false);
        final JButton bt = new JButton("Search");
        bt.setFont(Projectdata.fnornmal);
        bt.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                String input = jt.getText();
                boolean check = false;
                String strmismatch = cb1.getSelectedItem().toString();
                strmismatch = strmismatch.replaceAll("<=", "").trim();
                String nothread = tcb.getSelectedItem().toString();
                String evalue = Annotation.this.tfevalue.getText();
                if (Helpclass.isIntNumber(evalue) || Homolog.checkevalue(evalue).booleanValue()) {
                    check = true;
                }
                if (check) {
                    Anotateparameter ap = new Anotateparameter();
                    ap.setNoofthread(nothread);
                    String blastxdb = cb3.getSelectedItem().toString();
                    if (blastxdb.equals("UniProt/Swiss-Prot")) {
                        ap.setDbname("uniprot_sprot");
                    }
                    if (blastxdb.equals("UniProt/Swiss-Prot (Plants only)")) {
                        ap.setDbname("uniprot_sprot_plants");
                    }
                    if (blastxdb.equals("UniProt/TrEMBL (Plants only)")) {
                        ap.setDbname("uniprot_trembl_plants");
                    }
                    ap.setEvalue(evalue);
                    ap.setHitvalue(cbhit.getSelectedItem().toString());
                    Projectdata.anotationfd = ap;
                    Projectdata.isanotationpa = true;
                    Annotation.this.setVisible(false);
                } else {
                    JOptionPane.showMessageDialog(null, "Please check E-value (<100)", "Warning", 2);
                }
            }
        });
        JPanel pbutton = new JPanel();
        JButton btclose = new JButton("Cancel");
        btclose.setFont(Projectdata.fnornmal);
        pbutton.add(bt);
        pbutton.add(btclose);
        pinpjut.add(pbutton);
        btclose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                Projectdata.isanotationpa = false;
                Annotation.this.dispose();
            }
        });
        p1.setLayout(new BorderLayout());
        JPanel ptmp = new JPanel();
        ptmp.add(pinpjut);
        p1.add((Component)ptmp, "Center");
        this.add((Component)p0, "North");
        this.add((Component)p1, "Center");
        this.add((Component)msg, "South");
        this.pack();
        this.setLocationByPlatform(true);
        Helpclass.enterPressesWhenFocused(bt);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent e) {
                bt.requestFocus();
            }
        });
        this.setVisible(true);
    }

    public static void main(String[] args) {
        final JFrame f = new JFrame();
        f.setLayout(new FlowLayout());
        JButton bt = new JButton("test");
        bt.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                new Annotation((Frame)f, true);
            }
        });
        f.add(bt);
        f.setSize(200, 100);
        f.getContentPane().setBackground(Color.white);
        f.setVisible(true);
        f.setDefaultCloseOperation(3);
    }

    public static Boolean checkevalue(String value) {
        Boolean check = true;
        String[] sectionevalue = value.split("-");
        if (sectionevalue.length != 2) {
            check = false;
        } else {
            String firstsection = sectionevalue[0].trim();
            String secondvalue = sectionevalue[1].trim();
            if (!firstsection.equals("e") && !firstsection.equals("E")) {
                check = false;
            }
            try {
                Integer.parseInt(secondvalue);
            }
            catch (Exception e) {
                check = false;
            }
        }
        return check;
    }

    public static String convertevalue(String value) {
        StringBuffer sb = new StringBuffer();
        String[] sectionevalue = value.split("-");
        String secondvalue = sectionevalue[1].trim();
        int count = Integer.parseInt(secondvalue);
        sb.append("1.");
        int i = 0;
        while (i < count - 1) {
            sb.append("0");
            ++i;
        }
        sb.append("1");
        return sb.toString();
    }

    public static ArrayList<AnotationOutput> load(String name, boolean filter) {
        String[] output_split;
        ArrayList<AnotationOutput> datas = new ArrayList<AnotationOutput>();
        String filename = String.valueOf(Projectdata.getPathSep("anotation")) + name + "-post";
        String outputs = ReadFile.readfile(filename, "Read annotatin post result", "AnotationTargetdes.java");
        String[] stringArray = output_split = outputs.split("\n");
        int n = output_split.length;
        int n2 = 0;
        while (n2 < n) {
            String output = stringArray[n2];
            String[] op = output.split("\t");
            boolean resultfilter = true;
            if (filter && op[3].trim().equals("*")) {
                resultfilter = false;
            }
            if (resultfilter) {
                AnotationOutput data = new AnotationOutput();
                data.setNo(op[0].trim());
                data.setMirna(op[1].trim());
                data.setProteinshit(op[3].trim());
                String[] inputAndStrands = op[2].trim().split("-");
                String inputsequence = inputAndStrands[0].trim();
                String strand = inputAndStrands[1].trim();
                data.setTargetname(inputsequence);
                data.setStarnd(strand);
                datas.add(data);
            }
            ++n2;
        }
        return datas;
    }
}

