/*
 * Decompiled with CFR 0.152.
 */
package frame;

import bean.ReadFile;
import data.AnotationExportdata;
import data.Foldingoutput;
import data.Homologoutputdata;
import data.Projectdata;
import frame.TargetFoldingdes;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.TreeMap;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;

public class AnotationExportOption
extends JDialog {
    public AnotationExportOption(Frame owner, boolean modal) {
        super(owner, modal);
        this.setTitle("Export options");
        this.setLayout(new BorderLayout());
        TitledBorder tb = new TitledBorder("Select export options");
        tb.setTitleColor(Color.blue);
        tb.setTitleFont(Projectdata.fnornmal);
        JPanel p0 = new JPanel(new FlowLayout(2));
        ImageIcon ic = new ImageIcon("images" + System.getProperty("file.separator") + "export_result.gif");
        JLabel lbheader = new JLabel("Export options");
        p0.add(lbheader);
        p0.add(new JLabel(ic));
        p0.setBackground(Color.white);
        p0.setBorder(new TitledBorder(""));
        JCheckBox cb1 = new JCheckBox("Summary table");
        cb1.setSelected(true);
        cb1.setEnabled(false);
        cb1.setFont(Projectdata.fnornmal);
        final JCheckBox cbsq = new JCheckBox("Sequences");
        cbsq.setFont(Projectdata.fnornmal);
        JLabel primsg = new JLabel("Target-scanning result");
        primsg.setFont(Projectdata.fnornmal);
        JCheckBox cb2 = new JCheckBox("Summary");
        cb2.setFont(Projectdata.fnornmal);
        JLabel premsg = new JLabel("MiRNA-target folding result");
        premsg.setFont(Projectdata.fnornmal);
        JCheckBox cb3 = new JCheckBox("Summary");
        cb3.setFont(Projectdata.fnornmal);
        final JCheckBox cbps = new JCheckBox("ps files");
        cbps.setFont(Projectdata.fnornmal);
        final JCheckBox cbct = new JCheckBox("ct files");
        cbct.setFont(Projectdata.fnornmal);
        JPanel p1 = new JPanel(new GridLayout(8, 1));
        p1.setBorder(tb);
        p1.add(cb1);
        p1.add(cbsq);
        p1.add(premsg);
        JPanel panelcbprict = new JPanel(new FlowLayout(0));
        panelcbprict.add(new JLabel("   "));
        panelcbprict.add(cbps);
        p1.add(panelcbprict);
        JPanel panelcbprect = new JPanel(new FlowLayout(0));
        panelcbprect.add(new JLabel("   "));
        panelcbprect.add(cbct);
        p1.add(panelcbprect);
        JPanel p2 = new JPanel();
        JButton btok = new JButton("Export");
        btok.setFont(Projectdata.fnornmal);
        JButton btcc = new JButton("Cancel");
        btcc.setFont(Projectdata.fnornmal);
        p2.add(btok);
        p2.add(btcc);
        btcc.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                Projectdata.anotationexpsta = false;
                AnotationExportOption.this.dispose();
            }
        });
        btok.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Projectdata.anotationsqexp = false;
                Projectdata.anotationtargetfoldpsexp = false;
                Projectdata.anotationtargetfoldctexp = false;
                Projectdata.anotationsqexp = cbsq.isSelected();
                Projectdata.anotationtargetfoldpsexp = cbps.isSelected();
                Projectdata.anotationtargetfoldctexp = cbct.isSelected();
                Projectdata.anotationexpsta = true;
                AnotationExportOption.this.dispose();
            }
        });
        this.add((Component)p0, "North");
        this.add((Component)p1, "Center");
        this.add((Component)p2, "South");
        this.setDefaultCloseOperation(2);
        this.setSize(400, 350);
        this.setLocationByPlatform(true);
        this.setVisible(true);
    }

    public static String getanotationtrack() {
        String ftfilename = String.valueOf(Projectdata.getPathSep("anotation")) + Projectdata.anotationname + "-targetfoldingtrack";
        String targetfoldingtrack = ReadFile.readfile(ftfilename, "read track targetfolding", "AnotationExportOption.java");
        targetfoldingtrack = targetfoldingtrack.trim();
        return targetfoldingtrack;
    }

    public static TreeMap<String, AnotationExportdata> makeanotationexportdic() {
        String targetfoldingtrack = AnotationExportOption.getanotationtrack();
        ArrayList<Foldingoutput> data = TargetFoldingdes.loadFolddata(targetfoldingtrack);
        TreeMap<String, AnotationExportdata> tm = new TreeMap<String, AnotationExportdata>();
        for (Foldingoutput foutput : data) {
            String key = String.valueOf(foutput.getName().trim()) + "-" + foutput.getBlastn().trim() + "-" + foutput.getInputstrand().trim();
            AnotationExportdata ae = new AnotationExportdata();
            ae.setMfe(foutput.getMfi().replaceAll("kcal/mol", ""));
            ae.setScan_bindingsite(foutput.getBpscan());
            ae.setUnafold_bindingsite(foutput.getBpuna());
            ae.setTargetmirandetail(foutput.getMirnadetailname());
            tm.put(key, ae);
        }
        String scanoutputfilename = String.valueOf(Projectdata.getPathSep("targetfolding")) + targetfoldingtrack + "-file" + System.getProperty("file.separator") + "scandetail";
        ArrayList<Homologoutputdata> scandatas = Projectdata.plscanningdes.loaddata(scanoutputfilename);
        for (Homologoutputdata sdata : scandatas) {
            String key = String.valueOf(sdata.getTarget_name().trim()) + "-" + sdata.getMiRNA().trim() + "-" + sdata.getStrand().trim();
            if (!tm.containsKey(key)) continue;
            AnotationExportdata ae = tm.get(key);
            ae.setMp(sdata.getMismatch_position());
            ae.setNm(sdata.getNumber_of_mismatch());
            ae.setNgp(sdata.getNumber_of_gu_pair());
            ae.setScore(sdata.getScore());
            tm.put(key, ae);
        }
        return tm;
    }

    public static void main(String[] args) {
        new AnotationExportOption(null, true);
    }
}

