/*
 * Decompiled with CFR 0.152.
 */
package frame;

import data.LoadProjectdata;
import data.Projectdata;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.regex.Pattern;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;

public class CreateNewProject
extends JDialog {
    Font font = Projectdata.fnornmal;
    private static final long serialVersionUID = 1L;

    public CreateNewProject(Frame owner, boolean modal) {
        super(owner, modal);
        this.setTitle("New project");
        JPanel p0 = new JPanel(new FlowLayout(2));
        ImageIcon ic = new ImageIcon("images" + System.getProperty("file.separator") + "new_project.gif");
        JLabel lbheader = new JLabel("Create new project");
        p0.add(lbheader);
        p0.add(new JLabel(ic));
        p0.setBackground(Color.white);
        p0.setBorder(new TitledBorder(""));
        JPanel p1 = new JPanel(new FlowLayout(0));
        TitledBorder tb = new TitledBorder("Enter project path");
        tb.setTitleColor(Color.blue);
        tb.setTitleFont(Projectdata.fnornmal);
        p1.setBorder(tb);
        JLabel nameLabel = new JLabel("Project folder: ");
        nameLabel.setFont(Projectdata.fnornmal);
        final JTextField nameTextField = new JTextField(20);
        nameTextField.setText(Projectdata.getStartPath("NEW"));
        nameTextField.setEditable(false);
        nameLabel.setLabelFor(nameTextField);
        JButton btbrowse = new JButton("Browse");
        btbrowse.setFont(Projectdata.fnornmal);
        JPanel plprojectfolder = new JPanel();
        plprojectfolder.add(nameLabel);
        plprojectfolder.add(nameTextField);
        plprojectfolder.add(btbrowse);
        p1.add(plprojectfolder);
        JPanel plprojectname = new JPanel();
        JLabel projectnameLabel = new JLabel("Project name: ");
        projectnameLabel.setFont(Projectdata.fnornmal);
        final JTextField projectnameTextField = new JTextField(20);
        projectnameLabel.setLabelFor(projectnameTextField);
        plprojectname.add(projectnameLabel);
        plprojectname.add(projectnameTextField);
        p1.add(plprojectname);
        btbrowse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                JFileChooser jf = new JFileChooser();
                jf.setFileSelectionMode(1);
                CreateNewProject.this.setFileChooserFont(jf.getComponents());
                jf.setCurrentDirectory(new File(Projectdata.getStartPath("NEW")));
                int r = jf.showDialog(null, "Select folder");
                if (r == 0) {
                    String n = jf.getSelectedFile().getAbsolutePath();
                    nameTextField.setText(n);
                }
            }
        });
        final JLabel msg1 = new JLabel();
        msg1.setText("* Please input project folder or project name ");
        msg1.setForeground(Color.red);
        msg1.setVisible(false);
        final JLabel msg2 = new JLabel();
        msg2.setText("* Specified project folder has existed. Please specify a new one.    ");
        msg2.setForeground(Color.red);
        msg2.setVisible(false);
        final JLabel msg3 = new JLabel();
        msg3.setText("* Error while creating the new project                         ");
        msg3.setForeground(Color.red);
        msg3.setVisible(false);
        final JLabel msg4 = new JLabel();
        msg4.setText("* Specified project name has existed. Please specify a new one.    ");
        msg4.setForeground(Color.red);
        msg4.setVisible(false);
        final JLabel msg5 = new JLabel();
        msg5.setForeground(Color.red);
        msg5.setVisible(false);
        p1.add(msg1);
        p1.add(msg2);
        p1.add(msg3);
        p1.add(msg4);
        p1.add(msg5);
        JPanel p2 = new JPanel(new FlowLayout(1));
        JButton btcreate = new JButton("Create");
        btcreate.setFont(Projectdata.fnornmal);
        btcreate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                msg1.setVisible(false);
                msg2.setVisible(false);
                msg3.setVisible(false);
                msg4.setVisible(false);
                msg5.setVisible(false);
                boolean chkerr = false;
                String path = projectnameTextField.getText().trim();
                String name = nameTextField.getText();
                if (Pattern.matches(".* .*", path)) {
                    chkerr = true;
                    msg5.setText("* Please specify project name without space                     ");
                }
                if (Pattern.matches(".* .*", name)) {
                    chkerr = true;
                    msg5.setText("* Please select path name without space                     ");
                }
                if (chkerr) {
                    msg1.setVisible(false);
                    msg2.setVisible(false);
                    msg3.setVisible(false);
                    msg4.setVisible(false);
                    msg5.setVisible(true);
                } else if (projectnameTextField.getText().trim().equals("") || nameTextField.getText().equals("")) {
                    if (projectnameTextField.getText().trim().equals("")) {
                        msg1.setText("* Please input project project name");
                    } else {
                        msg1.setText("* Please input project folder name");
                    }
                    msg1.setVisible(true);
                } else {
                    LoadProjectdata da = new LoadProjectdata();
                    da.setProjectname(projectnameTextField.getText().trim().trim());
                    da.setProjectpath(nameTextField.getText());
                    Projectdata.projectname = projectnameTextField.getText().trim();
                    Projectdata.projectpath = nameTextField.getText();
                    Projectdata.writepath("NEW", nameTextField.getText());
                    String folderpath = String.valueOf(nameTextField.getText()) + System.getProperty("file.separator") + projectnameTextField.getText().trim();
                    File file = new File(folderpath);
                    if (file.exists()) {
                        msg1.setVisible(false);
                        msg2.setVisible(true);
                        msg3.setVisible(false);
                        msg4.setVisible(false);
                    } else if (Projectdata.ht.get(projectnameTextField.getText().trim()) != null) {
                        msg1.setVisible(false);
                        msg2.setVisible(false);
                        msg3.setVisible(false);
                        msg4.setVisible(true);
                    } else {
                        boolean success = new File(folderpath).mkdir();
                        if (success) {
                            Projectdata.iscreatecomplete = true;
                            da.setSequencepath(String.valueOf(folderpath) + System.getProperty("file.separator") + "Input_sequence");
                            Projectdata.sequencepath = String.valueOf(folderpath) + System.getProperty("file.separator") + "Input_sequence";
                            new File(String.valueOf(folderpath) + System.getProperty("file.separator") + "Input_sequence").mkdir();
                            new File(String.valueOf(folderpath) + System.getProperty("file.separator") + "Input_targetsequence").mkdir();
                            new File(String.valueOf(folderpath) + System.getProperty("file.separator") + "Input_targetsequence" + System.getProperty("file.separator") + "user_miRNA").mkdir();
                            new File(String.valueOf(folderpath) + System.getProperty("file.separator") + "miRNA_sequence").mkdir();
                            new File(String.valueOf(folderpath) + System.getProperty("file.separator") + "miRNA_sequence" + System.getProperty("file.separator") + "Homolog-search").mkdir();
                            new File(String.valueOf(folderpath) + System.getProperty("file.separator") + "miRNA_sequence" + System.getProperty("file.separator") + "Primary_folding").mkdir();
                            new File(String.valueOf(folderpath) + System.getProperty("file.separator") + "miRNA_sequence" + System.getProperty("file.separator") + "Primary_folding" + System.getProperty("file.separator") + "sequnece").mkdir();
                            new File(String.valueOf(folderpath) + System.getProperty("file.separator") + "miRNA_sequence" + System.getProperty("file.separator") + "Primary_folding" + System.getProperty("file.separator") + "outputs").mkdir();
                            new File(String.valueOf(folderpath) + System.getProperty("file.separator") + "miRNA_sequence" + System.getProperty("file.separator") + "Primary_folding" + System.getProperty("file.separator") + "preoutput").mkdir();
                            new File(String.valueOf(folderpath) + System.getProperty("file.separator") + "miRNA_sequence" + System.getProperty("file.separator") + "Primary_folding" + System.getProperty("file.separator") + "criteria").mkdir();
                            new File(String.valueOf(folderpath) + System.getProperty("file.separator") + "Target_sequence").mkdir();
                            new File(String.valueOf(folderpath) + System.getProperty("file.separator") + "Target_sequence" + System.getProperty("file.separator") + "Target_scan").mkdir();
                            new File(String.valueOf(folderpath) + System.getProperty("file.separator") + "Target_sequence" + System.getProperty("file.separator") + "Target_folding").mkdir();
                            new File(String.valueOf(folderpath) + System.getProperty("file.separator") + "Target_sequence" + System.getProperty("file.separator") + "Target_annotation").mkdir();
                            new File(String.valueOf(folderpath) + System.getProperty("file.separator") + "tmp").mkdir();
                            new File(String.valueOf(folderpath) + System.getProperty("file.separator") + "log").mkdir();
                            Projectdata.ht.put(projectnameTextField.getText().trim(), da);
                            CreateNewProject.this.dispose();
                        } else {
                            msg1.setVisible(false);
                            msg2.setVisible(false);
                            msg3.setVisible(true);
                            msg4.setVisible(false);
                        }
                    }
                }
            }
        });
        p2.add(btcreate);
        JButton btcancel = new JButton("Cancel");
        btcancel.setFont(Projectdata.fnornmal);
        btcancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CreateNewProject.this.setVisible(false);
            }
        });
        p2.add(btcancel);
        this.add((Component)p0, "North");
        this.add((Component)p1, "Center");
        this.add((Component)p2, "South");
        this.setLocationByPlatform(true);
        this.setSize(500, 300);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent e) {
                projectnameTextField.requestFocus();
            }
        });
        this.setVisible(true);
    }

    public void setFileChooserFont(Component[] comp) {
        int x = 0;
        while (x < comp.length) {
            if (comp[x] instanceof Container) {
                this.setFileChooserFont(((Container)comp[x]).getComponents());
            }
            try {
                comp[x].setFont(this.font);
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++x;
        }
    }

    public static void main(String[] args) {
        JFrame f = new JFrame();
        CreateNewProject c = new CreateNewProject((Frame)f, true);
        f.add(c);
        f.setDefaultCloseOperation(3);
        f.pack();
        f.setVisible(true);
    }
}

