/*
 * Decompiled with CFR 0.152.
 */
package frame;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.HeadlessException;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.swing.JApplet;
import org.jgraph.JGraph;
import org.jgraph.graph.AttributeMap;
import org.jgraph.graph.DefaultGraphCell;
import org.jgraph.graph.GraphConstants;
import org.jgraph.graph.GraphModel;
import org.jgrapht.DirectedGraph;
import org.jgrapht.ext.JGraphModelAdapter;
import org.jgrapht.graph.DefaultEdge;
import org.jgrapht.graph.DefaultListenableGraph;
import org.jgrapht.graph.DirectedMultigraph;

public class Custom
extends JApplet {
    ArrayList<String> nodedependent;
    TreeSet<String> nodelist;
    TreeMap<String, Integer> nodelevel;
    TreeMap<String, Integer> nodelvlwidth;
    int maxwidth;
    private static final long serialVersionUID = 3256444702936019250L;
    private static final Color DEFAULT_BG_COLOR = Color.decode("#FAFBFF");
    private static final Dimension DEFAULT_SIZE = new Dimension(530, 320);
    private JGraphModelAdapter jgAdapter;

    public Custom(ArrayList<String> nodedependent, TreeSet<String> nodelist, TreeMap<String, Integer> nodelevel, TreeMap<String, Integer> nodelvlwidth, int maxwidth) throws HeadlessException {
        this.nodedependent = nodedependent;
        this.nodelist = nodelist;
        this.nodelevel = nodelevel;
        this.nodelvlwidth = nodelvlwidth;
        this.maxwidth = maxwidth;
    }

    public static void main(String[] args) {
    }

    public int calDistanctHight(int level, int hight) {
        int output = 0;
        int i = 1;
        while (i < level) {
            output += hight;
            ++i;
        }
        if (output == 0) {
            output = 10;
        }
        return output;
    }

    public int calDistanctWidth(int level, int width) {
        int output = 0;
        int i = 1;
        while (i < level) {
            output += width;
            ++i;
        }
        if (output == 0) {
            output = 10;
        }
        return output;
    }

    public void numOfNodeInLvl(int level, TreeMap<String, Integer> nodelevel) {
    }

    @Override
    public void init() {
        ListenableDirectedMultigraph<String, DefaultEdge> g = new ListenableDirectedMultigraph<String, DefaultEdge>(DefaultEdge.class);
        this.jgAdapter = new JGraphModelAdapter(g);
        JGraph jgraph = new JGraph((GraphModel)this.jgAdapter);
        this.adjustDisplaySettings(jgraph);
        this.getContentPane().add((Component)jgraph);
        this.resize(DEFAULT_SIZE);
        int width = 800;
        int height = 600;
        int levelheight = height / 3;
        int levelwidth = width / this.maxwidth;
        for (String nl : this.nodelist) {
            g.addVertex(nl.trim());
        }
        for (String nd : this.nodedependent) {
            String[] nds = nd.split(",");
            String node1 = nds[0].trim();
            String node2 = nds[1].trim();
            g.addEdge(node1, node2);
        }
        for (String nl : this.nodelist) {
            int nodelvl = this.nodelevel.get(nl);
            int nodeposheight = this.calDistanctHight(nodelvl, levelheight);
            nodelvl = this.nodelvlwidth.get(nl);
            int nodeposwidth = this.calDistanctWidth(nodelvl, levelwidth);
            this.positionVertexAt(nl.trim(), nodeposwidth, nodeposheight);
        }
    }

    private void adjustDisplaySettings(JGraph jg) {
        jg.setPreferredSize(DEFAULT_SIZE);
        Color c = DEFAULT_BG_COLOR;
        String colorStr = null;
        try {
            colorStr = this.getParameter("bgcolor");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (colorStr != null) {
            c = Color.decode(colorStr);
        }
        jg.setBackground(c);
    }

    private void positionVertexAt(Object vertex, int x, int y) {
        DefaultGraphCell cell = this.jgAdapter.getVertexCell(vertex);
        AttributeMap attr = cell.getAttributes();
        Rectangle2D bounds = GraphConstants.getBounds((Map)attr);
        Rectangle2D.Double newBounds = new Rectangle2D.Double(x, y, bounds.getWidth(), bounds.getHeight());
        GraphConstants.setBounds((Map)attr, (Rectangle2D)newBounds);
        AttributeMap cellAttr = new AttributeMap();
        cellAttr.put((Object)cell, (Object)attr);
        this.jgAdapter.edit((Map)cellAttr, null, null, null);
    }

    private static class ListenableDirectedMultigraph<V, E>
    extends DefaultListenableGraph<V, E>
    implements DirectedGraph<V, E> {
        private static final long serialVersionUID = 1L;

        ListenableDirectedMultigraph(Class<E> edgeClass) {
            super(new DirectedMultigraph(edgeClass));
        }
    }
}

