/*
 * Decompiled with CFR 0.152.
 */
package frame;

import bean.Helpclass;
import bean.MiRNADB;
import cellRender.TooltipPictureRenderAddon;
import data.Homologdata;
import data.Projectdata;
import data.ScanSummarydata;
import data.Systeminfo;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.TreeMap;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.TitledBorder;

public class Homolog
extends JDialog {
    private static final long serialVersionUID = 1L;
    JLabel err;

    public Homolog(Frame owner, boolean modal) {
        super(owner, modal);
        try {
            UIManager.LookAndFeelInfo[] lookAndFeelInfoArray = UIManager.getInstalledLookAndFeels();
            int n = lookAndFeelInfoArray.length;
            int n2 = 0;
            while (n2 < n) {
                UIManager.LookAndFeelInfo info = lookAndFeelInfoArray[n2];
                if ("Nimbus".equals(info.getName())) {
                    UIManager.setLookAndFeel(info.getClassName());
                    break;
                }
                ++n2;
            }
        }
        catch (Exception info) {
            // empty catch block
        }
        this.setTitle("Homolog search");
        JPanel p0 = new JPanel(new FlowLayout(2));
        ImageIcon ic = new ImageIcon("images" + System.getProperty("file.separator") + "homolog_search.gif");
        JLabel lbheader = new JLabel("Homolog search");
        p0.add(lbheader);
        p0.add(new JLabel(ic));
        p0.setBackground(Color.white);
        p0.setBorder(new TitledBorder(""));
        JPanel p1 = new JPanel();
        TitledBorder tb = new TitledBorder("Homolog search parameters");
        tb.setTitleColor(Color.blue);
        tb.setTitleFont(Projectdata.fnornmal);
        p1.setBorder(tb);
        this.setLayout(new BorderLayout());
        final JPanel p11 = new JPanel();
        p11.setLayout(new GridLayout(1, 2));
        JLabel evalue = new JLabel("E value");
        evalue.setFont(Projectdata.fnornmal);
        p11.add(evalue);
        final JTextField jt = new JTextField(5);
        jt.setText("10");
        p11.add(jt);
        JPanel p12 = new JPanel();
        p12.setLayout(new GridLayout(1, 2));
        p12.add(new JLabel("Search method"));
        String[] s = new String[]{"BLAST + SCAN", "SCAN"};
        final JComboBox<String> cb = new JComboBox<String>(s);
        p12.add(cb);
        ArrayList<MiRNADB> almdb = Projectdata.getSelectMirnaPlant("miRBase", true);
        final TreeMap<String, String> mirnamapvalue = new TreeMap<String, String>();
        ArrayList<String> namelist = new ArrayList<String>();
        for (MiRNADB miRNADB : almdb) {
            String key = String.valueOf(miRNADB.getName()) + " (" + miRNADB.getNumber() + ")";
            namelist.add(key);
            mirnamapvalue.put(key, miRNADB.getValue());
        }
        Collections.sort(namelist);
        JPanel pSelectPlant = new JPanel(new BorderLayout());
        String[] selections = namelist.toArray(new String[0]);
        final JList<String> list = new JList<String>(selections);
        pSelectPlant.add((Component)new JLabel("Source mature miRNAs from miRBase"), "North");
        pSelectPlant.add((Component)new JScrollPane(list), "Center");
        cb.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                JComboBox jcb = (JComboBox)arg0.getSource();
                String svalue = jcb.getSelectedItem().toString().trim();
                if (svalue.equals("SCAN")) {
                    p11.setVisible(false);
                } else {
                    p11.setVisible(true);
                }
            }
        });
        JPanel p13 = new JPanel();
        p13.setLayout(new GridLayout(1, 2));
        JLabel mismatch = new JLabel("Allowed number of mismatches ");
        mismatch.setIcon(Projectdata.getICNotic());
        mismatch.setToolTipText(TooltipPictureRenderAddon.makettmultiline("The maximum number of allowed mismatches between a known mature miRNA sequence \nand its homolog on an input nucleotide sequence"));
        mismatch.setFont(Projectdata.fnornmal);
        p13.add(mismatch);
        String[] s1 = new String[]{"0", "<=1", "<=2", "<=3", "<=4"};
        final JComboBox<String> cb1 = new JComboBox<String>(s1);
        cb1.setFont(Projectdata.fnornmal);
        p13.add(cb1);
        int tcount = Integer.parseInt(new Systeminfo().getCpunum());
        Object[] ts = new Object[]{"1", "2", "3", "4", "5", "6", "7", "8", "9"};
        if (tcount < 9) {
            ArrayList<String> al = new ArrayList<String>();
            int i = 1;
            while (i <= tcount) {
                al.add(Integer.toString(i));
                ++i;
            }
            ts = al.toArray();
        }
        cb1.setSelectedItem("<=4");
        JPanel p14 = new JPanel();
        p14.setLayout(new GridLayout(1, 2));
        final JComboBox<Object> tcb = new JComboBox<Object>(ts);
        tcb.setFont(Projectdata.fnornmal);
        JLabel thread = new JLabel("Number of processors ");
        thread.setFont(Projectdata.fnornmal);
        p14.add(thread);
        p14.add(tcb);
        Box pinpjut = Box.createVerticalBox();
        pinpjut.add(p12);
        pinpjut.add(Box.createVerticalStrut(10));
        pinpjut.add(pSelectPlant);
        pinpjut.add(Box.createVerticalStrut(10));
        pinpjut.add(p11);
        pinpjut.add(Box.createVerticalStrut(10));
        pinpjut.add(p13);
        pinpjut.add(Box.createVerticalStrut(10));
        pinpjut.add(p14);
        pinpjut.add(Box.createVerticalStrut(10));
        JLabel msg = new JLabel();
        msg.setForeground(Color.red);
        msg.setVisible(false);
        final JButton bt = new JButton("Search");
        bt.setFont(Projectdata.fnornmal);
        bt.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                String filename = String.valueOf(Projectdata.getPathSep("sequence")) + Projectdata.sequencename + ".status";
                ScanSummarydata ssdata = new ScanSummarydata();
                ssdata.load(filename);
                int sqsize = ssdata.getNumberofseq();
                String searchmethod = cb.getSelectedItem().toString();
                if (searchmethod.equals("SCAN") && sqsize > 1000) {
                    JOptionPane.showMessageDialog(null, "The scan method limits number of input sequences to be less than or equal to 1000 for performance purpose.", "Warning", 2);
                } else {
                    boolean checkpass = false;
                    int count = 0;
                    int i = 0;
                    while (i < list.getModel().getSize()) {
                        boolean ischeck = list.isSelectedIndex(i);
                        if (ischeck) {
                            ++count;
                        }
                        ++i;
                    }
                    if (count != 0) {
                        checkpass = true;
                    }
                    if (checkpass) {
                        boolean check = true;
                        String input = jt.getText();
                        String evalue = "";
                        if (Helpclass.isIntNumber(input) || Homolog.checkevalue(input).booleanValue()) {
                            evalue = Homolog.checkevalue(input).booleanValue() ? Homolog.convertevalue(input) : input;
                        } else {
                            check = false;
                            JOptionPane.showMessageDialog(null, "Please check E-value (<100)", "Warning", 2);
                        }
                        String strmismatch = cb1.getSelectedItem().toString();
                        strmismatch = strmismatch.replaceAll("<=", "").trim();
                        int mismatch = Integer.parseInt(strmismatch);
                        int wordsize = 4;
                        String nothread = tcb.getSelectedItem().toString();
                        if (check) {
                            Object[] seleceted;
                            Homologdata hm = new Homologdata();
                            hm.setEvalue(evalue);
                            hm.setMismatch(mismatch);
                            hm.setWordsize(wordsize);
                            hm.setNothread(nothread);
                            hm.setSearchmethod(searchmethod);
                            StringBuffer sb = new StringBuffer();
                            Object[] objectArray = seleceted = list.getSelectedValues();
                            int n = seleceted.length;
                            int n2 = 0;
                            while (n2 < n) {
                                Object value = objectArray[n2];
                                String mirnavalue = (String)mirnamapvalue.get(value.toString().trim());
                                sb.append(String.valueOf(mirnavalue) + "#");
                                ++n2;
                            }
                            hm.setMirnaselectedlist(sb.toString());
                            Projectdata.isloadhomologdata = true;
                            Projectdata.homologdata = hm;
                            Homolog.this.setVisible(false);
                        }
                    } else {
                        JOptionPane.showMessageDialog(null, "Please select at least a plant to proceed", "Warning", 2);
                    }
                }
            }
        });
        JPanel pbutton = new JPanel();
        JButton btclose = new JButton("Cancel");
        btclose.setFont(Projectdata.fnornmal);
        pbutton.add(bt);
        pbutton.add(btclose);
        this.err = new JLabel("Check E-value (<100)");
        this.err.setFont(Projectdata.fnornmal);
        this.err.setForeground(Color.red);
        this.err.setVisible(false);
        pbutton.add(this.err);
        pinpjut.add(pbutton);
        btclose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                Homolog.this.dispose();
            }
        });
        p1.setLayout(new BorderLayout());
        JPanel ptmp = new JPanel();
        ptmp.add(pinpjut);
        p1.add((Component)ptmp, "Center");
        this.add((Component)p0, "North");
        this.add((Component)p1, "Center");
        this.add((Component)msg, "South");
        this.pack();
        this.setLocationByPlatform(true);
        Helpclass.enterPressesWhenFocused(bt);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent e) {
                bt.requestFocus();
            }
        });
        this.setVisible(true);
    }

    public static void main(String[] args) {
        final JFrame f = new JFrame();
        f.setLayout(new FlowLayout());
        JButton bt = new JButton("test");
        bt.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                new Homolog((Frame)f, true);
            }
        });
        f.add(bt);
        f.setSize(200, 100);
        f.getContentPane().setBackground(Color.white);
        f.setVisible(true);
        f.setDefaultCloseOperation(3);
    }

    public static Boolean checkevalue(String value) {
        Boolean check = true;
        String[] sectionevalue = value.split("-");
        if (sectionevalue.length != 2) {
            check = false;
        } else {
            String firstsection = sectionevalue[0];
            String secondvalue = sectionevalue[1];
            try {
                String echeck = String.valueOf(firstsection.charAt(firstsection.length() - 1));
                if (echeck.equals("e") || firstsection.equals("E")) {
                    try {
                        String numbe = firstsection.substring(0, firstsection.length() - 1);
                        Integer.parseInt(numbe);
                    }
                    catch (Exception e) {
                        check = false;
                    }
                } else {
                    check = false;
                }
            }
            catch (Exception e1) {
                check = false;
            }
            try {
                Integer.parseInt(secondvalue);
            }
            catch (Exception e) {
                check = false;
            }
        }
        return check;
    }

    public static String convertevalue(String value) {
        return value;
    }
}

