/*
 * Decompiled with CFR 0.152.
 */
package frame;

import bean.CheckDbInstall;
import bean.Helpclass;
import cellRender.TooltipPictureRenderAddon;
import data.Foldingdata;
import data.PreFolddata;
import data.Projectdata;
import data.Systeminfo;
import frame.Homolog;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.TreeMap;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;

public class PreFolding
extends JDialog {
    private static final long serialVersionUID = 1L;

    public PreFolding(Frame owner, boolean modal) {
        super(owner, modal);
        this.setTitle("Precursor miRNA folding");
        this.setLayout(new BorderLayout());
        JPanel p0 = new JPanel(new FlowLayout(2));
        ImageIcon ic = new ImageIcon("images" + System.getProperty("file.separator") + "folding_pre.gif");
        JLabel lbheader = new JLabel("Precursor miRNA folding");
        p0.add(lbheader);
        p0.add(new JLabel(ic));
        p0.setBackground(Color.white);
        p0.setBorder(new TitledBorder(""));
        this.add((Component)p0, "North");
        Box pall = Box.createVerticalBox();
        JPanel pcontroll = new JPanel();
        pall.setBorder(new TitledBorder(""));
        int count = 0;
        count = Integer.parseInt(new Systeminfo().getCpunum());
        Object[] s = new Object[]{"1", "2", "3", "4", "5", "6", "7", "8", "9"};
        if (count < 9) {
            ArrayList<String> al = new ArrayList<String>();
            int i = 1;
            while (i <= count) {
                al.add(Integer.toString(i));
                ++i;
            }
            s = al.toArray();
        }
        final JComboBox<Object> cb = new JComboBox<Object>(s);
        cb.setFont(Projectdata.fnornmal);
        pcontroll.add(Box.createHorizontalStrut(40));
        JLabel thread = new JLabel("Number of threads to run ");
        thread.setFont(Projectdata.fnornmal);
        pcontroll.add(thread);
        pcontroll.setLayout(new FlowLayout(0));
        pcontroll.add(cb);
        final JButton bt = new JButton("Fold");
        bt.setFont(Projectdata.fnornmal);
        pcontroll.add(bt);
        JButton btc = new JButton("Cancel");
        btc.setFont(Projectdata.fnornmal);
        btc.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                PreFolding.this.dispose();
            }
        });
        pcontroll.add(btc);
        JLabel msgerr = new JLabel("Please input parameter");
        msgerr.setFont(Projectdata.fnornmal);
        msgerr.setForeground(Color.red);
        msgerr.setVisible(false);
        pcontroll.add(msgerr);
        JPanel pcb1 = new JPanel();
        pcb1.setLayout(new FlowLayout(0));
        final JCheckBox cb1 = new JCheckBox();
        JLabel labelcb1 = new JLabel("BLASTX\t");
        labelcb1.setIcon(Projectdata.getICNotic());
        labelcb1.setToolTipText(TooltipPictureRenderAddon.makettmultiline("Input sequences with homolog mature miRNA will be searched against the specified protein database \n(e.g. UniProt/SwissProt) using BLASTX with the specified E-value (default <= e-20) to remove possible protein coding sequences."));
        labelcb1.setFont(Projectdata.fnornmal);
        pcb1.add(Box.createHorizontalStrut(40));
        pcb1.add(cb1);
        pcb1.add(labelcb1);
        JPanel p11 = new JPanel();
        p11.setLayout(new GridLayout(1, 2));
        JLabel evalue = new JLabel("E-value");
        evalue.setFont(Projectdata.fnornmal);
        p11.add(evalue);
        final JTextField jt = new JTextField(5);
        jt.setText("1e-20");
        p11.add(jt);
        pcb1.add(p11);
        JPanel pcb11 = new JPanel();
        pcb11.setLayout(new FlowLayout(0));
        JLabel labelcb11 = new JLabel("\tagainst database\t");
        labelcb11.setFont(Projectdata.fnornmal);
        pcb1.add(labelcb11);
        Object[] s1 = new Object[]{"UniProt/Swiss-Prot", "UniProt/Swiss-Prot (Plants only)", "UniProt/TrEMBL (Plants only)"};
        CheckDbInstall cdbins = new CheckDbInstall();
        if (cdbins.getUniprot_sprot().booleanValue() || cdbins.getUniprot_sprot_plant().booleanValue() || cdbins.getUniprot_sprot_trembl().booleanValue()) {
            s1 = cdbins.getListBLASTX();
        } else {
            cb1.setEnabled(false);
        }
        final JComboBox<Object> cb11 = new JComboBox<Object>(s1);
        cb11.setFont(Projectdata.fnornmal);
        pcb1.add(cb11);
        cb11.setEnabled(false);
        cb1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AbstractButton abstractButton = (AbstractButton)actionEvent.getSource();
                boolean selected = abstractButton.getModel().isSelected();
                if (selected) {
                    cb11.setEnabled(true);
                } else {
                    cb11.setEnabled(false);
                }
            }
        });
        JPanel pcb2 = new JPanel();
        pcb2.setLayout(new FlowLayout(0));
        final JCheckBox cb2 = new JCheckBox();
        JLabel labelcb2 = new JLabel("BLASTN\t");
        labelcb2.setIcon(Projectdata.getICNotic());
        labelcb2.setToolTipText(TooltipPictureRenderAddon.makettmultiline("Input sequences with homolog mature miRNA will be searched against the specified non-coding RNA database \n(e.g. Rfam) using BLASTN with the specified E-value (default <= e-8) to remove non-coding RNAs that are not miRNAs"));
        labelcb2.setFont(Projectdata.fnornmal);
        pcb2.add(Box.createHorizontalStrut(40));
        pcb2.add(cb2);
        pcb2.add(labelcb2);
        JPanel p12 = new JPanel();
        p12.setLayout(new GridLayout(1, 2));
        JLabel evalue1 = new JLabel("E-value");
        evalue1.setFont(Projectdata.fnornmal);
        p12.add(evalue1);
        final JTextField jt1 = new JTextField(5);
        jt1.setText("1e-8");
        p12.add(jt1);
        pcb2.add(p12);
        JPanel pcb21 = new JPanel();
        pcb21.setLayout(new FlowLayout(0));
        JLabel labelcb21 = new JLabel("\tagainst database\t");
        labelcb21.setFont(Projectdata.fnornmal);
        pcb2.add(labelcb21);
        Object[] s2 = new Object[]{"Rfam"};
        cdbins = new CheckDbInstall();
        if (cdbins.getRfam().booleanValue()) {
            s2 = cdbins.getListBLASTN();
        } else {
            cb2.setEnabled(false);
        }
        final JComboBox<Object> cb21 = new JComboBox<Object>(s2);
        cb21.setFont(Projectdata.fnornmal);
        pcb2.add(cb21);
        cb21.setEnabled(false);
        cb2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AbstractButton abstractButton = (AbstractButton)actionEvent.getSource();
                boolean selected = abstractButton.getModel().isSelected();
                if (selected) {
                    cb21.setEnabled(true);
                } else {
                    cb21.setEnabled(false);
                }
            }
        });
        Color clr = new JLabel().getBackground();
        Font lblft = new JLabel().getFont();
        JPanel v3 = new JPanel(new FlowLayout(0));
        v3.add(Box.createHorizontalStrut(20));
        final JTextField ncf = new JTextField(3);
        ncf.setText("37");
        JLabel v3msg1 = new JLabel("Temperature                                         ");
        v3msg1.setIcon(Projectdata.getICNotic());
        v3msg1.setToolTipText(TooltipPictureRenderAddon.makettmultiline("UNAFold parameter: folding temperature."));
        v3msg1.setFont(Projectdata.fnornmal);
        v3msg1.setBackground(clr);
        v3msg1.setBorder(null);
        v3.add(v3msg1);
        v3.add(ncf);
        JPanel v4 = new JPanel(new FlowLayout(0));
        v4.add(Box.createHorizontalStrut(20));
        final JTextField ncf2 = new JTextField(3);
        ncf2.setText("3000");
        JLabel v3msg2 = new JLabel("Maximum basepair distance             ");
        v3msg2.setIcon(Projectdata.getICNotic());
        v3msg2.setToolTipText(TooltipPictureRenderAddon.makettmultiline("UNAFold parameter: if specified, the pairing between bases will be allowed only within \na certain distance of one another (>=0, default is no limit)."));
        v3msg2.setFont(Projectdata.fnornmal);
        v3msg2.setBackground(clr);
        v3msg2.setBorder(null);
        v4.add(v3msg2);
        v4.add(ncf2);
        JPanel v5 = new JPanel(new FlowLayout(0));
        v5.add(Box.createHorizontalStrut(20));
        final JTextField ncf3 = new JTextField(3);
        ncf3.setText("30");
        JLabel v3msg3 = new JLabel("Maximum bulge/interior loop size     ");
        v3msg3.setToolTipText(TooltipPictureRenderAddon.makettmultiline("UNAFold parameter: the maximum interior or bulge loop size \nallowed within the structure (>= 0, default is 30)."));
        v3msg3.setIcon(Projectdata.getICNotic());
        v3msg3.setFont(Projectdata.fnornmal);
        v3msg3.setBackground(clr);
        v3msg3.setBorder(null);
        v5.add(v3msg3);
        v5.add(ncf3);
        Box v3v = Box.createVerticalBox();
        TitledBorder tbv3v = new TitledBorder("UNAFold parameters");
        tbv3v.setTitleColor(Color.blue);
        tbv3v.setTitleFont(Projectdata.fnornmal);
        v3v.setBorder(tbv3v);
        v3v.add(v3);
        v3v.add(v4);
        v3v.add(v5);
        if (count != 0) {
            Box v1 = Box.createHorizontalBox();
            v1.add(pcb1);
            v1.add(pcb11);
            Box v2 = Box.createHorizontalBox();
            v2.add(pcb2);
            v2.add(pcb21);
            Box v12 = Box.createVerticalBox();
            TitledBorder tbv12 = new TitledBorder("BLAST parameters");
            tbv12.setTitleColor(Color.blue);
            tbv12.setTitleFont(Projectdata.fnornmal);
            v12.setBorder(tbv12);
            v12.add(v1);
            v12.add(v2);
            pall.add(v12);
            pall.add(v3v);
            pall.add(pcontroll);
            this.add((Component)pall, "Center");
        } else {
            JPanel pmsg = new JPanel();
            pmsg.setBorder(new TitledBorder("Folding parameter"));
            pmsg.setLayout(new FlowLayout());
            pmsg.add(new JLabel("Please select sequence"));
            JButton btclose = new JButton("Cancel");
            btclose.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PreFolding.this.dispose();
                }
            });
            pmsg.add(btclose);
            this.add((Component)pmsg, "Center");
        }
        bt.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String max = ncf.getText();
                String maxbp = ncf2.getText();
                String maxloop = ncf3.getText();
                boolean check = true;
                String input = jt.getText();
                String evalue = "";
                if (cb1.isSelected()) {
                    if (Helpclass.isIntNumber(input) || Homolog.checkevalue(input).booleanValue()) {
                        evalue = Homolog.checkevalue(input).booleanValue() ? Homolog.convertevalue(input) : input;
                    } else {
                        check = false;
                        JOptionPane.showMessageDialog(null, "Please check BLASTX E-value (<100)", "Warning", 2);
                    }
                }
                String input1 = jt1.getText();
                String evalue1 = "";
                if (cb2.isSelected()) {
                    if (Helpclass.isIntNumber(input1) || Homolog.checkevalue(input1).booleanValue()) {
                        evalue1 = Homolog.checkevalue(input1).booleanValue() ? Homolog.convertevalue(input1) : input1;
                    } else {
                        check = false;
                        JOptionPane.showMessageDialog(null, "Please check BLASTN E-value (<100)", "Warning", 2);
                    }
                }
                if (check) {
                    if (Helpclass.isInt(max) && Helpclass.isInt(maxloop) && max.length() > 0 && maxloop.length() > 0) {
                        if (maxbp.length() > 0 && !Helpclass.isInt(maxbp)) {
                            check = false;
                        }
                    } else {
                        check = false;
                        JOptionPane.showMessageDialog(null, "Please check parameter", "Warning", 2);
                    }
                }
                if (check) {
                    int num;
                    Foldingdata data = new Foldingdata();
                    Projectdata.isprefoldingpa = true;
                    Projectdata.threadofprefolding = num = Integer.parseInt(cb.getSelectedItem().toString());
                    data.setThread(num);
                    data.setIsblastx(cb1.isSelected());
                    data.setIsblastn(cb2.isSelected());
                    data.setBlasndb(cb21.getSelectedItem().toString());
                    data.setBlasxdb(cb11.getSelectedItem().toString());
                    data.setEvalue1(evalue);
                    data.setEvalue2(evalue1);
                    String blastxdb = cb11.getSelectedItem().toString();
                    if (blastxdb.equals("UniProt/Swiss-Prot")) {
                        data.setBlasxdb("uniprot_sprot");
                    }
                    if (blastxdb.equals("UniProt/Swiss-Prot (Plants only)")) {
                        data.setBlasxdb("uniprot_sprot_plants");
                    }
                    if (blastxdb.equals("UniProt/TrEMBL (Plants only)")) {
                        data.setBlasxdb("uniprot_trembl_plants");
                    }
                    data.setMax(Integer.parseInt(max));
                    if (maxbp.length() > 0) {
                        data.setMaxbp(Integer.parseInt(maxbp));
                    }
                    data.setMaxloop(Integer.parseInt(maxloop));
                    Projectdata.prefd = data;
                    PreFolding.this.dispose();
                }
            }
        });
        this.pack();
        this.setLocationByPlatform(true);
        Helpclass.enterPressesWhenFocused(bt);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent e) {
                bt.requestFocus();
            }
        });
        this.setVisible(true);
    }

    public static ArrayList<PreFolddata> getSq(TreeMap<String, PreFolddata> tm, int tselect) {
        ArrayList<PreFolddata> list = new ArrayList<PreFolddata>();
        int i = 0;
        while (i < tselect) {
            if (tm.size() > 0) {
                String key = tm.firstKey();
                list.add(tm.get(key));
                tm.remove(key);
            }
            ++i;
        }
        return list;
    }

    public static void main(String[] args) {
        JFrame f = new JFrame();
        new PreFolding((Frame)f, true);
        f.setSize(700, 600);
        f.getContentPane().setBackground(Color.white);
        f.setDefaultCloseOperation(3);
        f.setVisible(true);
        f.dispose();
    }
}

