/*
 * Decompiled with CFR 0.152.
 */
package frame;

import bean.CreateTable;
import bean.DBList;
import chart.BarChartDemo;
import data.Projectdata;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ProjectDes
extends JPanel {
    private static final long serialVersionUID = 1L;
    JLabel jlintro;
    JTextArea jta;
    JTextArea jta2;
    DateFormat dateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
    Date date = new Date();
    String time = this.dateFormat.format(this.date);
    DBList list;
    JPanel plmiRNA;
    JPanel plTarget;
    JPanel plmiRNAGraph;
    JPanel plTargetGraph;
    JTabbedPane jtp;

    public ProjectDes(DBList list) {
        this.list = list;
        TitledBorder tb = new TitledBorder("Project panel");
        tb.setTitleColor(Color.blue);
        tb.setTitleFont(Projectdata.fnornmal);
        this.setBorder(tb);
        this.setLayout(new BorderLayout());
        this.jta = new JTextArea("");
        this.jta.setEditable(false);
        this.jta.setForeground(Projectdata.getClrFgTxtArea());
        this.jta.setBorder(null);
        this.jta.setEditable(false);
        this.plmiRNA = new JPanel(new BorderLayout());
        this.plmiRNA.setBackground(Color.white);
        this.plmiRNA.add((Component)new JPanel(), "Center");
        this.jta2 = new JTextArea("");
        this.jta2.setEditable(false);
        this.jta2.setForeground(Projectdata.getClrFgTxtArea());
        this.jta2.setBorder(null);
        this.plTarget = new JPanel(new BorderLayout());
        this.plTarget.setBackground(Color.white);
        this.plTarget.add(new JPanel());
        this.jtp = new JTabbedPane();
        this.jtp.add((Component)this.plmiRNA, "MiRNA prediction");
        this.jtp.add((Component)this.plTarget, "Target prediction");
        this.add((Component)this.jtp, "Center");
    }

    public JPanel getWait() {
        JPanel pwait = new JPanel();
        pwait.setLayout(new FlowLayout(1));
        ImageIcon icwait = new ImageIcon("images" + System.getProperty("file.separator") + "sc2.jpeg");
        JLabel icwaitlabel = new JLabel(icwait);
        pwait.add(icwaitlabel);
        JTextArea txtcheck = new JTextArea("Viewing summary");
        txtcheck.setFont(Projectdata.ft);
        txtcheck.setBorder(null);
        txtcheck.setEditable(false);
        pwait.add(txtcheck);
        pwait.setBackground(Color.white);
        return pwait;
    }

    public void hdframe() {
        this.setVisible(false);
        this.removeAll();
        JPanel p = this.getWait();
        this.add((Component)p, "Center");
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ProjectDes.this.removeAll();
                ProjectDes.this.loadmirnasum();
                ProjectDes.this.loadtargetsum();
                final JTabbedPane newjtp = new JTabbedPane();
                newjtp.removeAll();
                newjtp.add((Component)ProjectDes.this.plmiRNA, "MiRNA prediction");
                newjtp.add((Component)ProjectDes.this.plTarget, "Target prediction");
                newjtp.addChangeListener(new ChangeListener(){

                    @Override
                    public void stateChanged(ChangeEvent changeEvent) {
                        boolean tmp;
                        int index = newjtp.getSelectedIndex();
                        if (index == 0) {
                            tmp = Projectdata.isbusy;
                            Projectdata.isbusy = true;
                            Projectdata.chgcurrentproject(Projectdata.projectname, "mirna", true);
                            Projectdata.isbusy = tmp;
                        }
                        if (index == 1) {
                            tmp = Projectdata.isbusy;
                            Projectdata.isbusy = true;
                            Projectdata.chgcurrentproject(Projectdata.projectname, "target", true);
                            Projectdata.isbusy = tmp;
                        }
                    }
                });
                ProjectDes.this.add((Component)newjtp, "Center");
                boolean tmp = Projectdata.isbusy;
                Projectdata.isbusy = true;
                Projectdata.chgcurrentproject(Projectdata.projectname, "mirna", true);
                Projectdata.isbusy = tmp;
                ProjectDes.this.setVisible(false);
                ProjectDes.this.setVisible(true);
            }
        });
    }

    public void setMSG(String mode) {
        this.setVisible(false);
        if (mode.equals("MiRNA prediction")) {
            this.loadmirnasum();
            this.add((Component)this.plmiRNA, "Center");
            boolean tmp = Projectdata.isbusy;
            Projectdata.isbusy = true;
            Projectdata.chgcurrentproject(Projectdata.projectname, "mirna", true);
            Projectdata.isbusy = tmp;
        } else {
            this.loadtargetsum();
            this.add((Component)this.plTarget, "Center");
            boolean tmp = Projectdata.isbusy;
            Projectdata.isbusy = true;
            Projectdata.chgcurrentproject(Projectdata.projectname, "target", true);
            Projectdata.isbusy = tmp;
        }
        this.setVisible(true);
    }

    public void loadmirnasum() {
        this.removeAll();
        this.plmiRNA.removeAll();
        String msg = "";
        if (Projectdata.isprefolding) {
            int w = (int)this.getSize().getWidth();
            int h = (int)this.getSize().getHeight() / 3;
            if (h < 0) {
                h = 0;
            }
            final TreeMap<String, String> summarydic = new TreeMap<String, String>();
            final JTabbedPane mirnajtp = new JTabbedPane();
            mirnajtp.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent arg0) {
                    String key = String.valueOf(mirnajtp.getSelectedIndex()) + "key";
                    String summary = (String)summarydic.get(key);
                    ProjectDes.this.jta.setText(summary);
                }
            });
            String[] outputs = Projectdata.prefoldingfile.split(",");
            ArrayList<String> loop = new ArrayList<String>();
            if (outputs.length > 1) {
                loop.add("All");
            }
            String[] stringArray = outputs;
            int n = outputs.length;
            int n2 = 0;
            while (n2 < n) {
                String name = stringArray[n2];
                loop.add(name);
                ++n2;
            }
            int index = 0;
            for (String name : loop) {
                JPanel ptab = new JPanel(new BorderLayout());
                BarChartDemo demo = new BarChartDemo("BarChart");
                this.list.loadmiRNAmodel(name);
                TreeMap<String, TreeSet<String>> tablemodel = this.list.getMiRNAmodel();
                JPanel plgraph = new JPanel();
                if (tablemodel.size() != 0) {
                    CreateTable ctable = new CreateTable();
                    JPanel pltable = ctable.makeSequenceTable(tablemodel, "mirna", name, 7);
                    demo.setSequencetable(ctable.getTable());
                    demo.setMirnatable(ctable.getmirnaTable());
                    demo.setSqDetailtable(ctable.getSqDetailTable());
                    demo.setSequencetablets(tablemodel);
                    pltable.setPreferredSize(new Dimension(w, h));
                    ptab.add((Component)pltable, "South");
                    TreeMap<String, Integer> mirnamodellocal = this.list.getmiRNADBGraph();
                    demo.createSummaryDataset(mirnamodellocal);
                    int miranmax = mirnamodellocal.size();
                    plgraph = demo.makeSummary("number of sequences", " miRNAs", "Graph", "Table", miranmax, "MiRNA Prediction detail", name, "mirna");
                } else {
                    plgraph.setBackground(Color.white);
                    plgraph.add(new JLabel("No Result"));
                }
                ptab.add((Component)plgraph, "Center");
                mirnajtp.add((Component)ptab, name);
                String summary = "Number of input sequences                                             : " + this.list.getNumOfInputSeq() + "\n" + "Number of excluded sequences                                       : " + this.list.getNumOfexcludedInputSeq() + "\n" + "Number of sequences potentially encoding miRNAs        : " + this.list.getSqCount().size() + "\n" + "Number of predicted miRNA families                                : " + this.list.getMiRNAmodel().size() + "\n" + "Number of predicted miRNA members                             : " + this.list.getMirnamember().size();
                String dickey = String.valueOf(index) + "key";
                summarydic.put(String.valueOf(index) + "key", summary);
                if (index == 0) {
                    this.jta.setText(summary);
                }
                ++index;
            }
            this.plmiRNA.add((Component)mirnajtp, "Center");
        } else {
            String summary = "";
            summary = Projectdata.isloadsequence ? "Number of input sequences                                             : " + this.list.getNumOfInputSeq() + "\n" + "Number of excluded sequences                                       : " + this.list.getNumOfexcludedInputSeq() : "Number of input sequences                                             : 0\nNumber of excluded sequences                                       : 0";
            summary = String.valueOf(summary) + "\nNumber of sequences potentially encoding miRNAs        : 0\n" + "Number of predicted miRNA families                                : 0\n" + "Number of predicted miRNA members                             : 0";
            this.jta.setText(summary);
        }
        JPanel plsummaryjta = new JPanel(new BorderLayout());
        plsummaryjta.setBackground(Color.white);
        plsummaryjta.add(this.jta);
        TitledBorder tbsumjta = new TitledBorder(LineBorder.createGrayLineBorder(), "MiRNA prediction summary");
        tbsumjta.setTitleColor(Color.blue);
        tbsumjta.setTitleFont(Projectdata.fnornmal);
        plsummaryjta.setBorder(tbsumjta);
        this.plmiRNA.add((Component)plsummaryjta, "North");
    }

    public void loadtargetsum() {
        this.removeAll();
        this.plTarget.removeAll();
        String msg = "";
        if (Projectdata.isanotation) {
            int w = (int)this.getSize().getWidth();
            int h = (int)this.getSize().getHeight() / 3;
            if (h < 0) {
                h = 0;
            }
            final TreeMap<String, String> summarydic = new TreeMap<String, String>();
            final JTabbedPane targetjtp = new JTabbedPane();
            targetjtp.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent arg0) {
                    String key = String.valueOf(targetjtp.getSelectedIndex()) + "key";
                    String summary = (String)summarydic.get(key);
                    ProjectDes.this.jta2.setText(summary);
                }
            });
            String[] outputs = Projectdata.anotationfile.split(",");
            ArrayList<String> loop = new ArrayList<String>();
            if (outputs.length > 1) {
                loop.add("All");
            }
            String[] stringArray = outputs;
            int n = outputs.length;
            int n2 = 0;
            while (n2 < n) {
                String name = stringArray[n2];
                loop.add(name);
                ++n2;
            }
            int index = 0;
            for (String name : loop) {
                JPanel ptab = new JPanel(new BorderLayout());
                BarChartDemo demo = new BarChartDemo("BarChart");
                this.list.loadTargetmodel(name);
                TreeMap<String, TreeSet<String>> tablemodel = this.list.getTargetmodel();
                JPanel plgraph = new JPanel();
                if (this.list.getTargetmodel().size() != 0) {
                    CreateTable ctable = new CreateTable();
                    TreeMap<String, TreeSet<String>> newtablemodel = ctable.tranfrommodeltarget(tablemodel);
                    JPanel pltable = ctable.makeSequenceTable(newtablemodel, "target", name, 7);
                    demo.setSequencetable(ctable.getTable());
                    demo.setMirnatable(ctable.getmirnaTable());
                    demo.setSqDetailtable(ctable.getSqDetailTable());
                    demo.setSequencetablets(newtablemodel);
                    pltable.setPreferredSize(new Dimension(w, h));
                    ptab.add((Component)pltable, "South");
                    TreeMap<String, Integer> mirnamodellocal = this.list.getTargetDBGraph(this.list.getTargetmodel());
                    demo.createSummaryDataset(mirnamodellocal);
                    int miranmax = mirnamodellocal.size();
                    plgraph = demo.makeSummary("number of targeted sequences", " miRNAs", "Graph", "Table", miranmax, "Target prediction detail", name, "target");
                } else {
                    plgraph.setBackground(Color.white);
                    plgraph.add(new JLabel("No Result"));
                }
                ptab.add((Component)plgraph, "Center");
                targetjtp.add((Component)ptab, name);
                TreeSet<String> familymirna = new TreeSet<String>();
                TreeSet<String> membermirna = new TreeSet<String>();
                TreeSet<String> members = this.list.getMembertargettm();
                for (String txt : members) {
                    familymirna.add(txt);
                    String chgmember = Projectdata.chgmirnafamily(txt);
                    membermirna.add(chgmember);
                }
                String summary = "Number of input sequences                             : " + this.list.getNumOfInputTargetSeq() + "\n" + "Number of excluded sequences                       : " + this.list.getNumOfexcludedInputTargetSeq() + "\n" + "Number of predicted targets                            : " + this.list.getNumOfTarget(name) + "\n" + "Number of miRNA families having targets    : " + membermirna.size() + "\n" + "Number of miRNA members having targets : " + familymirna.size() + " ";
                String dickey = String.valueOf(index) + "key";
                summarydic.put(String.valueOf(index) + "key", summary);
                if (index == 0) {
                    this.jta2.setText(summary);
                }
                ++index;
            }
            this.plTarget.add((Component)targetjtp, "Center");
            this.setVisible(true);
        } else {
            String summary = "";
            summary = Projectdata.isloadtargetsequence ? "Number of input sequences                             : " + this.list.getNumOfInputTargetSeq() + "\n" + "Number of excluded sequences                       : " + this.list.getNumOfexcludedInputTargetSeq() : "Number of input sequences                             : 0\nNumber of excluded sequences                       : 0";
            summary = String.valueOf(summary) + "\nNumber of predicted targets                            : 0\n" + "Number of miRNA families having targets    : 0\n" + "Number of miRNA members having targets : 0 ";
            this.jta2.setText(summary);
        }
        JPanel plsummaryjta = new JPanel(new BorderLayout());
        plsummaryjta.setBackground(Color.white);
        plsummaryjta.add(this.jta2);
        TitledBorder tbsumjta = new TitledBorder(LineBorder.createGrayLineBorder(), "Target prediction summary");
        tbsumjta.setTitleColor(Color.blue);
        tbsumjta.setTitleFont(Projectdata.fnornmal);
        plsummaryjta.setBorder(tbsumjta);
        this.plTarget.add((Component)plsummaryjta, "North");
    }

    public static void main(String[] args) {
        try {
            UIManager.LookAndFeelInfo[] lookAndFeelInfoArray = UIManager.getInstalledLookAndFeels();
            int n = lookAndFeelInfoArray.length;
            int n2 = 0;
            while (n2 < n) {
                UIManager.LookAndFeelInfo info = lookAndFeelInfoArray[n2];
                if ("Nimbus".equals(info.getName())) {
                    UIManager.setLookAndFeel(info.getClassName());
                    break;
                }
                ++n2;
            }
        }
        catch (Exception info) {
            // empty catch block
        }
        JFrame f = new JFrame();
        DBList dblist = new DBList();
        dblist.update();
        f.add(new ProjectDes(dblist));
        f.setSize(700, 600);
        f.getContentPane().setBackground(Color.white);
        f.setVisible(true);
        f.setDefaultCloseOperation(3);
    }
}

