/*
 * Decompiled with CFR 0.152.
 */
package frame;

import bean.Helpclass;
import bean.ReadFile;
import cellRender.TooltipPictureRenderAddon;
import data.Homologdata;
import data.Projectdata;
import data.RNAmap;
import data.ScanSummarydata;
import data.Systeminfo;
import frame.Homolog;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.TreeMap;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.TitledBorder;

public class Scanning
extends JDialog {
    private static final long serialVersionUID = 1L;
    JLabel err;

    public static TreeMap<String, RNAmap> loadRna() {
        String filename = String.valueOf(Projectdata.getPath("targetsequence")) + System.getProperty("file.separator") + "miRNA_query.mapping";
        String output = ReadFile.readfile(filename, "Load miRNA detail in Scan", "Scanning.java").trim();
        String[] outputs = output.split("\n");
        TreeMap<String, RNAmap> maprnas = new TreeMap<String, RNAmap>();
        String[] stringArray = outputs;
        int n = outputs.length;
        int n2 = 0;
        while (n2 < n) {
            String lines = stringArray[n2];
            String[] line_split = lines.split("\t");
            RNAmap data = new RNAmap();
            data.setName(">" + line_split[2]);
            data.setDetail(line_split[1]);
            maprnas.put(line_split[0], data);
            ++n2;
        }
        return maprnas;
    }

    public static ArrayList<RNAmap> loadRnaNew() {
        String filename = String.valueOf(Projectdata.getPath("targetsequence")) + System.getProperty("file.separator") + "miRNA_query.show";
        String output = ReadFile.readfile(filename, "Load miRNA in scan", "Scanning.java");
        String[] outputs = output.split("\n");
        ArrayList<RNAmap> al = new ArrayList<RNAmap>();
        String[] stringArray = outputs;
        int n = outputs.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            String[] st = string.split("\t");
            RNAmap data = new RNAmap();
            data.setName(String.valueOf(st[0]) + "#" + st[1]);
            data.setDetail(st[2]);
            al.add(data);
            ++n2;
        }
        return al;
    }

    public static ArrayList<RNAmap> loadRna(String filename) {
        String output = ReadFile.readfile(filename, "Load miRNA in scan", "Scanning.java");
        String[] outputs = output.split("\n");
        ArrayList<RNAmap> al = new ArrayList<RNAmap>();
        int i = 0;
        while (i < outputs.length) {
            RNAmap data = new RNAmap();
            data.setName(outputs[i]);
            data.setDetail(outputs[i + 1]);
            al.add(data);
            i += 2;
        }
        return al;
    }

    public static TreeMap<String, RNAmap> makeRNADIC() {
        String filename = String.valueOf(Projectdata.getPath("targetsequence")) + System.getProperty("file.separator") + "miRNA_query.show";
        String output = ReadFile.readfile(filename, "Load miRNA in scan", "Scanning.java");
        String[] outputs = output.split("\n");
        TreeMap<String, RNAmap> rnamap = new TreeMap<String, RNAmap>();
        String[] stringArray = outputs;
        int n = outputs.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            String[] st = string.split("\t");
            RNAmap data = new RNAmap();
            data.setName(String.valueOf(st[0]) + "#" + st[1]);
            data.setDetail(st[2]);
            rnamap.put(data.getName().trim(), data);
            ++n2;
        }
        return rnamap;
    }

    public static TreeMap<String, RNAmap> makeTreemap(ArrayList<RNAmap> input) {
        TreeMap<String, RNAmap> data = new TreeMap<String, RNAmap>();
        for (RNAmap rnAmap : input) {
            data.put(rnAmap.getName(), rnAmap);
        }
        return data;
    }

    public Scanning(Frame owner, boolean modal) {
        super(owner, modal);
        this.setTitle("Target scanning");
        JPanel p0 = new JPanel(new FlowLayout(2));
        ImageIcon ic = new ImageIcon("images" + System.getProperty("file.separator") + "target_scan.gif");
        JLabel lbheader = new JLabel("Target scanning");
        p0.add(lbheader);
        p0.add(new JLabel(ic));
        p0.setBackground(Color.white);
        p0.setBorder(new TitledBorder(""));
        JPanel p1 = new JPanel();
        TitledBorder tb = new TitledBorder("Target scanning parameters");
        tb.setTitleColor(Color.blue);
        tb.setTitleFont(Projectdata.fnornmal);
        p1.setBorder(tb);
        this.setLayout(new BorderLayout());
        final JPanel p11 = new JPanel();
        p11.setLayout(new GridLayout(1, 2));
        p11.add(new JLabel("E value"));
        final JTextField jt = new JTextField(5);
        jt.setText("20");
        p11.add(jt);
        JPanel p12 = new JPanel();
        p12.setLayout(new GridLayout(1, 2));
        p12.add(new JLabel("Search method"));
        String[] s = new String[]{"BLAST + SCAN", "SCAN"};
        final JComboBox<String> cb = new JComboBox<String>(s);
        p12.add(cb);
        cb.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                JComboBox jcb = (JComboBox)arg0.getSource();
                String svalue = jcb.getSelectedItem().toString().trim();
                if (svalue.equals("SCAN")) {
                    p11.setVisible(false);
                } else {
                    p11.setVisible(true);
                }
            }
        });
        JPanel p13 = new JPanel();
        p13.setLayout(new GridLayout(1, 2));
        JLabel mismatch = new JLabel("Binding score ");
        mismatch.setIcon(Projectdata.getICNotic());
        mismatch.setToolTipText(TooltipPictureRenderAddon.makettmultiline("The score is calculated from the number of mismatches (1 each) and GU pairs (0.5 each) \nbetween a source miRNA and its binding site on an input sequence."));
        mismatch.setFont(Projectdata.fnornmal);
        p13.add(mismatch);
        String[] s1 = new String[]{"0", "<=1", "<=2", "<=3", "<=4", "<=5", "<=6"};
        final JComboBox<String> cb1 = new JComboBox<String>(s1);
        cb1.setFont(Projectdata.fnornmal);
        p13.add(cb1);
        int tcount = Integer.parseInt(new Systeminfo().getCpunum());
        Object[] ts = new Object[]{"1", "2", "3", "4", "5", "6", "7", "8", "9"};
        if (tcount < 9) {
            ArrayList<String> al = new ArrayList<String>();
            int i = 1;
            while (i <= tcount) {
                al.add(Integer.toString(i));
                ++i;
            }
            ts = al.toArray();
        }
        cb1.setSelectedItem("<=4");
        JPanel p14 = new JPanel();
        p14.setLayout(new GridLayout(1, 2));
        final JComboBox<Object> tcb = new JComboBox<Object>(ts);
        tcb.setFont(Projectdata.fnornmal);
        JLabel thread = new JLabel("Number of processors ");
        thread.setFont(Projectdata.fnornmal);
        p14.add(thread);
        p14.add(tcb);
        Systeminfo info = Projectdata.info;
        Box pinpjut = Box.createVerticalBox();
        pinpjut.add(p12);
        pinpjut.add(Box.createVerticalStrut(10));
        pinpjut.add(p11);
        pinpjut.add(Box.createVerticalStrut(10));
        pinpjut.add(p13);
        pinpjut.add(Box.createVerticalStrut(10));
        pinpjut.add(p14);
        pinpjut.add(Box.createVerticalStrut(10));
        JLabel msg = new JLabel();
        msg.setForeground(Color.red);
        msg.setVisible(false);
        final JButton bt = new JButton("Scan");
        bt.setFont(Projectdata.fnornmal);
        bt.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                String filename = String.valueOf(Projectdata.getPathSep("targetsequence")) + Projectdata.targetsequencename + ".status";
                ScanSummarydata ssdata = new ScanSummarydata();
                ssdata.load(filename);
                int sqsize = ssdata.getNumberofseq();
                String searchmethod = cb.getSelectedItem().toString();
                if (searchmethod.equals("SCAN") && sqsize > 1000) {
                    JOptionPane.showMessageDialog(null, "The scan method limits number of input sequences to be less than or equal to 1000 for performance purpose.", "Warning", 2);
                } else {
                    boolean checkpass = true;
                    if (checkpass) {
                        boolean check = true;
                        String input = jt.getText();
                        String evalue = "";
                        if (Helpclass.isIntNumber(input) || Homolog.checkevalue(input).booleanValue()) {
                            evalue = Homolog.checkevalue(input).booleanValue() ? Homolog.convertevalue(input) : input;
                        } else {
                            check = false;
                            JOptionPane.showMessageDialog(null, "Please check E-value (<100)", "Warning", 2);
                        }
                        String strmismatch = cb1.getSelectedItem().toString();
                        strmismatch = strmismatch.replaceAll("<=", "").trim();
                        int mismatch = Integer.parseInt(strmismatch);
                        String nothread = tcb.getSelectedItem().toString();
                        int wordsize = 4;
                        if (check) {
                            Homologdata hm = new Homologdata();
                            hm.setEvalue(evalue);
                            hm.setMismatch(mismatch);
                            hm.setWordsize(wordsize);
                            hm.setNothread(nothread);
                            hm.setSearchmethod(searchmethod);
                            Projectdata.isscanningdata = true;
                            Projectdata.scanningdata = hm;
                            Scanning.this.setVisible(false);
                        }
                    } else {
                        JOptionPane.showMessageDialog(null, "Please select at least a plant to proceed", "Warning", 2);
                    }
                }
            }
        });
        JPanel pbutton = new JPanel();
        JButton btclose = new JButton("Cancel");
        btclose.setFont(Projectdata.fnornmal);
        pbutton.add(bt);
        pbutton.add(btclose);
        pbutton.add(btclose);
        this.err = new JLabel("Check E-value (<100)");
        this.err.setFont(Projectdata.fnornmal);
        this.err.setForeground(Color.red);
        this.err.setVisible(false);
        pbutton.add(this.err);
        pinpjut.add(pbutton);
        btclose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                Scanning.this.dispose();
            }
        });
        p1.setLayout(new BorderLayout());
        JPanel ptmp = new JPanel();
        ptmp.add(pinpjut);
        p1.add((Component)ptmp, "Center");
        this.add((Component)p0, "North");
        this.add((Component)p1, "Center");
        this.add((Component)msg, "South");
        this.pack();
        this.setLocationByPlatform(true);
        Helpclass.enterPressesWhenFocused(bt);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent e) {
                bt.requestFocus();
            }
        });
        this.setVisible(true);
    }

    public static void main(String[] args) {
        final JFrame f = new JFrame();
        try {
            UIManager.LookAndFeelInfo[] lookAndFeelInfoArray = UIManager.getInstalledLookAndFeels();
            int n = lookAndFeelInfoArray.length;
            int n2 = 0;
            while (n2 < n) {
                UIManager.LookAndFeelInfo info = lookAndFeelInfoArray[n2];
                if ("Nimbus".equals(info.getName())) {
                    UIManager.setLookAndFeel(info.getClassName());
                    break;
                }
                ++n2;
            }
        }
        catch (Exception info) {
            // empty catch block
        }
        f.setLayout(new FlowLayout());
        JButton bt = new JButton("test");
        bt.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                new Scanning((Frame)f, true);
            }
        });
        f.add(bt);
        f.setSize(200, 100);
        f.getContentPane().setBackground(Color.white);
        f.setVisible(true);
        f.setDefaultCloseOperation(3);
    }

    public static Boolean checkevalue(String value) {
        Boolean check = true;
        String[] sectionevalue = value.split("-");
        if (sectionevalue.length != 2) {
            check = false;
        } else {
            String firstsection = sectionevalue[0].trim();
            String secondvalue = sectionevalue[1].trim();
            if (!firstsection.equals("e") && !firstsection.equals("E")) {
                check = false;
            }
            try {
                Integer.parseInt(secondvalue);
            }
            catch (Exception e) {
                check = false;
            }
        }
        return check;
    }

    public static String convertevalue(String value) {
        StringBuffer sb = new StringBuffer();
        String[] sectionevalue = value.split("-");
        String secondvalue = sectionevalue[1].trim();
        int count = Integer.parseInt(secondvalue);
        sb.append("1.");
        int i = 0;
        while (i < count - 1) {
            sb.append("0");
            ++i;
        }
        sb.append("1");
        return sb.toString();
    }
}

