/*
 * Decompiled with CFR 0.152.
 */
package frame;

import cellRender.DefaultGrayTableCellRenderer;
import cellRender.JLabelMapSqname;
import cellRender.JLabelSortRender;
import cellRender.StrandRenderer;
import data.Projectdata;
import data.Sequencedata;
import frame.PreFoldingdes;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import javax.swing.table.DefaultTableModel;

public class ShowSequences
extends JPanel {
    JScrollPane sp;
    JTable table;
    ArrayList<Sequencedata> datas;

    public JTable getTable() {
        return this.table;
    }

    public JScrollPane getSp() {
        return this.sp;
    }

    public ShowSequences(final ArrayList<Sequencedata> datas) {
        DefaultTableModel model = new DefaultTableModel(){

            @Override
            public boolean isCellEditable(int row, int col) {
                return false;
            }
        };
        this.datas = datas;
        this.table = new JTable(model);
        this.table.setFont(Projectdata.fnornmal);
        this.table.getTableHeader().setReorderingAllowed(false);
        this.table.setAutoResizeMode(0);
        this.table.setAutoCreateRowSorter(true);
        model.addColumn("");
        model.addColumn("Sequence name");
        model.addColumn("Strand");
        model.addColumn("Detail");
        this.table.getColumnModel().getColumn(0).setCellRenderer(new JLabelSortRender());
        this.table.getColumnModel().getColumn(1).setCellRenderer(new JLabelMapSqname());
        this.table.getColumnModel().getColumn(2).setCellRenderer(new StrandRenderer());
        this.table.getColumnModel().getColumn(3).setCellRenderer(new DefaultGrayTableCellRenderer());
        for (Sequencedata data : datas) {
            Vector<String> r1 = new Vector<String>();
            r1.addElement("1");
            r1.addElement(data.getName());
            r1.addElement(data.getStrand());
            String detail = data.getexportsq().toUpperCase();
            if (data.isIshlpos()) {
                int start = Integer.parseInt(data.getPre_start());
                int stop = Integer.parseInt(data.getPre_stop());
                String tmp = data.getexportsq().toUpperCase();
                StringBuffer sb = new StringBuffer();
                sb.append("<html>");
                int i = 0;
                while (i < tmp.length()) {
                    if (i >= start && i <= stop) {
                        String color = "blue";
                        if (tmp.charAt(i) == 'A') {
                            color = "red";
                        }
                        if (tmp.charAt(i) == 'U') {
                            color = "blue";
                        }
                        if (tmp.charAt(i) == 'G') {
                            color = "green";
                        }
                        if (tmp.charAt(i) == 'C') {
                            color = "#660000";
                        }
                        sb.append("<font color='" + color + "'>" + tmp.charAt(i) + "</font>");
                    } else {
                        sb.append(tmp.charAt(i));
                    }
                    ++i;
                }
                sb.append("</html>");
                detail = sb.toString();
            }
            r1.addElement(detail);
            model.addRow(r1);
        }
        this.setLayout(new BorderLayout());
        this.sp = new JScrollPane(this.table);
        JPanel menu = new JPanel();
        menu.setLayout(new FlowLayout(0));
        TitledBorder tb = new TitledBorder(LineBorder.createGrayLineBorder(), "Operation");
        tb.setTitleColor(Color.blue);
        tb.setTitleFont(Projectdata.fnornmal);
        JButton btsave = new JButton();
        btsave.setToolTipText("Save sequences");
        ImageIcon ic = new ImageIcon("images" + System.getProperty("file.separator") + "save_project.gif");
        btsave.setPreferredSize(new Dimension(ic.getIconWidth(), ic.getIconHeight()));
        btsave.setIcon(ic);
        btsave.setBorderPainted(false);
        btsave.setFont(Projectdata.fnornmal);
        btsave.setBackground(Color.white);
        menu.add(btsave);
        btsave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                JFileChooser jf = new JFileChooser(String.valueOf(Projectdata.projectpath) + System.getProperty("file.separator") + Projectdata.projectname + System.getProperty("file.separator"));
                PreFoldingdes.setFileChooserFont(jf.getComponents());
                int r = jf.showDialog(null, "Save");
                if (r == 0) {
                    StringBuffer sb = new StringBuffer();
                    for (Sequencedata data : datas) {
                        String shortname = String.valueOf(data.getName()) + "-" + data.getStrand();
                        if (shortname.trim().charAt(0) == '>') {
                            shortname = shortname.substring(1, shortname.length());
                        }
                        String fullname = Sequencedata.getFullname(Projectdata.sm, data.getName());
                        String cmp = data.getexportsq();
                        if (data.isIshlpos()) {
                            int start = Integer.parseInt(data.getPre_start()) - 1;
                            int stop = Integer.parseInt(data.getPre_stop()) - 1;
                            StringBuffer newsb = new StringBuffer();
                            int i = 0;
                            while (i < cmp.length()) {
                                if (i == start) {
                                    newsb.append("(start)");
                                    newsb.append(cmp.charAt(i));
                                } else if (i == stop) {
                                    newsb.append(cmp.charAt(i));
                                    newsb.append("(stop)");
                                } else {
                                    newsb.append(cmp.charAt(i));
                                }
                                ++i;
                            }
                            cmp = newsb.toString();
                        }
                        String msg = ">" + shortname + " (" + fullname + ")\n" + cmp + "\n";
                        sb.append(msg);
                    }
                    boolean exprt = true;
                    try {
                        File f = jf.getSelectedFile();
                        PrintWriter pw = new PrintWriter(f);
                        pw.println(sb.toString());
                        pw.close();
                    }
                    catch (Exception e1) {
                        exprt = false;
                    }
                    if (exprt) {
                        JOptionPane.showMessageDialog(null, "Export complete.");
                    } else {
                        JOptionPane.showMessageDialog(null, "Error while export", "Error", 0);
                    }
                }
            }
        });
        this.add((Component)menu, "North");
        this.add((Component)this.sp, "Center");
    }

    public static void main(String[] args) {
        JFrame f = new JFrame();
        ArrayList<Sequencedata> al = new ArrayList<Sequencedata>();
        f.add(new ShowSequences(al));
        f.setSize(300, 300);
        f.setDefaultCloseOperation(3);
        f.setVisible(true);
    }
}

