/*
 * Decompiled with CFR 0.152.
 */
package frame;

import bean.CheckDbInstall;
import bean.Helpclass;
import cellRender.CheckBoxHeader;
import data.Projectdata;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.PrintWriter;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import listener.MyItemListener;
import update.RetriveGetFileThread;
import update.RetriveUpdatelistThread;

public class Update
extends JDialog {
    JPanel jpstatus;
    JPanel pltable;
    JPanel plcontrol;
    JPanel plloadfile;
    DefaultTableModel model;
    JProgressBar pball;
    JProgressBar pbnow;
    Update dialog = this;
    JLabel msginfo;
    JButton btcloseinfo;
    JPanel pwait;
    JLabel jmsgwait;
    JLabel jwaitRetrive;
    JPanel tmp;

    public void setjpstatus() {
        this.msginfo.setText("Could not connect to SFTP server");
        this.btcloseinfo.setVisible(true);
        this.jwaitRetrive.setVisible(false);
    }

    public void viewupdatelist() {
        this.tmp.setBackground(null);
        this.jpstatus.setVisible(false);
        this.pltable.setVisible(true);
        this.plcontrol.setVisible(true);
        this.plloadfile.setVisible(false);
    }

    public void viewloadfile() {
        this.jpstatus.setVisible(false);
        this.pltable.setVisible(false);
        this.plloadfile.setVisible(true);
    }

    public TreeMap<String, String> getdbsta() {
        String filename;
        CheckDbInstall cdbins = new CheckDbInstall();
        TreeMap<String, String> tm = new TreeMap<String, String>();
        if (cdbins.getMature().booleanValue()) {
            filename = String.valueOf(Projectdata.getPathSep("database")) + "mature_miRBase.txt";
            tm.put("mature_miRBase.txt", cdbins.getFilesize(filename));
        }
        if (cdbins.getUniprot_sprot().booleanValue()) {
            filename = String.valueOf(Projectdata.getPathSep("database")) + "uniprot_sprot.fasta";
            tm.put("uniprot_sprot.fasta", cdbins.getFilesize(filename));
        }
        if (cdbins.getUniprot_sprot_plant().booleanValue()) {
            filename = String.valueOf(Projectdata.getPathSep("database")) + "uniprot_sprot_plants.fasta";
            tm.put("uniprot_sprot_plants.fasta", cdbins.getFilesize(filename));
        }
        if (cdbins.getUniprot_sprot_trembl().booleanValue()) {
            filename = String.valueOf(Projectdata.getPathSep("database")) + "uniprot_trembl_plants.fasta";
            tm.put("uniprot_trembl_plants.fasta", cdbins.getFilesize(filename));
        }
        if (cdbins.getRfam().booleanValue()) {
            filename = String.valueOf(Projectdata.getPathSep("database")) + "Rfam.fasta";
            tm.put("Rfam.fasta", cdbins.getFilesize(filename));
        }
        return tm;
    }

    public void loaddata(boolean chk, String keyword) {
        TreeMap<String, String> tm = this.getdbsta();
        this.model.getDataVector().removeAllElements();
        this.model.fireTableDataChanged();
        String filename = String.valueOf(Projectdata.getPathSep("update")) + "updatelist.txt";
        try {
            String output;
            File f = new File(filename);
            FileReader fr = new FileReader(f);
            BufferedReader bfr = new BufferedReader(fr);
            while ((output = bfr.readLine()) != null) {
                Vector<Object> r1;
                String[] list = output.split("\t");
                String sta = "<html><b>Please update database</b></html>";
                String key = list[2].trim().split(",")[0].trim();
                if (tm.get(key) != null) {
                    String value = tm.get(key);
                    String incom = value.trim();
                    String insev = list[5].trim();
                    if (insev.equals(incom)) {
                        sta = "The database is up-to-date";
                    }
                }
                if (chk && !keyword.equals("ALL")) {
                    if (!list[6].toLowerCase().trim().equals(keyword.toLowerCase())) continue;
                    r1 = new Vector();
                    r1.addElement(Boolean.FALSE);
                    r1.addElement(list[1]);
                    r1.addElement(list[4]);
                    r1.addElement(list[2]);
                    r1.addElement(list[5]);
                    r1.addElement(list[0]);
                    r1.addElement(list[3]);
                    r1.addElement(sta);
                    this.model.addRow(r1);
                    continue;
                }
                r1 = new Vector<Object>();
                r1.addElement(Boolean.FALSE);
                r1.addElement(list[1]);
                r1.addElement(list[4]);
                r1.addElement(list[2]);
                r1.addElement(list[5]);
                r1.addElement(list[0]);
                r1.addElement(list[3]);
                r1.addElement(sta);
                this.model.addRow(r1);
            }
            bfr.close();
            fr.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.model.fireTableDataChanged();
    }

    public Update(Frame owner, boolean modal) {
        super(owner, modal);
        this.setTitle("Check for update");
        this.setLayout(new BorderLayout());
        this.jpstatus = new JPanel(new FlowLayout());
        this.jpstatus.setBackground(Color.white);
        this.msginfo = new JLabel("Retrieving database list from c-mii server");
        ImageIcon icwait = new ImageIcon("images" + System.getProperty("file.separator") + "waiting.gif");
        this.jwaitRetrive = new JLabel(icwait);
        this.jpstatus.add(this.jwaitRetrive);
        this.jpstatus.add(this.msginfo);
        this.btcloseinfo = new JButton("Close");
        this.jpstatus.add(this.btcloseinfo);
        this.btcloseinfo.setVisible(false);
        this.btcloseinfo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                Update.this.dispose();
            }
        });
        this.add((Component)this.jpstatus, "North");
        this.model = new DefaultTableModel(){

            @Override
            public boolean isCellEditable(int row, int col) {
                return col == 0;
            }
        };
        this.model.addColumn("");
        this.model.addColumn("Database");
        this.model.addColumn("Describe");
        this.model.addColumn("list");
        this.model.addColumn("size");
        this.model.addColumn("id");
        this.model.addColumn("version");
        this.model.addColumn("Status");
        final JTable table = new JTable(this.model);
        table.getTableHeader().setReorderingAllowed(false);
        table.removeColumn(table.getColumnModel().getColumn(6));
        table.removeColumn(table.getColumnModel().getColumn(5));
        table.removeColumn(table.getColumnModel().getColumn(4));
        table.removeColumn(table.getColumnModel().getColumn(3));
        table.setAutoCreateRowSorter(true);
        TableColumn col = table.getColumnModel().getColumn(0);
        col.setMaxWidth(50);
        col = table.getColumnModel().getColumn(0);
        col.setHeaderRenderer(new CheckBoxHeader(new MyItemListener(table)));
        col.setCellRenderer(table.getDefaultRenderer(Boolean.class));
        col.setCellEditor(table.getDefaultEditor(Boolean.class));
        table.getColumnModel().getColumn(0).setPreferredWidth(Projectdata.getCBWidth());
        JScrollPane jptable = new JScrollPane(table);
        this.pltable = new JPanel();
        this.pltable.setLayout(new BorderLayout());
        JPanel pdisplay = new JPanel();
        pdisplay.setLayout(new BorderLayout());
        Object[] ts = new Object[]{"miRNA", "Protein", "RNA", "ALL"};
        JPanel p14 = new JPanel();
        p14.setLayout(new FlowLayout(0));
        final JComboBox<Object> tcb = new JComboBox<Object>(ts);
        tcb.setFont(Projectdata.fnornmal);
        tcb.setSelectedItem("ALL");
        JLabel msg_select_type = new JLabel("Select database type");
        msg_select_type.setFont(Projectdata.fnornmal);
        p14.add(msg_select_type);
        p14.add(tcb);
        JButton btokmode = new JButton("Select");
        btokmode.setFont(Projectdata.fnornmal);
        btokmode.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                Update.this.loaddata(true, tcb.getSelectedItem().toString().trim());
            }
        });
        this.plcontrol = new JPanel();
        JButton btok = new JButton("Update");
        btok.setFont(Projectdata.fnornmal);
        JButton btcc = new JButton("Cancel");
        btcc.setFont(Projectdata.fnornmal);
        this.plcontrol.add(btok);
        this.plcontrol.add(btcc);
        this.plcontrol.setVisible(false);
        p14.add(btokmode);
        TitledBorder tb = new TitledBorder(LineBorder.createGrayLineBorder(), "Check for update option");
        tb.setTitleColor(Color.blue);
        tb.setTitleFont(Projectdata.fnornmal);
        p14.setBorder(tb);
        p14.setBackground(Color.white);
        pdisplay.add((Component)p14, "North");
        JPanel msgtable = new JPanel();
        TitledBorder tb1 = new TitledBorder("Check for update detail");
        tb1.setTitleColor(Color.blue);
        tb1.setTitleFont(Projectdata.fnornmal);
        msgtable.setBorder(tb1);
        msgtable.setLayout(new BorderLayout());
        msgtable.add((Component)jptable, "Center");
        msgtable.add((Component)this.plcontrol, "South");
        pdisplay.add((Component)msgtable, "Center");
        TitledBorder tb2 = new TitledBorder("Check for update panel");
        tb2.setTitleColor(Color.blue);
        tb2.setTitleFont(Projectdata.fnornmal);
        pdisplay.setBorder(tb2);
        this.pltable.add(pdisplay);
        this.pltable.setVisible(false);
        this.plloadfile = new JPanel();
        this.plloadfile.setVisible(false);
        TitledBorder tb3 = new TitledBorder("Check for update panel");
        tb3.setTitleColor(Color.blue);
        tb3.setTitleFont(Projectdata.fnornmal);
        this.plloadfile.setBorder(tb3);
        this.plloadfile.setLayout(new BorderLayout());
        this.pball = new JProgressBar();
        this.pbnow = new JProgressBar();
        JPanel plpball = new JPanel(new FlowLayout(0));
        plpball.setBackground(Color.white);
        JTextField msg1 = new JTextField("Total\t");
        msg1.setFont(Projectdata.fnornmal);
        msg1.setEditable(false);
        msg1.setBorder(null);
        msg1.setBackground(Color.white);
        plpball.add(msg1);
        plpball.add(this.pball);
        final JLabel sum1 = new JLabel("[ calculate file sizes ]");
        plpball.add(sum1);
        JPanel plpbnow = new JPanel(new FlowLayout(0));
        plpbnow.setBackground(Color.white);
        JTextField msg2 = new JTextField("File download\t");
        msg2.setFont(Projectdata.fnornmal);
        msg2.setEditable(false);
        msg2.setBorder(null);
        msg2.setBackground(Color.white);
        plpbnow.add(msg2);
        plpbnow.add(this.pbnow);
        final JLabel sum2 = new JLabel("[ calculate file sizes ] ");
        plpbnow.add(sum2);
        ImageIcon icwait1 = new ImageIcon("images" + System.getProperty("file.separator") + "waiting.gif");
        JLabel jwait = new JLabel(icwait1);
        this.pwait = new JPanel(new FlowLayout(0));
        this.pwait.setBackground(Color.white);
        this.pwait.add(jwait);
        this.jmsgwait = new JLabel("Wait for formatdb process");
        this.pwait.add(this.jmsgwait);
        this.pwait.setVisible(false);
        JPanel pbbox = new JPanel(new BorderLayout());
        TitledBorder tb4 = new TitledBorder(LineBorder.createGrayLineBorder(), "Process status");
        tb4.setTitleColor(Color.blue);
        tb4.setTitleFont(Projectdata.fnornmal);
        pbbox.setBorder(tb4);
        pbbox.setBackground(Color.white);
        pbbox.add((Component)plpball, "North");
        pbbox.add((Component)this.pwait, "South");
        final JTextArea text = new JTextArea();
        text.setFont(Projectdata.fnornmal);
        text.setEditable(false);
        text.setText("Start ..");
        JScrollPane sptext = new JScrollPane(text);
        TitledBorder tb5 = new TitledBorder(LineBorder.createGrayLineBorder(), "Process status detail");
        tb5.setTitleColor(Color.blue);
        tb5.setTitleFont(Projectdata.fnornmal);
        JPanel p = new JPanel(new BorderLayout());
        p.setBorder(tb5);
        p.setBackground(Color.white);
        p.add((Component)sptext, "Center");
        this.plloadfile.add((Component)p, "Center");
        this.plloadfile.add((Component)pbbox, "North");
        JPanel pbtfin = new JPanel();
        pbtfin.setLayout(new FlowLayout(0));
        final JButton btfinish = new JButton("Finish");
        btfinish.setFont(Projectdata.fnornmal);
        btfinish.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                Update.this.dispose();
            }
        });
        btfinish.setEnabled(false);
        pbtfin.add(btfinish);
        JButton btcancle = new JButton("Cancle");
        btcancle.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Update.this.dispose();
            }
        });
        this.plloadfile.add((Component)pbtfin, "South");
        btok.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                boolean todo = false;
                int rowcount = table.getRowCount();
                int i = 0;
                while (i < rowcount) {
                    Object cmp = table.getValueAt(i, 0);
                    if (cmp == Boolean.TRUE) {
                        todo = true;
                    }
                    ++i;
                }
                if (todo) {
                    Helpclass.clearfolder(Projectdata.getPathSep("update"));
                    Update.this.viewloadfile();
                    new RetriveGetFileThread(table, Update.this.model, text, sum2, Update.this.pbnow, sum1, Update.this.pball, btfinish, Update.this.pwait, Update.this.jmsgwait).start();
                } else {
                    JOptionPane.showMessageDialog(null, "Please select at least a database", "Warning", 2);
                }
            }
        });
        btcc.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                Update.this.dispose();
            }
        });
        this.tmp = new JPanel();
        this.tmp.setLayout(new BorderLayout());
        this.tmp.add((Component)this.pltable, "North");
        this.tmp.add((Component)this.plloadfile, "Center");
        this.tmp.setBackground(Color.white);
        this.add((Component)this.tmp, "Center");
        this.setDefaultCloseOperation(2);
        this.setSize(650, 675);
        this.setLocationByPlatform(true);
        this.setVisible(true);
        new RetriveUpdatelistThread(this).start();
    }

    public static void main(String[] args) {
        final JFrame f = new JFrame();
        JButton bt = new JButton("Update");
        bt.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                Update update = new Update((Frame)f, false);
            }
        });
        f.setLayout(new FlowLayout());
        f.add(bt);
        f.setSize(200, 200);
        f.setDefaultCloseOperation(3);
        f.setVisible(true);
    }

    public void rmlog() {
        String filename = String.valueOf(Projectdata.getPathSep("update")) + "log.txt";
        File f = new File(filename);
        if (f.exists()) {
            f.delete();
        }
    }

    public void writelog(String msg) {
        String filename = String.valueOf(Projectdata.getPathSep("update")) + "log.txt";
        try {
            File f = new File(filename);
            PrintWriter pw = new PrintWriter(f);
            pw.println(msg);
            pw.flush();
            pw.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

