/*
 * Decompiled with CFR 0.152.
 */
package frame;

import bean.GenColorFold;
import bean.ImageView;
import bean.RawImage;
import bean.ReadFile;
import cellRender.JLabelSortRender;
import data.Blastoutput;
import data.Homologoutputdata;
import data.Projectdata;
import data.Ps2PDFdata;
import data.Sequencedata;
import frame.ShowSequences;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import javax.swing.table.DefaultTableModel;
import listener.HlFoldListener;
import menu.Picturemenu;

public class ViewFold
extends JPanel {
    private static final long serialVersionUID = 1L;
    boolean viewmode = true;
    JTextArea txtcheck;
    JPanel p;
    JPanel p0;
    JPanel p1;
    JPanel detail;
    JPanel pwait;
    JLabel icwaitlabel;
    ImageIcon ic;
    JLabel lic;
    JScrollPane sp;
    ImageView iv;
    RawImage ri;
    Picturemenu pm;
    JPanel blastdetail;
    JTextArea jtblast;
    JScrollPane spsummary;
    JTextArea summary;
    JScrollPane sp1;
    JTable table;
    DefaultTableModel model;
    HlFoldListener hl;
    TitledBorder tb1;
    TitledBorder tb2;
    Ps2PDFdata ps2pdf = new Ps2PDFdata();
    Box b;

    public boolean isViewmode() {
        return this.viewmode;
    }

    public void setViewmode(boolean viewmode) {
        this.viewmode = viewmode;
        this.ps2pdf.setBln(viewmode);
    }

    public void setTxtcheck(String str, boolean color) {
        this.txtcheck.setText(str);
        if (color) {
            this.txtcheck.setForeground(Color.blue);
        } else {
            this.txtcheck.setForeground(Color.black);
        }
        this.setBackground(Color.white);
        this.icwaitlabel.setVisible(true);
    }

    public void showwait(String msg) {
        StringBuffer newmsg = new StringBuffer();
        int i = 0;
        while (i < msg.length()) {
            if (i == 0) {
                newmsg.append(String.valueOf(msg.charAt(i)).toUpperCase());
            } else {
                newmsg.append(String.valueOf(msg.charAt(i)));
            }
            ++i;
        }
        msg = newmsg.toString();
        int frameheight = Projectdata.plfoldingdes.getHeight();
        this.setPreferredSize(new Dimension(this.getWidth(), frameheight /= 2));
        this.setTxtcheck(msg, false);
        this.pwait.setVisible(true);
        this.p.setVisible(false);
        this.blastdetail.setVisible(false);
        this.p1.setVisible(false);
        this.setVisible(true);
    }

    public void makewait(String msg, final ArrayList<Sequencedata> ts) {
        StringBuffer newmsg = new StringBuffer();
        int i = 0;
        while (i < msg.length()) {
            if (i == 0) {
                newmsg.append(String.valueOf(msg.charAt(i)).toUpperCase());
            } else {
                newmsg.append(String.valueOf(msg.charAt(i)));
            }
            ++i;
        }
        msg = newmsg.toString();
        int frameheight = Projectdata.plfoldingdes.getHeight();
        this.setPreferredSize(new Dimension(this.getWidth(), frameheight /= 2));
        this.setTxtcheck(msg, false);
        this.pwait.setVisible(true);
        this.p.setVisible(false);
        this.blastdetail.setVisible(false);
        this.p1.setVisible(false);
        this.setVisible(true);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Projectdata.autoclear();
                ShowSequences pview = new ShowSequences(ts);
                ViewFold.this.p.removeAll();
                ViewFold.this.p.add(pview);
                ViewFold.this.pwait.setVisible(false);
                ViewFold.this.p.setVisible(true);
                ViewFold.this.blastdetail.setVisible(false);
                ViewFold.this.p1.setVisible(false);
                ViewFold.this.setVisible(true);
                int sizewd = ViewFold.this.getWidth();
                JTable table = pview.getTable();
                int rowcount = table.getRowCount();
                String max = "NA";
                int i = 0;
                while (i < rowcount) {
                    String cmp = table.getValueAt(i, 3).toString();
                    cmp = cmp.replaceAll("</html>", "");
                    cmp = cmp.replaceAll("<html>", "");
                    cmp = cmp.replaceAll("</font>", "");
                    cmp = cmp.replaceAll("<font color='red'>", "");
                    cmp = cmp.replaceAll("<font color='#660000'>", "");
                    cmp = cmp.replaceAll("<font color='green'>", "");
                    if ((cmp = cmp.replaceAll("<font color='blue'>", "")).length() > max.length()) {
                        max = cmp;
                    }
                    ++i;
                }
                table.getColumnModel().getColumn(0).setPreferredWidth(Projectdata.getFontWidth(String.valueOf(table.getRowCount()) + " "));
                table.getColumnModel().getColumn(2).setPreferredWidth(Projectdata.getFontWidth("xxxxplusxx"));
                int remainwd = sizewd - (table.getColumnModel().getColumn(0).getPreferredWidth() + table.getColumnModel().getColumn(2).getPreferredWidth());
                table.getColumnModel().getColumn(1).setPreferredWidth(remainwd / 2);
                max = String.valueOf(max) + "addspace";
                table.getColumnModel().getColumn(3).setPreferredWidth(Projectdata.getFontWidth(max));
            }
        });
    }

    public ViewFold() {
        this.ps2pdf.setBln(true);
        this.setBackground(Color.white);
        this.setLayout(new CardLayout());
        this.p = new JPanel();
        this.p.setBackground(Color.white);
        JPanel pviwepic = new JPanel();
        pviwepic.setLayout(new BorderLayout());
        String filename = "images" + System.getProperty("file.separator") + "folding.gif";
        this.pm = new Picturemenu();
        this.pm.visiblebutton();
        this.iv = new ImageView(filename);
        this.sp = new JScrollPane(this.iv);
        this.sp.setBackground(Color.white);
        this.hl = new HlFoldListener(new String());
        this.pm.addHilightFoldlistener(this.hl);
        this.p.setLayout(new BorderLayout());
        JPanel pmsp = new JPanel(new BorderLayout());
        this.tb1 = new TitledBorder(LineBorder.createGrayLineBorder(), "");
        this.tb1.setTitleColor(Color.blue);
        this.tb1.setTitleFont(Projectdata.fnornmal);
        pmsp.setBorder(this.tb1);
        pmsp.add((Component)this.pm, "North");
        pmsp.add((Component)this.sp, "Center");
        this.summary = new JTextArea();
        this.summary.setEditable(false);
        this.detail = new JPanel();
        this.detail.setLayout(new BorderLayout());
        this.spsummary = new JScrollPane(this.summary);
        this.detail.add((Component)this.spsummary, "Center");
        this.tb2 = new TitledBorder(LineBorder.createGrayLineBorder(), "");
        this.tb2.setTitleColor(Color.blue);
        this.tb2.setTitleFont(Projectdata.fnornmal);
        this.detail.setBorder(this.tb2);
        this.b = Box.createHorizontalBox();
        JPanel pdf = new JPanel();
        this.b.add(pdf);
        this.b.add(this.detail);
        this.p.add((Component)this.b, "Center");
        this.add("picture", this.p);
        this.p1 = new JPanel();
        this.add("notfound", this.p1);
        this.p1.setVisible(false);
        this.table = new JTable();
        this.model = new DefaultTableModel(){

            @Override
            public boolean isCellEditable(int row, int col) {
                return false;
            }
        };
        this.table = new JTable(this.model);
        this.table.setFont(Projectdata.fnornmal);
        this.table.setAutoCreateRowSorter(true);
        this.table.getTableHeader().setReorderingAllowed(false);
        this.table.setAutoResizeMode(1);
        this.model.addColumn("No");
        this.model.addColumn("Query name");
        this.model.addColumn("Subject name");
        this.model.addColumn("Frame");
        this.model.addColumn("Score");
        this.model.addColumn("E value");
        this.model.addColumn("Identities");
        this.table.getColumnModel().getColumn(0).setCellRenderer(new JLabelSortRender());
        this.table.getColumnModel().getColumn(0).setMaxWidth(40);
        this.table.getColumnModel().getColumn(0).setResizable(false);
        this.blastdetail = new JPanel(new BorderLayout());
        this.sp1 = new JScrollPane(this.table);
        this.blastdetail.add((Component)this.sp1, "Center");
        TitledBorder tb3 = new TitledBorder("Blast output");
        tb3.setTitleColor(Color.blue);
        tb3.setTitleFont(Projectdata.fnornmal);
        this.blastdetail.setBorder(tb3);
        this.add("blast", this.blastdetail);
        this.pwait = new JPanel();
        this.pwait.setLayout(new FlowLayout(1));
        ImageIcon icwait = new ImageIcon("images" + System.getProperty("file.separator") + "sc2.jpeg");
        this.icwaitlabel = new JLabel(icwait);
        this.pwait.add(this.icwaitlabel);
        this.txtcheck = new JTextArea("Viewing structure");
        this.txtcheck.setFont(Projectdata.ft);
        this.txtcheck.setBorder(null);
        this.txtcheck.setEditable(false);
        this.pwait.add(this.txtcheck);
        this.pwait.setBackground(Color.white);
        this.add("wait", this.pwait);
        this.pwait.setVisible(false);
        this.blastdetail.setVisible(false);
        this.p.setVisible(true);
    }

    public void waitprocess(String msg) {
        StringBuffer newmsg = new StringBuffer();
        int i = 0;
        while (i < msg.length()) {
            if (i == 0) {
                newmsg.append(String.valueOf(msg.charAt(i)).toUpperCase());
            } else {
                newmsg.append(String.valueOf(msg.charAt(i)));
            }
            ++i;
        }
        msg = newmsg.toString();
        int frameheight = Projectdata.plfoldingdes.getHeight();
        this.setPreferredSize(new Dimension(this.getWidth(), frameheight /= 2));
        this.pwait.setBackground(Color.white);
        this.setTxtcheck(msg, false);
        this.pwait.setVisible(true);
        this.p.setVisible(false);
        this.blastdetail.setVisible(false);
        this.p1.setVisible(false);
        this.setVisible(true);
    }

    public void viewImage1(final String str, String strlength, final String strcount, final String pathmode, final String pos1, final String pos2) {
        this.setBackground(Color.white);
        int frameheight = Projectdata.plfoldingdes.getHeight();
        this.setPreferredSize(new Dimension(this.getWidth(), frameheight /= 2));
        this.setTxtcheck("Viewing structure", false);
        this.validate();
        this.pwait.setVisible(true);
        this.p.setVisible(false);
        this.blastdetail.setVisible(false);
        this.p1.setVisible(false);
        this.setVisible(true);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                String filename;
                Projectdata.autoclear();
                ViewFold.this.pm.zoomenable(true, false);
                String foldingtrack = "";
                boolean psedit = false;
                if (ViewFold.this.viewmode) {
                    JButton bt = ViewFold.this.pm.getHlpdf();
                    StringBuffer sb1 = new StringBuffer();
                    if (pathmode.equals("prefolding")) {
                        psedit = true;
                        bt.setText("Highlight pre-miRNA secondary structure");
                        String filename2 = String.valueOf(Projectdata.outfileSep(pathmode)) + str + "_1.ct";
                        String msg = ViewFold.redctfile(filename2, "Pre-");
                        String ftfilename = String.valueOf(Projectdata.outfileSep("prefolding")) + "foldingtrack";
                        foldingtrack = ReadFile.readfile(ftfilename, "read track folding", "viewfold.java");
                        foldingtrack = foldingtrack.trim();
                        String hfilename = String.valueOf(Projectdata.outfileSep("foldingoutput", foldingtrack)) + "homologdetail";
                        ArrayList<Homologoutputdata> list = Projectdata.plhomologdes.loaddata(hfilename, true);
                        sb1.append("\n");
                        boolean tag = true;
                        for (Homologoutputdata homologoutputdata : list) {
                            String key = String.valueOf(homologoutputdata.getInput_sequence_name().trim()) + "-" + homologoutputdata.getPotential_miRNA().trim() + "-" + homologoutputdata.getStrand().trim();
                            if (!strcount.trim().equals(key) || !tag) continue;
                            sb1.append("Hit positions :" + homologoutputdata.getHit_position().replaceAll("_", "-") + "\n");
                            sb1.append("Source-predicted miRNA mismatches :" + homologoutputdata.getNumber_of_mismatch() + "\n");
                            sb1.append("Strand :" + homologoutputdata.getStrand() + "\n");
                            tag = false;
                        }
                        msg = String.valueOf(msg) + sb1.toString();
                        ViewFold.this.summary.setText(msg);
                    } else if (pathmode.equals("foldingoutput#pre")) {
                        bt.setText("Highlight pri-miRNA secondary structure");
                        String ftfilename = String.valueOf(Projectdata.outfileSep("prefolding")) + "foldingtrack";
                        foldingtrack = ReadFile.readfile(ftfilename, "read track folding", "viewfold.java");
                        foldingtrack = foldingtrack.trim();
                        String hfilename = String.valueOf(Projectdata.outfileSep("foldingoutput", foldingtrack)) + "homologdetail";
                        ArrayList<Homologoutputdata> list = Projectdata.plhomologdes.loaddata(hfilename, true);
                        sb1.append("\n");
                        boolean tag = true;
                        for (Homologoutputdata homologoutputdata : list) {
                            String key = String.valueOf(homologoutputdata.getInput_sequence_name().trim()) + "-" + homologoutputdata.getPotential_miRNA().trim() + "-" + homologoutputdata.getStrand().trim();
                            if (!strcount.trim().equals(key) || !tag) continue;
                            sb1.append("Hit positions :" + homologoutputdata.getHit_position().replaceAll("_", "-") + "\n");
                            sb1.append("Source-predicted miRNA mismatches :" + homologoutputdata.getNumber_of_mismatch() + "\n");
                            sb1.append("Strand :" + homologoutputdata.getStrand() + "\n");
                            tag = false;
                        }
                        String filename3 = String.valueOf(Projectdata.outfileSep("foldingoutput", foldingtrack)) + str + "_1.ct";
                        String msg = ViewFold.redctfile(filename3, "Pri-");
                        msg = String.valueOf(msg) + sb1.toString();
                        ViewFold.this.summary.setText(msg);
                    } else {
                        bt.setText("Highlight pri-miRNA secondary structure");
                        String hfilename = String.valueOf(Projectdata.outfileSep(pathmode)) + "homologdetail";
                        ArrayList<Homologoutputdata> list = Projectdata.plhomologdes.loaddata(hfilename, true);
                        sb1.append("\n");
                        boolean tag = true;
                        for (Homologoutputdata homologoutputdata : list) {
                            String key = String.valueOf(homologoutputdata.getInput_sequence_name().trim()) + "-" + homologoutputdata.getPotential_miRNA().trim() + "-" + homologoutputdata.getStrand().trim();
                            if (!strcount.trim().equals(key) || !tag) continue;
                            sb1.append("Hit positions :" + homologoutputdata.getHit_position().replaceAll("_", "-") + "\n");
                            sb1.append("Source-predicted miRNA mismatches :" + homologoutputdata.getNumber_of_mismatch() + "\n");
                            sb1.append("Strand :" + homologoutputdata.getStrand() + "\n");
                            tag = false;
                        }
                        String filename4 = String.valueOf(Projectdata.outfileSep(pathmode)) + str + "_1.ct";
                        String msg = ViewFold.redctfile(filename4, "Pri-");
                        msg = String.valueOf(msg) + sb1.toString();
                        ViewFold.this.summary.setText(msg);
                    }
                } else {
                    filename = String.valueOf(Projectdata.outfileSep("targetfolding")) + str + "_1.ct";
                    String msg = ViewFold.redctfile(filename, "");
                    ViewFold.this.summary.setText(msg);
                }
                ViewFold.this.ps2pdf.setPsname(str);
                try {
                    String path;
                    filename = "";
                    if (ViewFold.this.viewmode) {
                        if (pathmode.equals("foldingoutput#pre")) {
                            path = Projectdata.outfileSep("foldingoutput", foldingtrack);
                            filename = String.valueOf(path) + str + "_1.ps";
                            ViewFold.this.ps2pdf.setPath(path);
                        } else {
                            path = Projectdata.outfileSep(pathmode);
                            filename = String.valueOf(path) + str + "_1.ps";
                            ViewFold.this.ps2pdf.setPath(path);
                        }
                    } else {
                        path = Projectdata.outfileSep("targetfolding");
                        filename = String.valueOf(Projectdata.outfileSep("targetfolding")) + str + "_1.ps";
                        ViewFold.this.ps2pdf.setPath(path);
                    }
                    File f = new File(filename.trim());
                    if (f.exists()) {
                        final String psfile = ViewFold.this.ps2pdf.getPsname();
                        String path2 = "";
                        final String tmppath = path2 = ViewFold.this.ps2pdf.getPath();
                        File ftest = new File(String.valueOf(path2) + psfile);
                        if (ftest.exists()) {
                            JPanel pdf = GenColorFold.genFile(psfile, path2, psedit, pos1, pos2);
                            pdf.setBackground(Color.white);
                            JButton bt = new JButton("Open in new window");
                            final boolean psedit2 = psedit;
                            bt.addActionListener(new ActionListener(){

                                @Override
                                public void actionPerformed(ActionEvent arg0) {
                                    JFrame newwindow = new JFrame("Open in new windwos");
                                    JPanel pdf = GenColorFold.genFile(psfile, tmppath, psedit2, pos1, pos2);
                                    newwindow.add(pdf);
                                    newwindow.setSize(500, 500);
                                    newwindow.setVisible(true);
                                }
                            });
                            bt.setFont(Projectdata.fnornmal);
                            JPanel jbt = new JPanel(new FlowLayout(0));
                            jbt.add(bt);
                            JPanel pview = new JPanel();
                            pview.setBorder(ViewFold.this.tb1);
                            pview.setLayout(new BorderLayout());
                            pview.add((Component)jbt, "North");
                            pview.add((Component)pdf, "Center");
                            ViewFold.this.p.removeAll();
                            JTabbedPane bnew = new JTabbedPane();
                            bnew.add((Component)pview, "MiRNA secondary structure");
                            bnew.add((Component)ViewFold.this.detail, "MiRNA secondary structure detail");
                            ViewFold.this.p.add(bnew);
                        }
                        ViewFold.this.pwait.setVisible(false);
                        ViewFold.this.p.setVisible(true);
                        ViewFold.this.blastdetail.setVisible(false);
                        ViewFold.this.p1.setVisible(false);
                    } else {
                        ViewFold.this.setTxtcheck("Can not view structure, sequence can not be folded", false);
                        ViewFold.this.icwaitlabel.setVisible(false);
                        ViewFold.this.pwait.setVisible(true);
                        ViewFold.this.p.setVisible(false);
                        ViewFold.this.blastdetail.setVisible(false);
                        ViewFold.this.p1.setVisible(false);
                    }
                    ViewFold.this.validate();
                    ViewFold.this.setVisible(true);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
    }

    public void viewPreBlastdetail(String shortname, String fullname, String mode, String sqname) {
        int frameheight = Projectdata.plfoldingdes.getHeight();
        this.setPreferredSize(new Dimension(this.getWidth(), frameheight /= 2));
        this.setVisible(true);
        this.model.getDataVector().removeAllElements();
        this.model.fireTableDataChanged();
        ArrayList<Blastoutput> dataoutput = ViewFold.readPreBlast(String.valueOf(fullname) + "." + mode, shortname);
        for (Blastoutput data : dataoutput) {
            Vector<String> r1 = new Vector<String>();
            r1.addElement("1");
            String mapfullname = Sequencedata.getFullname(Projectdata.sm, sqname);
            r1.addElement(mapfullname);
            r1.addElement(data.getSubject_name());
            r1.addElement(data.getFrame());
            r1.addElement(data.getScore());
            r1.addElement(data.getE_value());
            r1.addElement(data.getIdentities());
            this.model.addRow(r1);
        }
        this.model.fireTableDataChanged();
        this.pwait.setVisible(false);
        this.p.setVisible(false);
        this.blastdetail.setVisible(true);
        this.p1.setVisible(false);
    }

    public void viewBlastdetail(String shortname, String fullname, String mode) {
        int frameheight = Projectdata.plfoldingdes.getHeight();
        this.setPreferredSize(new Dimension(this.getWidth(), frameheight /= 2));
        this.setVisible(true);
        this.model.getDataVector().removeAllElements();
        this.model.fireTableDataChanged();
        ArrayList<Blastoutput> dataoutput = ViewFold.readBlast(String.valueOf(fullname) + "." + mode, shortname);
        for (Blastoutput data : dataoutput) {
            Vector<String> r1 = new Vector<String>();
            r1.addElement("1");
            String mapfullname = Sequencedata.getFullname(Projectdata.sm, data.getQuery_name());
            r1.addElement(mapfullname);
            r1.addElement(data.getSubject_name());
            r1.addElement(data.getFrame());
            r1.addElement(data.getScore());
            r1.addElement(data.getE_value());
            r1.addElement(data.getIdentities());
            this.model.addRow(r1);
        }
        this.model.fireTableDataChanged();
        this.pwait.setVisible(false);
        this.p.setVisible(false);
        this.blastdetail.setVisible(true);
        this.p1.setVisible(false);
    }

    public static ArrayList<Blastoutput> readBlast(String name, String displayname) {
        String filename = String.valueOf(Projectdata.outfileSep("foldingoutput")) + System.getProperty("file.separator") + name;
        String output = new String();
        ArrayList<Blastoutput> dataoutput = new ArrayList<Blastoutput>();
        try {
            FileReader fr = new FileReader(filename);
            BufferedReader br = new BufferedReader(fr);
            while ((output = br.readLine()) != null) {
                String[] tmp = output.split("\t");
                Blastoutput data = new Blastoutput();
                data.setQuery_name(displayname);
                data.setSubject_name(tmp[1]);
                data.setFrame(tmp[2]);
                data.setScore(tmp[3]);
                data.setE_value(tmp[4]);
                data.setIdentities(tmp[5]);
                dataoutput.add(data);
            }
            br.close();
            fr.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return dataoutput;
    }

    public static ArrayList<Blastoutput> readPreBlast(String name, String displayname) {
        String filename = String.valueOf(Projectdata.outfileSep("prefolding")) + System.getProperty("file.separator") + name;
        String output = new String();
        ArrayList<Blastoutput> dataoutput = new ArrayList<Blastoutput>();
        try {
            FileReader fr = new FileReader(filename);
            BufferedReader br = new BufferedReader(fr);
            while ((output = br.readLine()) != null) {
                String[] tmp = output.split("\t");
                Blastoutput data = new Blastoutput();
                data.setQuery_name(displayname);
                data.setSubject_name(tmp[1]);
                data.setFrame(tmp[2]);
                data.setScore(tmp[3]);
                data.setE_value(tmp[4]);
                data.setIdentities(tmp[5]);
                dataoutput.add(data);
            }
            br.close();
            fr.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return dataoutput;
    }

    public static void main(String[] args) {
        JFrame f = new JFrame();
        f.setDefaultCloseOperation(3);
        f.add(new ViewFold());
        f.setSize(500, 500);
        f.setVisible(true);
    }

    public static String redctfile(String filename, String mode) {
        StringBuffer sb = new StringBuffer();
        if (new File(filename).exists()) {
            Object tmp;
            String output = ReadFile.readfile(filename, "read ct file", "viewfold.java");
            String[] outputs = output.split("\n");
            int count = 0;
            int counta = 0;
            int countu = 0;
            int countg = 0;
            int countc = 0;
            int countn = 0;
            int sqlength = 0;
            int sqcounta = 0;
            int sqcountu = 0;
            int sqcountg = 0;
            int sqcountc = 0;
            int sqcountn = 0;
            int mirnalength = 0;
            int rnacounta = 0;
            int rnacountu = 0;
            int rnacountg = 0;
            int rnacountc = 0;
            int rnacountn = 0;
            String[] stringArray = outputs;
            int n = outputs.length;
            int n2 = 0;
            while (n2 < n) {
                String string = stringArray[n2];
                if (count != 0) {
                    String cmp;
                    tmp = string.split("\t");
                    String cmp1 = tmp[1].trim();
                    if (cmp1.equals("a")) {
                        ++sqlength;
                        ++sqcounta;
                    }
                    if (cmp1.equals("u")) {
                        ++sqlength;
                        ++sqcountu;
                    }
                    if (cmp1.equals("g")) {
                        ++sqlength;
                        ++sqcountg;
                    }
                    if (cmp1.equals("c")) {
                        ++sqlength;
                        ++sqcountc;
                    }
                    if (cmp1.equals("n")) {
                        ++sqlength;
                        ++sqcountn;
                    }
                    if (cmp1.equals("A")) {
                        ++mirnalength;
                        ++rnacounta;
                    }
                    if (cmp1.equals("U")) {
                        ++mirnalength;
                        ++rnacountu;
                    }
                    if (cmp1.equals("G")) {
                        ++mirnalength;
                        ++rnacountg;
                    }
                    if (cmp1.equals("C")) {
                        ++mirnalength;
                        ++rnacountc;
                    }
                    if (cmp1.equals("N")) {
                        ++mirnalength;
                        ++rnacountn;
                    }
                    if ((cmp = tmp[1].toLowerCase().trim()).equals("a")) {
                        ++counta;
                    }
                    if (cmp.equals("u")) {
                        ++countu;
                    }
                    if (cmp.equals("g")) {
                        ++countg;
                    }
                    if (cmp.equals("c")) {
                        ++countc;
                    }
                    if (cmp.equals("n")) {
                        ++countn;
                    }
                }
                ++count;
                ++n2;
            }
            String[] msg1 = outputs[0].split("\t");
            String bufmsg = "";
            if (mode.equals("")) {
                sb.append("\nTarget sequence length :" + sqlength + "\n");
                sb.append("Nucleotide content : A(" + sqcounta + "), U(" + sqcountu + "), G(" + sqcountg + "), C(" + sqcountc + "), N(" + sqcountn + ")\n");
                sb.append("\nMiRNA sequence length :" + mirnalength + "\n");
                sb.append("Nucleotide content : A(" + rnacounta + "), U(" + rnacountu + "), G(" + rnacountg + "), C(" + rnacountc + "), N(" + rnacountn + ")\n\n");
            } else {
                bufmsg = "miRNA sequence";
                sb.append("\n" + mode + bufmsg + " length :" + msg1[0] + "\n");
                sb.append("Nucleotide content : A(" + counta + "), U(" + countu + "), G(" + countg + "), C(" + countc + "), N(" + countn + ")\n");
            }
            double gccontent = (double)(countg + countc) / (double)(counta + countu + countg + countc + countn) * 100.0;
            tmp = String.valueOf(gccontent);
            if (((String)tmp).length() > 5) {
                tmp = ((String)tmp).substring(0, 5);
            }
            if (!mode.equals("")) {
                sb.append("GC content(%) :" + (String)tmp + "\n");
            }
            String mfe = msg1[1].replaceAll("dG =", "");
            sb.append("MFE :" + mfe.trim() + " kcal/mol\n");
            if (!mode.equals("")) {
                if (gccontent == 0.0) {
                    sb.append("MFEI : NA\n");
                } else {
                    double mfei = Double.parseDouble(mfe.trim()) / Double.parseDouble(msg1[0]) * 100.0;
                    String tmp1 = String.valueOf(mfei /= gccontent);
                    if (tmp1.length() > 5) {
                        tmp1 = tmp1.substring(0, 5);
                    }
                    sb.append("MFEI : " + tmp1 + " kcal/mol\n");
                }
            }
        }
        return sb.toString();
    }

    public static String getMFE(String filename) {
        String mfe = "NA";
        if (new File(filename).exists()) {
            String output = ReadFile.readfile(filename, "read ct file", "viewfold.java");
            String[] outputs = output.split("\n");
            int count = 0;
            int counta = 0;
            int countu = 0;
            int countg = 0;
            int countc = 0;
            int countn = 0;
            int sqlength = 0;
            int sqcounta = 0;
            int sqcountu = 0;
            int sqcountg = 0;
            int sqcountc = 0;
            int sqcountn = 0;
            int mirnalength = 0;
            int rnacounta = 0;
            int rnacountu = 0;
            int rnacountg = 0;
            int rnacountc = 0;
            int rnacountn = 0;
            String[] stringArray = outputs;
            int n = outputs.length;
            int n2 = 0;
            while (n2 < n) {
                String string = stringArray[n2];
                if (count != 0) {
                    String cmp;
                    String[] tmp = string.split("\t");
                    String cmp1 = tmp[1].trim();
                    if (cmp1.equals("a")) {
                        ++sqlength;
                        ++sqcounta;
                    }
                    if (cmp1.equals("u")) {
                        ++sqlength;
                        ++sqcountu;
                    }
                    if (cmp1.equals("g")) {
                        ++sqlength;
                        ++sqcountg;
                    }
                    if (cmp1.equals("c")) {
                        ++sqlength;
                        ++sqcountc;
                    }
                    if (cmp1.equals("n")) {
                        ++sqlength;
                        ++sqcountn;
                    }
                    if (cmp1.equals("A")) {
                        ++mirnalength;
                        ++rnacounta;
                    }
                    if (cmp1.equals("U")) {
                        ++mirnalength;
                        ++rnacountu;
                    }
                    if (cmp1.equals("G")) {
                        ++mirnalength;
                        ++rnacountg;
                    }
                    if (cmp1.equals("C")) {
                        ++mirnalength;
                        ++rnacountc;
                    }
                    if (cmp1.equals("N")) {
                        ++mirnalength;
                        ++rnacountn;
                    }
                    if ((cmp = tmp[1].toLowerCase().trim()).equals("a")) {
                        ++counta;
                    }
                    if (cmp.equals("u")) {
                        ++countu;
                    }
                    if (cmp.equals("g")) {
                        ++countg;
                    }
                    if (cmp.equals("c")) {
                        ++countc;
                    }
                    if (cmp.equals("n")) {
                        ++countn;
                    }
                }
                ++count;
                ++n2;
            }
            String[] msg1 = outputs[0].split("\t");
            double gccontent = (double)(countg + countc) / (double)(counta + countu + countg + countc + countn) * 100.0;
            String tmp = String.valueOf(gccontent);
            if (tmp.length() > 5) {
                tmp = tmp.substring(0, 5);
            }
            mfe = msg1[1].replaceAll("dG =", "");
            mfe = String.valueOf(mfe.trim()) + " kcal/mol";
        }
        return mfe;
    }
}

