/*
 * Decompiled with CFR 0.152.
 */
package menu;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.URL;
import java.util.Calendar;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.text.BadLocationException;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import javax.swing.text.StyledDocument;

public class TextSamplerDemo
extends JPanel
implements ActionListener {
    private String newline = "\n";
    protected static final String textFieldString = "JTextField";
    protected static final String passwordFieldString = "JPasswordField";
    protected static final String ftfString = "JFormattedTextField";
    protected static final String buttonString = "JButton";
    protected JLabel actionLabel;

    public TextSamplerDemo() {
        this.setLayout(new BorderLayout());
        JTextField textField = new JTextField(10);
        textField.setActionCommand(textFieldString);
        textField.addActionListener(this);
        JPasswordField passwordField = new JPasswordField(10);
        passwordField.setActionCommand(passwordFieldString);
        passwordField.addActionListener(this);
        JFormattedTextField ftf = new JFormattedTextField(Calendar.getInstance().getTime());
        ftf.setActionCommand(textFieldString);
        ftf.addActionListener(this);
        JLabel textFieldLabel = new JLabel("JTextField: ");
        textFieldLabel.setLabelFor(textField);
        JLabel passwordFieldLabel = new JLabel("JPasswordField: ");
        passwordFieldLabel.setLabelFor(passwordField);
        JLabel ftfLabel = new JLabel("JFormattedTextField: ");
        ftfLabel.setLabelFor(ftf);
        this.actionLabel = new JLabel("Type text in a field and press Enter.");
        this.actionLabel.setBorder(BorderFactory.createEmptyBorder(10, 0, 0, 0));
        JPanel textControlsPane = new JPanel();
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        textControlsPane.setLayout(gridbag);
        JLabel[] labels = new JLabel[]{textFieldLabel, passwordFieldLabel, ftfLabel};
        JTextField[] textFields = new JTextField[]{textField, passwordField, ftf};
        this.addLabelTextRows(labels, textFields, gridbag, textControlsPane);
        c.gridwidth = 0;
        c.anchor = 17;
        c.weightx = 1.0;
        textControlsPane.add((Component)this.actionLabel, c);
        textControlsPane.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Text Fields"), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        JTextArea textArea = new JTextArea("This is an editable JTextArea. A text area is a \"plain\" text component, which means that although it can display text in any font, all of the text is in the same font.");
        textArea.setFont(new Font("Serif", 2, 16));
        textArea.setLineWrap(true);
        textArea.setWrapStyleWord(true);
        JScrollPane areaScrollPane = new JScrollPane(textArea);
        areaScrollPane.setVerticalScrollBarPolicy(22);
        areaScrollPane.setPreferredSize(new Dimension(250, 250));
        areaScrollPane.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Plain Text"), BorderFactory.createEmptyBorder(5, 5, 5, 5)), areaScrollPane.getBorder()));
        JEditorPane editorPane = this.createEditorPane();
        JScrollPane editorScrollPane = new JScrollPane(editorPane);
        editorScrollPane.setVerticalScrollBarPolicy(22);
        editorScrollPane.setPreferredSize(new Dimension(250, 145));
        editorScrollPane.setMinimumSize(new Dimension(10, 10));
        JTextPane textPane = this.createTextPane();
        JScrollPane paneScrollPane = new JScrollPane(textPane);
        paneScrollPane.setVerticalScrollBarPolicy(22);
        paneScrollPane.setPreferredSize(new Dimension(250, 155));
        paneScrollPane.setMinimumSize(new Dimension(10, 10));
        JSplitPane splitPane = new JSplitPane(0, editorScrollPane, paneScrollPane);
        splitPane.setOneTouchExpandable(true);
        splitPane.setResizeWeight(0.5);
        JPanel rightPane = new JPanel(new GridLayout(1, 0));
        rightPane.add(splitPane);
        rightPane.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Styled Text"), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        JPanel leftPane = new JPanel(new BorderLayout());
        leftPane.add((Component)textControlsPane, "First");
        leftPane.add((Component)areaScrollPane, "Center");
        this.add((Component)leftPane, "Before");
        this.add((Component)rightPane, "After");
    }

    private void addLabelTextRows(JLabel[] labels, JTextField[] textFields, GridBagLayout gridbag, Container container) {
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 13;
        int numLabels = labels.length;
        int i = 0;
        while (i < numLabels) {
            c.gridwidth = -1;
            c.fill = 0;
            c.weightx = 0.0;
            container.add((Component)labels[i], c);
            c.gridwidth = 0;
            c.fill = 2;
            c.weightx = 1.0;
            container.add((Component)textFields[i], c);
            ++i;
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String prefix = "You typed \"";
        if (textFieldString.equals(e.getActionCommand())) {
            JTextField source = (JTextField)e.getSource();
            this.actionLabel.setText(String.valueOf(prefix) + source.getText() + "\"");
        } else if (passwordFieldString.equals(e.getActionCommand())) {
            JPasswordField source = (JPasswordField)e.getSource();
            this.actionLabel.setText(String.valueOf(prefix) + new String(source.getPassword()) + "\"");
        } else if (buttonString.equals(e.getActionCommand())) {
            Toolkit.getDefaultToolkit().beep();
        }
    }

    private JEditorPane createEditorPane() {
        JEditorPane editorPane = new JEditorPane();
        editorPane.setEditable(false);
        URL helpURL = TextSamplerDemo.class.getResource("TextSamplerDemoHelp.html");
        if (helpURL != null) {
            try {
                editorPane.setPage(helpURL);
            }
            catch (IOException e) {
                System.err.println("Attempted to read a bad URL: " + helpURL);
            }
        } else {
            System.err.println("Couldn't find file: TextSampleDemoHelp.html");
        }
        return editorPane;
    }

    private JTextPane createTextPane() {
        String[] initString = new String[]{"This is an editable JTextPane, ", "another ", "styled ", "text ", "component, ", "which supports embedded components..." + this.newline, " " + this.newline, "...and embedded icons..." + this.newline, " ", String.valueOf(this.newline) + "JTextPane is a subclass of JEditorPane that " + "uses a StyledEditorKit and StyledDocument, and provides " + "cover methods for interacting with those objects."};
        String[] initStyles = new String[]{"regular", "italic", "bold", "small", "large", "regular", "button", "regular", "icon", "regular"};
        JTextPane textPane = new JTextPane();
        StyledDocument doc = textPane.getStyledDocument();
        this.addStylesToDocument(doc);
        try {
            int i = 0;
            while (i < initString.length) {
                doc.insertString(doc.getLength(), initString[i], doc.getStyle(initStyles[i]));
                ++i;
            }
        }
        catch (BadLocationException ble) {
            System.err.println("Couldn't insert initial text into text pane.");
        }
        return textPane;
    }

    protected void addStylesToDocument(StyledDocument doc) {
        Style def = StyleContext.getDefaultStyleContext().getStyle("default");
        Style regular = doc.addStyle("regular", def);
        StyleConstants.setFontFamily(def, "SansSerif");
        Style s = doc.addStyle("italic", regular);
        StyleConstants.setItalic(s, true);
        s = doc.addStyle("bold", regular);
        StyleConstants.setBold(s, true);
        s = doc.addStyle("small", regular);
        StyleConstants.setFontSize(s, 10);
        s = doc.addStyle("large", regular);
        StyleConstants.setFontSize(s, 16);
        s = doc.addStyle("icon", regular);
        StyleConstants.setAlignment(s, 1);
        ImageIcon pigIcon = TextSamplerDemo.createImageIcon("images/Pig.gif", "a cute pig");
        if (pigIcon != null) {
            StyleConstants.setIcon(s, pigIcon);
        }
        s = doc.addStyle("button", regular);
        StyleConstants.setAlignment(s, 1);
        ImageIcon soundIcon = TextSamplerDemo.createImageIcon("images/sound.gif", "sound icon");
        JButton button = new JButton();
        if (soundIcon != null) {
            button.setIcon(soundIcon);
        } else {
            button.setText("BEEP");
        }
        button.setCursor(Cursor.getDefaultCursor());
        button.setMargin(new Insets(0, 0, 0, 0));
        button.setActionCommand(buttonString);
        button.addActionListener(this);
        StyleConstants.setComponent(s, button);
    }

    protected static ImageIcon createImageIcon(String path, String description) {
        URL imgURL = TextSamplerDemo.class.getResource(path);
        if (imgURL != null) {
            return new ImageIcon(imgURL, description);
        }
        System.err.println("Couldn't find file: " + path);
        return null;
    }

    private static void createAndShowGUI() {
        JFrame frame = new JFrame("TextSamplerDemo");
        frame.setDefaultCloseOperation(3);
        frame.add(new TextSamplerDemo());
        frame.pack();
        frame.setVisible(true);
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                UIManager.put("swing.boldMetal", Boolean.FALSE);
                TextSamplerDemo.createAndShowGUI();
            }
        });
    }
}

