/*
 * Decompiled with CFR 0.152.
 */
package prefuse.demos;

import java.awt.Component;
import java.util.Iterator;
import javax.swing.JFrame;
import prefuse.Display;
import prefuse.Visualization;
import prefuse.action.Action;
import prefuse.action.ActionList;
import prefuse.action.RepaintAction;
import prefuse.action.assignment.ColorAction;
import prefuse.action.assignment.DataColorAction;
import prefuse.action.layout.graph.ForceDirectedLayout;
import prefuse.controls.Control;
import prefuse.controls.PanControl;
import prefuse.controls.ZoomControl;
import prefuse.data.Graph;
import prefuse.data.Node;
import prefuse.demos.AggregateDragControl;
import prefuse.demos.AggregateLayout;
import prefuse.render.DefaultRendererFactory;
import prefuse.render.PolygonRenderer;
import prefuse.render.Renderer;
import prefuse.render.RendererFactory;
import prefuse.render.ShapeRenderer;
import prefuse.util.ColorLib;
import prefuse.visual.AggregateItem;
import prefuse.visual.AggregateTable;
import prefuse.visual.VisualGraph;
import prefuse.visual.VisualItem;

public class AggregateDemo
extends Display {
    public static final String GRAPH = "graph";
    public static final String NODES = "graph.nodes";
    public static final String EDGES = "graph.edges";
    public static final String AGGR = "aggregates";

    public AggregateDemo() {
        super(new Visualization());
        this.initDataGroups();
        ShapeRenderer nodeR = new ShapeRenderer(20);
        PolygonRenderer polyR = new PolygonRenderer(1);
        polyR.setCurveSlack(0.15f);
        DefaultRendererFactory drf = new DefaultRendererFactory();
        drf.setDefaultRenderer((Renderer)nodeR);
        drf.add("ingroup('aggregates')", (Renderer)polyR);
        this.m_vis.setRendererFactory((RendererFactory)drf);
        ColorAction nStroke = new ColorAction(NODES, VisualItem.STROKECOLOR);
        nStroke.setDefaultColor(ColorLib.gray((int)100));
        nStroke.add("_hover", ColorLib.gray((int)50));
        ColorAction nFill = new ColorAction(NODES, VisualItem.FILLCOLOR);
        nFill.setDefaultColor(ColorLib.gray((int)255));
        nFill.add("_hover", ColorLib.gray((int)200));
        ColorAction nEdges = new ColorAction(EDGES, VisualItem.STROKECOLOR);
        nEdges.setDefaultColor(ColorLib.gray((int)100));
        ColorAction aStroke = new ColorAction(AGGR, VisualItem.STROKECOLOR);
        aStroke.setDefaultColor(ColorLib.gray((int)200));
        aStroke.add("_hover", ColorLib.rgb((int)255, (int)100, (int)100));
        int[] palette = new int[]{ColorLib.rgba((int)255, (int)200, (int)200, (int)150), ColorLib.rgba((int)200, (int)255, (int)200, (int)150), ColorLib.rgba((int)200, (int)200, (int)255, (int)150)};
        DataColorAction aFill = new DataColorAction(AGGR, "id", 0, VisualItem.FILLCOLOR, palette);
        ActionList colors = new ActionList();
        colors.add((Action)nStroke);
        colors.add((Action)nFill);
        colors.add((Action)nEdges);
        colors.add((Action)aStroke);
        colors.add((Action)aFill);
        ActionList layout = new ActionList(-1L);
        layout.add((Action)colors);
        layout.add((Action)new ForceDirectedLayout(GRAPH, true));
        layout.add((Action)new AggregateLayout(AGGR));
        layout.add((Action)new RepaintAction());
        this.m_vis.putAction("layout", (Action)layout);
        this.setSize(500, 500);
        this.pan(250.0, 250.0);
        this.setHighQuality(true);
        this.addControlListener((Control)new AggregateDragControl());
        this.addControlListener((Control)new ZoomControl());
        this.addControlListener((Control)new PanControl());
        this.m_vis.run("layout");
    }

    private void initDataGroups() {
        Graph g = new Graph();
        int i = 0;
        while (i < 3) {
            Node n1 = g.addNode();
            Node n2 = g.addNode();
            Node n3 = g.addNode();
            g.addEdge(n1, n2);
            g.addEdge(n1, n3);
            g.addEdge(n2, n3);
            ++i;
        }
        g.addEdge(0, 3);
        g.addEdge(3, 6);
        g.addEdge(6, 0);
        VisualGraph vg = this.m_vis.addGraph(GRAPH, g);
        this.m_vis.setInteractive(EDGES, null, false);
        this.m_vis.setValue(NODES, null, VisualItem.SHAPE, (Object)new Integer(1));
        AggregateTable at = this.m_vis.addAggregates(AGGR);
        at.addColumn(VisualItem.POLYGON, float[].class);
        at.addColumn("id", Integer.TYPE);
        Iterator nodes = vg.nodes();
        int i2 = 0;
        while (i2 < 3) {
            AggregateItem aitem = (AggregateItem)at.addItem();
            aitem.setInt("id", i2);
            int j = 0;
            while (j < 3) {
                aitem.addItem((VisualItem)nodes.next());
                ++j;
            }
            ++i2;
        }
    }

    public static void main(String[] argv) {
        JFrame frame = AggregateDemo.demo();
        frame.setDefaultCloseOperation(3);
        frame.setVisible(true);
    }

    public static JFrame demo() {
        AggregateDemo ad = new AggregateDemo();
        JFrame frame = new JFrame("p r e f u s e  |  a g g r e g a t e d");
        frame.getContentPane().add((Component)((Object)ad));
        frame.pack();
        return frame;
    }
}

