/*
 * Decompiled with CFR 0.152.
 */
package prefuse.demos;

import java.awt.geom.Rectangle2D;
import java.util.Iterator;
import prefuse.action.layout.Layout;
import prefuse.util.GraphicsLib;
import prefuse.visual.AggregateItem;
import prefuse.visual.AggregateTable;
import prefuse.visual.VisualItem;

class AggregateLayout
extends Layout {
    private int m_margin = 5;
    private double[] m_pts;

    public AggregateLayout(String aggrGroup) {
        super(aggrGroup);
    }

    public void run(double frac) {
        AggregateTable aggr = (AggregateTable)this.m_vis.getGroup(this.m_group);
        int num = aggr.getTupleCount();
        if (num == 0) {
            return;
        }
        int maxsz = 0;
        Iterator aggrs = aggr.tuples();
        while (aggrs.hasNext()) {
            maxsz = Math.max(maxsz, 8 * ((AggregateItem)aggrs.next()).getAggregateSize());
        }
        if (this.m_pts == null || maxsz > this.m_pts.length) {
            this.m_pts = new double[maxsz];
        }
        aggrs = this.m_vis.visibleItems(this.m_group);
        while (aggrs.hasNext()) {
            AggregateItem aitem = (AggregateItem)aggrs.next();
            int idx = 0;
            if (aitem.getAggregateSize() == 0) continue;
            VisualItem item = null;
            Iterator iter = aitem.items();
            while (iter.hasNext()) {
                item = (VisualItem)iter.next();
                if (!item.isVisible()) continue;
                AggregateLayout.addPoint(this.m_pts, idx, item, this.m_margin);
                idx += 8;
            }
            if (idx == 0) continue;
            double[] nhull = GraphicsLib.convexHull((double[])this.m_pts, (int)idx);
            float[] fhull = (float[])aitem.get(VisualItem.POLYGON);
            if (fhull == null || fhull.length < nhull.length) {
                fhull = new float[nhull.length];
            } else if (fhull.length > nhull.length) {
                fhull[nhull.length] = Float.NaN;
            }
            int j = 0;
            while (j < nhull.length) {
                fhull[j] = (float)nhull[j];
                ++j;
            }
            aitem.set(VisualItem.POLYGON, (Object)fhull);
            aitem.setValidated(false);
        }
    }

    private static void addPoint(double[] pts, int idx, VisualItem item, int growth) {
        Rectangle2D b = item.getBounds();
        double minX = b.getMinX() - (double)growth;
        double minY = b.getMinY() - (double)growth;
        double maxX = b.getMaxX() + (double)growth;
        double maxY = b.getMaxY() + (double)growth;
        pts[idx] = minX;
        pts[idx + 1] = minY;
        pts[idx + 2] = minX;
        pts[idx + 3] = maxY;
        pts[idx + 4] = maxX;
        pts[idx + 5] = minY;
        pts[idx + 6] = maxX;
        pts[idx + 7] = maxY;
    }
}

