/*
 * Decompiled with CFR 0.152.
 */
package prefuse.demos;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.Rectangle2D;
import java.text.NumberFormat;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JFrame;
import javax.swing.JPanel;
import prefuse.Display;
import prefuse.Visualization;
import prefuse.action.Action;
import prefuse.action.ActionList;
import prefuse.action.GroupAction;
import prefuse.action.RepaintAction;
import prefuse.action.assignment.ColorAction;
import prefuse.action.assignment.DataColorAction;
import prefuse.action.assignment.DataShapeAction;
import prefuse.action.filter.VisibilityFilter;
import prefuse.action.layout.AxisLabelLayout;
import prefuse.action.layout.AxisLayout;
import prefuse.controls.Control;
import prefuse.controls.ControlAdapter;
import prefuse.controls.ToolTipControl;
import prefuse.data.Table;
import prefuse.data.event.ExpressionListener;
import prefuse.data.expression.AndPredicate;
import prefuse.data.expression.Predicate;
import prefuse.data.expression.parser.ExpressionParser;
import prefuse.data.io.DelimitedTextTableReader;
import prefuse.data.query.ListQueryBinding;
import prefuse.data.query.RangeQueryBinding;
import prefuse.data.query.SearchQueryBinding;
import prefuse.data.tuple.TupleSet;
import prefuse.render.AbstractShapeRenderer;
import prefuse.render.AxisRenderer;
import prefuse.render.Renderer;
import prefuse.render.RendererFactory;
import prefuse.render.ShapeRenderer;
import prefuse.util.ColorLib;
import prefuse.util.FontLib;
import prefuse.util.UpdateListener;
import prefuse.util.ui.JFastLabel;
import prefuse.util.ui.JRangeSlider;
import prefuse.util.ui.JSearchPanel;
import prefuse.util.ui.UILib;
import prefuse.visual.VisualItem;
import prefuse.visual.VisualTable;
import prefuse.visual.expression.VisiblePredicate;
import prefuse.visual.sort.ItemSorter;

public class Congress
extends JPanel {
    private static final String TOTAL_RECEIPTS = "Total Receipts";
    private static final String RECEIPTS = "Total Receipts";
    private String m_title = "\u00a2ongress";
    private String m_totalStr;
    private double m_totalMoney = 1.0E9;
    private int m_totalPeople = 10000;
    private JFastLabel m_total = new JFastLabel(String.valueOf(this.m_totalPeople) + " Candidates: " + this.m_totalMoney);
    private JFastLabel m_details;
    private Visualization m_vis;
    private Display m_display;
    private Rectangle2D m_dataB = new Rectangle2D.Double();
    private Rectangle2D m_xlabB = new Rectangle2D.Double();
    private Rectangle2D m_ylabB = new Rectangle2D.Double();

    public static void main(String[] args) {
        UILib.setPlatformLookAndFeel();
        JFrame f = Congress.demo();
        f.setDefaultCloseOperation(3);
        f.setVisible(true);
    }

    public static JFrame demo() {
        Table t = null;
        try {
            t = new DelimitedTextTableReader().readTable("/fec.txt");
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
        JFrame frame = new JFrame("\u00a2 o n g r e s s");
        frame.setContentPane(new Congress(t));
        frame.pack();
        return frame;
    }

    public Congress(Table t) {
        super(new BorderLayout());
        Visualization vis;
        this.m_vis = vis = new Visualization();
        String group = "by_state";
        Predicate p = (Predicate)ExpressionParser.parse((String)"[Total Receipts] >= 100000");
        VisualTable vt = vis.addTable("by_state", t, p);
        vt.addColumn("label", "CONCAT(CAP(Candidate), ' (', CAP([Party Designation]), '-', [State Code], ') ', Year, ': $', FORMAT([Total Receipts],2))");
        vt.addColumn("Senate", "District <= 0");
        vis.setRendererFactory(new RendererFactory(){
            AbstractShapeRenderer sr = new ShapeRenderer();
            Renderer arY = new AxisRenderer(1, 4);
            Renderer arX = new AxisRenderer(2, 7);

            public Renderer getRenderer(VisualItem item) {
                return item.isInGroup("ylab") ? this.arY : (item.isInGroup("xlab") ? this.arX : this.sr);
            }
        });
        RangeQueryBinding receiptsQ = new RangeQueryBinding((TupleSet)vt, "Total Receipts");
        ListQueryBinding yearsQ = new ListQueryBinding((TupleSet)vt, "Year");
        SearchQueryBinding searchQ = new SearchQueryBinding((TupleSet)vt, "Candidate");
        AndPredicate filter = new AndPredicate(searchQ.getPredicate());
        filter.add(yearsQ.getPredicate());
        filter.add(receiptsQ.getPredicate());
        AxisLayout xaxis = new AxisLayout("by_state", "State Code", 0, VisiblePredicate.TRUE);
        AxisLayout yaxis = new AxisLayout("by_state", "Total Receipts", 1, VisiblePredicate.TRUE);
        yaxis.setRangeModel(receiptsQ.getModel());
        receiptsQ.getNumberModel().setValueRange(0, 65000000, 0, 65000000);
        xaxis.setLayoutBounds(this.m_dataB);
        yaxis.setLayoutBounds(this.m_dataB);
        AxisLabelLayout ylabels = new AxisLabelLayout("ylab", yaxis, this.m_ylabB);
        NumberFormat nf = NumberFormat.getCurrencyInstance();
        nf.setMaximumFractionDigits(0);
        ylabels.setNumberFormat(nf);
        AxisLabelLayout xlabels = new AxisLabelLayout("xlab", xaxis, this.m_xlabB, 15.0);
        vis.putAction("xlabels", (Action)xlabels);
        int[] palette = new int[]{ColorLib.rgb((int)150, (int)150, (int)255), ColorLib.rgb((int)255, (int)150, (int)150), ColorLib.rgb((int)180, (int)180, (int)180)};
        DataColorAction color = new DataColorAction("by_state", "Party", 1, VisualItem.STROKECOLOR, palette);
        int[] nArray = new int[2];
        nArray[1] = 2;
        int[] shapes = nArray;
        DataShapeAction shape = new DataShapeAction("by_state", "Senate", shapes);
        Counter cntr = new Counter("by_state");
        ActionList draw = new ActionList();
        draw.add((Action)cntr);
        draw.add((Action)color);
        draw.add((Action)shape);
        draw.add((Action)xaxis);
        draw.add((Action)yaxis);
        draw.add((Action)ylabels);
        draw.add((Action)new ColorAction("by_state", VisualItem.FILLCOLOR, 0));
        draw.add((Action)new RepaintAction());
        vis.putAction("draw", (Action)draw);
        ActionList update = new ActionList();
        update.add((Action)new VisibilityFilter("by_state", (Predicate)filter));
        update.add((Action)cntr);
        update.add((Action)xaxis);
        update.add((Action)yaxis);
        update.add((Action)ylabels);
        update.add((Action)new RepaintAction());
        vis.putAction("update", (Action)update);
        UpdateListener lstnr = new UpdateListener(){

            public void update(Object src) {
                vis.run("update");
            }
        };
        filter.addExpressionListener((ExpressionListener)lstnr);
        this.m_display = new Display(vis);
        this.m_display.setItemSorter(new ItemSorter(){

            public int score(VisualItem item) {
                int score = super.score(item);
                if (item.isInGroup("by_state")) {
                    score += item.getInt("Total Receipts");
                }
                return score;
            }
        });
        this.m_display.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.m_display.setSize(700, 450);
        this.m_display.setHighQuality(true);
        this.m_display.addComponentListener((ComponentListener)new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                Congress.this.displayLayout();
            }
        });
        this.displayLayout();
        this.m_details = new JFastLabel(this.m_title);
        this.m_details.setPreferredSize(new Dimension(75, 20));
        this.m_details.setVerticalAlignment(3);
        this.m_total.setPreferredSize(new Dimension(500, 20));
        this.m_total.setHorizontalAlignment(4);
        this.m_total.setVerticalAlignment(3);
        ToolTipControl ttc = new ToolTipControl("label");
        ControlAdapter hoverc = new ControlAdapter(){

            public void itemEntered(VisualItem item, MouseEvent evt) {
                if (item.isInGroup("by_state")) {
                    Congress.this.m_total.setText(item.getString("label"));
                    item.setFillColor(item.getStrokeColor());
                    item.setStrokeColor(ColorLib.rgb((int)0, (int)0, (int)0));
                    item.getVisualization().repaint();
                }
            }

            public void itemExited(VisualItem item, MouseEvent evt) {
                if (item.isInGroup("by_state")) {
                    Congress.this.m_total.setText(Congress.this.m_totalStr);
                    item.setFillColor(item.getEndFillColor());
                    item.setStrokeColor(item.getEndStrokeColor());
                    item.getVisualization().repaint();
                }
            }
        };
        this.m_display.addControlListener((Control)ttc);
        this.m_display.addControlListener((Control)hoverc);
        this.addComponentListener((ComponentListener)lstnr);
        Box infoBox = new Box(0);
        infoBox.add(Box.createHorizontalStrut(5));
        infoBox.add((Component)this.m_details);
        infoBox.add(Box.createHorizontalGlue());
        infoBox.add(Box.createHorizontalStrut(5));
        infoBox.add((Component)this.m_total);
        infoBox.add(Box.createHorizontalStrut(5));
        JSearchPanel searcher = searchQ.createSearchPanel();
        searcher.setLabelText("Candidate: ");
        searcher.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 0));
        Box radioBox = new Box(0);
        radioBox.add(Box.createHorizontalStrut(5));
        radioBox.add((Component)searcher);
        radioBox.add(Box.createHorizontalGlue());
        radioBox.add(Box.createHorizontalStrut(5));
        radioBox.add((Component)yearsQ.createRadioGroup());
        radioBox.add(Box.createHorizontalStrut(16));
        JRangeSlider slider = receiptsQ.createVerticalRangeSlider();
        slider.setThumbColor(null);
        slider.setMinExtent(150000);
        slider.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                Congress.this.m_display.setHighQuality(false);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                Congress.this.m_display.setHighQuality(true);
                Congress.this.m_display.repaint();
            }
        });
        vis.run("draw");
        vis.run("xlabels");
        this.add((Component)infoBox, "North");
        this.add((Component)this.m_display, "Center");
        this.add((Component)slider, "East");
        this.add((Component)radioBox, "South");
        UILib.setColor((Component)this, (Color)ColorLib.getColor((int)255, (int)255, (int)255), (Color)Color.GRAY);
        slider.setForeground(Color.LIGHT_GRAY);
        UILib.setFont((Component)radioBox, (Font)FontLib.getFont((String)"Tahoma", (double)15.0));
        this.m_details.setFont(FontLib.getFont((String)"Tahoma", (double)18.0));
        this.m_total.setFont(FontLib.getFont((String)"Tahoma", (double)16.0));
    }

    public void displayLayout() {
        Insets i = this.m_display.getInsets();
        int w = this.m_display.getWidth();
        int h = this.m_display.getHeight();
        int iw = i.left + i.right;
        int ih = i.top + i.bottom;
        int aw = 85;
        int ah = 15;
        this.m_dataB.setRect(i.left, i.top, w - iw - aw, h - ih - ah);
        this.m_xlabB.setRect(i.left, h - ah - i.bottom, w - iw - aw, ah - 10);
        this.m_ylabB.setRect(i.left, i.top, w - iw, h - ih - ah);
        this.m_vis.run("update");
        this.m_vis.run("xlabels");
    }

    private class Counter
    extends GroupAction {
        public Counter(String group) {
            super(group);
        }

        public void run(double frac) {
            double total = 0.0;
            int count = 0;
            VisualItem item = null;
            Iterator items = this.m_vis.visibleItems(this.m_group);
            while (items.hasNext()) {
                item = (VisualItem)items.next();
                total += item.getDouble("Total Receipts");
                ++count;
            }
            Congress.this.m_totalMoney = total;
            Congress.this.m_totalPeople = count;
            if (count == 1) {
                Congress.this.m_totalStr = item.getString("label");
            } else {
                Congress.this.m_totalStr = String.valueOf(count) + " Candidates receiving " + NumberFormat.getCurrencyInstance().format(total);
            }
            Congress.this.m_total.setText(Congress.this.m_totalStr);
        }
    }
}

