/*
 * Decompiled with CFR 0.152.
 */
package prefuse.demos;

import java.awt.Cursor;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import prefuse.Display;
import prefuse.Visualization;
import prefuse.action.Action;
import prefuse.action.ActionList;
import prefuse.action.RepaintAction;
import prefuse.action.assignment.ColorAction;
import prefuse.action.assignment.SizeAction;
import prefuse.action.layout.RandomLayout;
import prefuse.action.layout.graph.ForceDirectedLayout;
import prefuse.activity.Activity;
import prefuse.activity.ActivityAdapter;
import prefuse.activity.ActivityListener;
import prefuse.controls.Control;
import prefuse.controls.ControlAdapter;
import prefuse.data.Schema;
import prefuse.data.Table;
import prefuse.data.Tuple;
import prefuse.data.io.DelimitedTextTableReader;
import prefuse.data.tuple.TupleSet;
import prefuse.render.DefaultRendererFactory;
import prefuse.render.LabelRenderer;
import prefuse.render.Renderer;
import prefuse.render.RendererFactory;
import prefuse.util.ColorLib;
import prefuse.util.PrefuseLib;
import prefuse.util.force.DragForce;
import prefuse.util.force.Force;
import prefuse.util.force.ForceItem;
import prefuse.util.force.ForceSimulator;
import prefuse.util.force.NBodyForce;
import prefuse.util.force.SpringForce;
import prefuse.util.ui.BrowserLauncher;
import prefuse.visual.VisualItem;
import prefuse.visual.sort.ItemSorter;

public class DataMountain
extends Display {
    private static final String ANCHORITEM = "_anchorItem";
    private static final Schema ANCHORITEM_SCHEMA = new Schema();

    static {
        ANCHORITEM_SCHEMA.addColumn(ANCHORITEM, ForceItem.class);
    }

    public DataMountain(Table t) {
        super(new Visualization());
        this.m_vis.addTable("data", t);
        LabelRenderer nodeRenderer = new LabelRenderer(null, "image");
        nodeRenderer.setTextField(null);
        nodeRenderer.setVerticalAlignment(3);
        nodeRenderer.setHorizontalPadding(0);
        nodeRenderer.setVerticalPadding(0);
        nodeRenderer.setMaxImageDimensions(100, 100);
        this.m_vis.setRendererFactory((RendererFactory)new DefaultRendererFactory((Renderer)nodeRenderer));
        ActionList init = new ActionList();
        init.add((Action)new RandomLayout());
        init.add((Action)new DataMountainSizeAction());
        this.m_vis.putAction("init", (Action)init);
        ActionList update = new ActionList();
        update.add((Action)new DataMountainSizeAction());
        update.add((Action)new ColorAction("data", VisualItem.STROKECOLOR){

            public int getColor(VisualItem item) {
                return ColorLib.rgb((int)(item.isHover() ? 255 : 0), (int)0, (int)0);
            }
        });
        update.add((Action)new RepaintAction());
        this.m_vis.putAction("update", (Action)update);
        ActionList preforce = new ActionList(1000L);
        preforce.add((Action)new DataMountainForceLayout(true));
        this.m_vis.putAction("preforce", (Action)preforce);
        final DataMountainForceLayout fl = new DataMountainForceLayout(false);
        ActivityAdapter fReset = new ActivityAdapter(){

            public void activityCancelled(Activity a) {
                fl.reset();
            }
        };
        ActionList forces = new ActionList(-1L);
        forces.add((Action)fl);
        forces.add((Action)update);
        forces.addActivityListener((ActivityListener)fReset);
        this.m_vis.putAction("forces", (Action)forces);
        this.setSize(640, 450);
        this.setDamageRedraw(false);
        this.setBorder(BorderFactory.createEmptyBorder(30, 20, 5, 20));
        this.setItemSorter(new DataMountainSorter());
        this.addControlListener((Control)new DataMountainControl());
        nodeRenderer.getImageFactory().preloadImages(this.m_vis.items(), "image");
        this.m_vis.run("init");
        this.m_vis.runAfter("preforce", "update");
        this.m_vis.run("preforce");
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame("p r e f u s e  |  d a t a m o u n t a i n");
        frame.setDefaultCloseOperation(3);
        frame.getContentPane().add(DataMountain.demo());
        frame.pack();
        frame.setVisible(true);
    }

    public static JComponent demo() {
        String datafile = "/amazon.txt";
        Table data = null;
        try {
            data = new DelimitedTextTableReader().readTable(datafile);
            data.addColumn("image", "CONCAT('/images/',id,'.01.MZZZZZZZ.jpg')");
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
        return new DataMountain(data);
    }

    public class DataMountainControl
    extends ControlAdapter {
        public static final String URL = "http://www.amazon.com/exec/obidos/tg/detail/-/";
        private VisualItem activeItem;
        private Point2D down = new Point2D.Double();
        private Point2D tmp = new Point2D.Double();
        private boolean wasFixed;
        private boolean dragged;
        private boolean repaint = false;

        public void itemEntered(VisualItem item, MouseEvent e) {
            Display d = (Display)e.getSource();
            d.setCursor(Cursor.getPredefinedCursor(12));
            d.setToolTipText(item.getString("id"));
            this.activeItem = item;
            this.wasFixed = item.isFixed();
        }

        public void itemExited(VisualItem item, MouseEvent e) {
            if (this.activeItem == item) {
                this.activeItem = null;
                item.setFixed(this.wasFixed);
            }
            Display d = (Display)e.getSource();
            d.setToolTipText(null);
            d.setCursor(Cursor.getDefaultCursor());
        }

        public void itemPressed(VisualItem item, MouseEvent e) {
            if (!SwingUtilities.isLeftMouseButton(e)) {
                return;
            }
            Visualization vis = item.getVisualization();
            vis.getFocusGroup(Visualization.FOCUS_ITEMS).setTuple((Tuple)item);
            item.setFixed(true);
            this.dragged = false;
            Display d = (Display)e.getComponent();
            this.down = d.getAbsoluteCoordinate((Point2D)e.getPoint(), this.down);
            vis.run("forces");
        }

        public void itemReleased(VisualItem item, MouseEvent e) {
            if (!SwingUtilities.isLeftMouseButton(e)) {
                return;
            }
            if (this.dragged) {
                this.activeItem = null;
                item.setFixed(this.wasFixed);
                this.dragged = false;
            }
            Visualization vis = item.getVisualization();
            vis.getFocusGroup(Visualization.FOCUS_ITEMS).clear();
            vis.cancel("forces");
        }

        public void itemClicked(VisualItem item, MouseEvent e) {
            if (!SwingUtilities.isLeftMouseButton(e)) {
                return;
            }
            if (e.getClickCount() == 2) {
                String id = item.getString("id");
                BrowserLauncher.showDocument((String)(URL + id));
            }
        }

        public void itemDragged(VisualItem item, MouseEvent e) {
            if (!SwingUtilities.isLeftMouseButton(e)) {
                return;
            }
            this.dragged = true;
            Display d = (Display)e.getComponent();
            this.tmp = d.getAbsoluteCoordinate((Point2D)e.getPoint(), this.tmp);
            double dx = this.tmp.getX() - this.down.getX();
            double dy = this.tmp.getY() - this.down.getY();
            PrefuseLib.setX((VisualItem)item, null, (double)(item.getX() + dx));
            PrefuseLib.setY((VisualItem)item, null, (double)(item.getY() + dy));
            this.down.setLocation(this.tmp);
            if (this.repaint) {
                item.getVisualization().repaint();
            }
        }
    }

    public class DataMountainForceLayout
    extends ForceDirectedLayout {
        public DataMountainForceLayout(boolean enforceBounds) {
            super("data", enforceBounds, false);
            ForceSimulator fsim = new ForceSimulator();
            fsim.addForce((Force)new NBodyForce(-0.4f, 25.0f, 0.9f));
            fsim.addForce((Force)new SpringForce(1.0E-5f, 0.0f));
            fsim.addForce((Force)new DragForce());
            this.setForceSimulator(fsim);
            this.m_nodeGroup = "data";
            this.m_edgeGroup = null;
        }

        protected float getMassValue(VisualItem n) {
            return n.isHover() ? 5.0f : 1.0f;
        }

        public void reset() {
            Iterator iter = this.m_vis.visibleItems(this.m_nodeGroup);
            while (iter.hasNext()) {
                VisualItem item = (VisualItem)iter.next();
                ForceItem aitem = (ForceItem)item.get(DataMountain.ANCHORITEM);
                if (aitem == null) continue;
                aitem.location[0] = (float)item.getEndX();
                aitem.location[1] = (float)item.getEndY();
            }
            super.reset();
        }

        protected void initSimulator(ForceSimulator fsim) {
            TupleSet t = this.m_vis.getGroup(this.m_group);
            t.addColumns(ANCHORITEM_SCHEMA);
            t.addColumns(FORCEITEM_SCHEMA);
            Iterator iter = this.m_vis.visibleItems(this.m_nodeGroup);
            while (iter.hasNext()) {
                VisualItem item = (VisualItem)iter.next();
                ForceItem fitem = (ForceItem)item.get("_forceItem");
                if (fitem == null) {
                    fitem = new ForceItem();
                    item.set("_forceItem", (Object)fitem);
                }
                fitem.location[0] = (float)item.getEndX();
                fitem.location[1] = (float)item.getEndY();
                fitem.mass = this.getMassValue(item);
                ForceItem aitem = (ForceItem)item.get(DataMountain.ANCHORITEM);
                if (aitem == null) {
                    aitem = new ForceItem();
                    item.set(DataMountain.ANCHORITEM, (Object)aitem);
                    aitem.location[0] = fitem.location[0];
                    aitem.location[1] = fitem.location[1];
                }
                fsim.addItem(fitem);
                fsim.addSpring(fitem, aitem, 0.0f);
            }
        }
    }

    public class DataMountainSizeAction
    extends SizeAction {
        public double getSize(VisualItem item) {
            double y = item.getEndY();
            return 0.2 + y / 1400.0;
        }
    }

    public static class DataMountainSorter
    extends ItemSorter {
        public int score(VisualItem item) {
            return (int)(10000.0 * item.getY());
        }
    }
}

