/*
 * Decompiled with CFR 0.152.
 */
package prefuse.demos;

import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import prefuse.Display;
import prefuse.Visualization;
import prefuse.action.Action;
import prefuse.action.ActionList;
import prefuse.action.RepaintAction;
import prefuse.action.assignment.ColorAction;
import prefuse.action.distortion.FisheyeDistortion;
import prefuse.action.layout.Layout;
import prefuse.controls.AnchorUpdateControl;
import prefuse.controls.Control;
import prefuse.controls.ControlAdapter;
import prefuse.data.Schema;
import prefuse.data.Table;
import prefuse.render.DefaultRendererFactory;
import prefuse.render.LabelRenderer;
import prefuse.render.Renderer;
import prefuse.render.RendererFactory;
import prefuse.util.ColorLib;
import prefuse.visual.VisualItem;

public class FisheyeMenu
extends Display {
    public static final String ITEMS = "items";
    public static final String LABEL = "label";
    public static final String ACTION = "action";
    protected static final Schema ITEM_SCHEMA = new Schema();
    private Table m_items = ITEM_SCHEMA.instantiate();
    private double m_maxHeight = 500.0;
    private double m_scale = 7.0;

    static {
        ITEM_SCHEMA.addColumn(LABEL, String.class);
        ITEM_SCHEMA.addColumn(ACTION, ActionListener.class);
    }

    public FisheyeMenu() {
        super(new Visualization());
        this.m_vis.addTable(ITEMS, this.m_items);
        LabelRenderer renderer = new LabelRenderer(LABEL);
        renderer.setHorizontalPadding(0);
        renderer.setVerticalPadding(1);
        renderer.setHorizontalAlignment(0);
        this.m_vis.setRendererFactory((RendererFactory)new DefaultRendererFactory((Renderer)renderer));
        this.setSize(100, 470);
        this.setHighQuality(true);
        this.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 5));
        this.addControlListener((Control)new ControlAdapter(){

            public void itemClicked(VisualItem item, MouseEvent e) {
                ActionListener al = (ActionListener)item.get(FisheyeMenu.ACTION);
                al.actionPerformed(new ActionEvent(item, e.getID(), "click", e.getWhen(), e.getModifiers()));
            }
        });
        ColorAction colors = new ColorAction(ITEMS, VisualItem.TEXTCOLOR);
        colors.setDefaultColor(ColorLib.gray((int)0));
        colors.add("hover()", ColorLib.rgb((int)255, (int)0, (int)0));
        ActionList init = new ActionList();
        init.add((Action)new VerticalLineLayout(this.m_maxHeight));
        init.add((Action)colors);
        init.add((Action)new RepaintAction());
        this.m_vis.putAction("init", (Action)init);
        ActionList distort = new ActionList();
        FisheyeDistortion feye = new FisheyeDistortion(0.0, this.m_scale);
        distort.add((Action)feye);
        distort.add((Action)colors);
        distort.add((Action)new RepaintAction());
        this.m_vis.putAction("distort", (Action)distort);
        this.addControlListener((Control)new AnchorUpdateControl((Layout)feye, "distort"));
    }

    public void addMenuItem(String name, ActionListener listener) {
        int row = this.m_items.addRow();
        this.m_items.set(row, LABEL, (Object)name);
        this.m_items.set(row, ACTION, (Object)listener);
    }

    public static final void main(String[] argv) {
        Logger.getLogger("prefuse").setLevel(Level.WARNING);
        FisheyeMenu fm = FisheyeMenu.demo();
        JFrame f = new JFrame("p r e f u s e  |  f i s h e y e");
        f.setDefaultCloseOperation(3);
        f.getContentPane().add((Component)((Object)fm));
        f.pack();
        f.setVisible(true);
    }

    public static FisheyeMenu demo() {
        FisheyeMenu fm = new FisheyeMenu();
        int i = 1;
        while (i <= 72) {
            fm.addMenuItem(String.valueOf(i), new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    System.out.println("clicked item: " + ((VisualItem)e.getSource()).get(FisheyeMenu.LABEL));
                    System.out.flush();
                }
            });
            ++i;
        }
        fm.getVisualization().run("init");
        return fm;
    }

    public class VerticalLineLayout
    extends Layout {
        private double m_maxHeight = 600.0;

        public VerticalLineLayout(double maxHeight) {
            this.m_maxHeight = maxHeight;
        }

        public void run(double frac) {
            double w = 0.0;
            double h = 0.0;
            Iterator iter = this.m_vis.items();
            while (iter.hasNext()) {
                VisualItem item = (VisualItem)iter.next();
                item.setSize(1.0);
                h += item.getBounds().getHeight();
            }
            double scale = h > this.m_maxHeight ? this.m_maxHeight / h : 1.0;
            Display d = this.m_vis.getDisplay(0);
            Insets ins = d.getInsets();
            h = ins.top;
            double y = 0.0;
            double x = ins.left;
            iter = this.m_vis.items();
            while (iter.hasNext()) {
                VisualItem item = (VisualItem)iter.next();
                item.setSize(scale);
                item.setEndSize(scale);
                Rectangle2D b = item.getBounds();
                w = Math.max(w, b.getWidth());
                double ih = b.getHeight();
                y = h + ih / 2.0;
                this.setX(item, null, x);
                this.setY(item, null, y);
                h += ih;
            }
            this.setSize(d, (int)Math.round(2.0 * FisheyeMenu.this.m_scale * w + (double)ins.left + (double)ins.right), (int)Math.round(h + (double)ins.bottom));
        }

        private void setSize(final Display d, final int width, final int height) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    d.setSize(width, height);
                }
            });
        }
    }
}

