/*
 * Decompiled with CFR 0.152.
 */
package prefuse.demos;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.Rectangle2D;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import prefuse.Display;
import prefuse.Visualization;
import prefuse.action.Action;
import prefuse.action.ActionList;
import prefuse.action.RepaintAction;
import prefuse.action.assignment.ColorAction;
import prefuse.action.filter.GraphDistanceFilter;
import prefuse.action.layout.graph.ForceDirectedLayout;
import prefuse.controls.Control;
import prefuse.controls.DragControl;
import prefuse.controls.FocusControl;
import prefuse.controls.NeighborHighlightControl;
import prefuse.controls.PanControl;
import prefuse.controls.WheelZoomControl;
import prefuse.controls.ZoomControl;
import prefuse.controls.ZoomToFitControl;
import prefuse.data.Graph;
import prefuse.data.Table;
import prefuse.data.Tuple;
import prefuse.data.event.TupleSetListener;
import prefuse.data.io.GraphMLReader;
import prefuse.data.tuple.TupleSet;
import prefuse.render.DefaultRendererFactory;
import prefuse.render.LabelRenderer;
import prefuse.render.Renderer;
import prefuse.render.RendererFactory;
import prefuse.util.ColorLib;
import prefuse.util.GraphLib;
import prefuse.util.GraphicsLib;
import prefuse.util.display.DisplayLib;
import prefuse.util.display.ItemBoundsListener;
import prefuse.util.force.ForceSimulator;
import prefuse.util.io.IOLib;
import prefuse.util.ui.JForcePanel;
import prefuse.util.ui.JValueSlider;
import prefuse.util.ui.UILib;
import prefuse.visual.VisualGraph;
import prefuse.visual.VisualItem;

public class GraphView
extends JPanel {
    private static final String graph = "graph";
    private static final String nodes = "graph.nodes";
    private static final String edges = "graph.edges";
    private Visualization m_vis = new Visualization();

    public GraphView(Graph g, String label) {
        super(new BorderLayout());
        LabelRenderer tr = new LabelRenderer();
        tr.setRoundedCorner(8, 8);
        this.m_vis.setRendererFactory((RendererFactory)new DefaultRendererFactory((Renderer)tr));
        this.setGraph(g, label);
        TupleSet focusGroup = this.m_vis.getGroup(Visualization.FOCUS_ITEMS);
        focusGroup.addTupleSetListener(new TupleSetListener(){

            public void tupleSetChanged(TupleSet ts, Tuple[] add, Tuple[] rem) {
                int i = 0;
                while (i < rem.length) {
                    ((VisualItem)rem[i]).setFixed(false);
                    ++i;
                }
                i = 0;
                while (i < add.length) {
                    ((VisualItem)add[i]).setFixed(false);
                    ((VisualItem)add[i]).setFixed(true);
                    ++i;
                }
                if (ts.getTupleCount() == 0) {
                    ts.addTuple(rem[0]);
                    ((VisualItem)rem[0]).setFixed(false);
                }
                GraphView.this.m_vis.run("draw");
            }
        });
        int hops = 30;
        final GraphDistanceFilter filter = new GraphDistanceFilter(graph, hops);
        ColorAction fill = new ColorAction(nodes, VisualItem.FILLCOLOR, ColorLib.rgb((int)200, (int)200, (int)255));
        fill.add(VisualItem.FIXED, ColorLib.rgb((int)255, (int)100, (int)100));
        fill.add(VisualItem.HIGHLIGHT, ColorLib.rgb((int)255, (int)200, (int)125));
        ActionList draw = new ActionList();
        draw.add((Action)filter);
        draw.add((Action)fill);
        draw.add((Action)new ColorAction(nodes, VisualItem.STROKECOLOR, 0));
        draw.add((Action)new ColorAction(nodes, VisualItem.TEXTCOLOR, ColorLib.rgb((int)0, (int)0, (int)0)));
        draw.add((Action)new ColorAction(edges, VisualItem.FILLCOLOR, ColorLib.gray((int)200)));
        draw.add((Action)new ColorAction(edges, VisualItem.STROKECOLOR, ColorLib.gray((int)200)));
        ActionList animate = new ActionList(-1L);
        animate.add((Action)new ForceDirectedLayout(graph));
        animate.add((Action)fill);
        animate.add((Action)new RepaintAction());
        this.m_vis.putAction("draw", (Action)draw);
        this.m_vis.putAction("layout", (Action)animate);
        this.m_vis.runAfter("draw", "layout");
        Display display = new Display(this.m_vis);
        display.setSize(700, 700);
        display.pan(350.0, 350.0);
        display.setForeground(Color.GRAY);
        display.setBackground(Color.WHITE);
        display.addControlListener((Control)new FocusControl(1));
        display.addControlListener((Control)new DragControl());
        display.addControlListener((Control)new PanControl());
        display.addControlListener((Control)new ZoomControl());
        display.addControlListener((Control)new WheelZoomControl());
        display.addControlListener((Control)new ZoomToFitControl());
        display.addControlListener((Control)new NeighborHighlightControl());
        display.setForeground(Color.GRAY);
        display.setBackground(Color.WHITE);
        ForceSimulator fsim = ((ForceDirectedLayout)animate.get(0)).getForceSimulator();
        JForcePanel fpanel = new JForcePanel(fsim);
        final JValueSlider slider = new JValueSlider("Distance", 0, hops, hops);
        slider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                filter.setDistance(slider.getValue().intValue());
                GraphView.this.m_vis.run("draw");
            }
        });
        slider.setBackground(Color.WHITE);
        slider.setPreferredSize(new Dimension(300, 30));
        slider.setMaximumSize(new Dimension(300, 30));
        Box cf = new Box(1);
        cf.add((Component)slider);
        cf.setBorder(BorderFactory.createTitledBorder("Connectivity Filter"));
        fpanel.add((Component)cf);
        fpanel.add(Box.createVerticalGlue());
        JSplitPane split = new JSplitPane();
        split.setLeftComponent((Component)display);
        split.setRightComponent((Component)fpanel);
        split.setOneTouchExpandable(true);
        split.setContinuousLayout(false);
        split.setDividerLocation(700);
        this.m_vis.run("draw");
        this.add(split);
    }

    public void setGraph(Graph g, String label) {
        DefaultRendererFactory drf = (DefaultRendererFactory)this.m_vis.getRendererFactory();
        ((LabelRenderer)drf.getDefaultRenderer()).setTextField(label);
        this.m_vis.removeGroup(graph);
        VisualGraph vg = this.m_vis.addGraph(graph, g);
        this.m_vis.setValue(edges, null, VisualItem.INTERACTIVE, (Object)Boolean.FALSE);
        VisualItem f = (VisualItem)vg.getNode(0);
        this.m_vis.getGroup(Visualization.FOCUS_ITEMS).setTuple((Tuple)f);
        f.setFixed(false);
    }

    public static void main(String[] args) {
        UILib.setPlatformLookAndFeel();
        String datafile = null;
        String label = "label";
        if (args.length > 1) {
            datafile = args[0];
            label = args[1];
        }
        JFrame frame = GraphView.demo(datafile, label);
        frame.setDefaultCloseOperation(3);
    }

    public static JFrame demo() {
        return GraphView.demo(null, "label");
    }

    public static JFrame demo(String datafile, String label) {
        Graph g = null;
        if (datafile == null) {
            g = GraphLib.getGrid((int)15, (int)15);
            label = "label";
        } else {
            try {
                g = new GraphMLReader().readGraph(datafile);
            }
            catch (Exception e) {
                e.printStackTrace();
                System.exit(1);
            }
        }
        return GraphView.demo(g, label);
    }

    public static JFrame demo(Graph g, String label) {
        GraphView view = new GraphView(g, label);
        JMenu dataMenu = new JMenu("Data");
        dataMenu.add(new OpenGraphAction(view));
        dataMenu.add(new GraphMenuAction("Grid", "ctrl 1", view){

            @Override
            protected Graph getGraph() {
                return GraphLib.getGrid((int)15, (int)15);
            }
        });
        dataMenu.add(new GraphMenuAction("Clique", "ctrl 2", view){

            @Override
            protected Graph getGraph() {
                return GraphLib.getClique((int)10);
            }
        });
        dataMenu.add(new GraphMenuAction("Honeycomb", "ctrl 3", view){

            @Override
            protected Graph getGraph() {
                return GraphLib.getHoneycomb((int)5);
            }
        });
        dataMenu.add(new GraphMenuAction("Balanced Tree", "ctrl 4", view){

            @Override
            protected Graph getGraph() {
                return GraphLib.getBalancedTree((int)3, (int)5);
            }
        });
        dataMenu.add(new GraphMenuAction("Diamond Tree", "ctrl 5", view){

            @Override
            protected Graph getGraph() {
                return GraphLib.getDiamondTree((int)3, (int)3, (int)3);
            }
        });
        JMenuBar menubar = new JMenuBar();
        menubar.add(dataMenu);
        JFrame frame = new JFrame("p r e f u s e  |  g r a p h v i e w");
        frame.setJMenuBar(menubar);
        frame.setContentPane(view);
        frame.pack();
        frame.setVisible(true);
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowActivated(WindowEvent e) {
                GraphView.this.m_vis.run("layout");
            }

            @Override
            public void windowDeactivated(WindowEvent e) {
                GraphView.this.m_vis.cancel("layout");
            }
        });
        return frame;
    }

    public static class FitOverviewListener
    implements ItemBoundsListener {
        private Rectangle2D m_bounds = new Rectangle2D.Double();
        private Rectangle2D m_temp = new Rectangle2D.Double();
        private double m_d = 15.0;

        public void itemBoundsChanged(Display d) {
            d.getItemBounds(this.m_temp);
            GraphicsLib.expand((Rectangle2D)this.m_temp, (double)(25.0 / d.getScale()));
            double dd = this.m_d / d.getScale();
            double xd = Math.abs(this.m_temp.getMinX() - this.m_bounds.getMinX());
            double yd = Math.abs(this.m_temp.getMinY() - this.m_bounds.getMinY());
            double wd = Math.abs(this.m_temp.getWidth() - this.m_bounds.getWidth());
            double hd = Math.abs(this.m_temp.getHeight() - this.m_bounds.getHeight());
            if (xd > dd || yd > dd || wd > dd || hd > dd) {
                this.m_bounds.setFrame(this.m_temp);
                DisplayLib.fitViewToBounds((Display)d, (Rectangle2D)this.m_bounds, (long)0L);
            }
        }
    }

    public static abstract class GraphMenuAction
    extends AbstractAction {
        private GraphView m_view;

        public GraphMenuAction(String name, String accel, GraphView view) {
            this.m_view = view;
            this.putValue("Name", name);
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(accel));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.m_view.setGraph(this.getGraph(), "label");
        }

        protected abstract Graph getGraph();
    }

    public static class OpenGraphAction
    extends AbstractAction {
        private GraphView m_view;

        public OpenGraphAction(GraphView view) {
            this.m_view = view;
            this.putValue("Name", "Open File...");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke("ctrl O"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Graph g = IOLib.getGraphFile((Component)this.m_view);
            if (g == null) {
                return;
            }
            String label = OpenGraphAction.getLabel(this.m_view, g);
            if (label != null) {
                this.m_view.setGraph(g, label);
            }
        }

        public static String getLabel(Component c, Graph g) {
            Table t = g.getNodeTable();
            int cc = t.getColumnCount();
            String[] names = new String[cc];
            int i = 0;
            while (i < cc) {
                names[i] = t.getColumnName(i);
                ++i;
            }
            final String[] label = new String[1];
            while (c != null && !(c instanceof JFrame)) {
                c = c.getParent();
            }
            final JDialog dialog = new JDialog((JFrame)c, "Choose Label Field", true);
            final JButton ok = new JButton("OK");
            ok.setEnabled(false);
            ok.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    dialog.setVisible(false);
                }
            });
            JButton cancel = new JButton("Cancel");
            cancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    label[0] = null;
                    dialog.setVisible(false);
                }
            });
            final JList<String> list = new JList<String>(names);
            list.setSelectionMode(0);
            list.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    int sel = list.getSelectedIndex();
                    if (sel >= 0) {
                        ok.setEnabled(true);
                        label[0] = (String)list.getModel().getElementAt(sel);
                    } else {
                        ok.setEnabled(false);
                        label[0] = null;
                    }
                }
            });
            JScrollPane scrollList = new JScrollPane(list);
            JLabel title = new JLabel("Choose a field to use for node labels:");
            Box bbox = new Box(0);
            bbox.add(Box.createHorizontalStrut(5));
            bbox.add(Box.createHorizontalGlue());
            bbox.add(ok);
            bbox.add(Box.createHorizontalStrut(5));
            bbox.add(cancel);
            bbox.add(Box.createHorizontalStrut(5));
            JPanel panel = new JPanel(new BorderLayout());
            panel.add((Component)title, "North");
            panel.add((Component)scrollList, "Center");
            panel.add((Component)bbox, "South");
            panel.setBorder(BorderFactory.createEmptyBorder(5, 2, 2, 2));
            dialog.setContentPane(panel);
            dialog.pack();
            dialog.setLocationRelativeTo(c);
            dialog.setVisible(true);
            dialog.dispose();
            return label[0];
        }
    }
}

