/*
 * Decompiled with CFR 0.152.
 */
package prefuse.demos;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseEvent;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JFrame;
import javax.swing.JPanel;
import prefuse.Display;
import prefuse.Visualization;
import prefuse.action.Action;
import prefuse.action.ActionList;
import prefuse.action.GroupAction;
import prefuse.action.RepaintAction;
import prefuse.action.animate.ColorAnimator;
import prefuse.action.animate.PolarLocationAnimator;
import prefuse.action.animate.QualityControlAnimator;
import prefuse.action.animate.VisibilityAnimator;
import prefuse.action.assignment.ColorAction;
import prefuse.action.assignment.FontAction;
import prefuse.action.layout.CollapsedSubtreeLayout;
import prefuse.action.layout.graph.RadialTreeLayout;
import prefuse.activity.Pacer;
import prefuse.activity.SlowInSlowOutPacer;
import prefuse.controls.Control;
import prefuse.controls.ControlAdapter;
import prefuse.controls.DragControl;
import prefuse.controls.FocusControl;
import prefuse.controls.HoverActionControl;
import prefuse.controls.PanControl;
import prefuse.controls.ZoomControl;
import prefuse.controls.ZoomToFitControl;
import prefuse.data.Graph;
import prefuse.data.Node;
import prefuse.data.Table;
import prefuse.data.Tuple;
import prefuse.data.event.TupleSetListener;
import prefuse.data.expression.Predicate;
import prefuse.data.io.GraphMLReader;
import prefuse.data.query.SearchQueryBinding;
import prefuse.data.search.PrefixSearchTupleSet;
import prefuse.data.search.SearchTupleSet;
import prefuse.data.tuple.DefaultTupleSet;
import prefuse.data.tuple.TupleSet;
import prefuse.render.DefaultRendererFactory;
import prefuse.render.EdgeRenderer;
import prefuse.render.LabelRenderer;
import prefuse.render.Renderer;
import prefuse.render.RendererFactory;
import prefuse.util.ColorLib;
import prefuse.util.FontLib;
import prefuse.util.ui.JFastLabel;
import prefuse.util.ui.JSearchPanel;
import prefuse.util.ui.UILib;
import prefuse.visual.VisualItem;
import prefuse.visual.expression.InGroupPredicate;
import prefuse.visual.sort.ItemSorter;
import prefuse.visual.sort.TreeDepthItemSorter;

public class RadialGraphView
extends Display {
    public static final String DATA_FILE = "/socialnet.xml";
    private static final String tree = "tree";
    private static final String treeNodes = "tree.nodes";
    private static final String treeEdges = "tree.edges";
    private static final String linear = "linear";
    private LabelRenderer m_nodeRenderer;
    private EdgeRenderer m_edgeRenderer;
    private String m_label = "label";

    public RadialGraphView(Graph g, String label) {
        super(new Visualization());
        this.m_label = label;
        this.m_vis.add(tree, (TupleSet)g);
        this.m_vis.setInteractive(treeEdges, null, false);
        this.m_nodeRenderer = new LabelRenderer(this.m_label);
        this.m_nodeRenderer.setRenderType(2);
        this.m_nodeRenderer.setHorizontalAlignment(2);
        this.m_nodeRenderer.setRoundedCorner(8, 8);
        this.m_edgeRenderer = new EdgeRenderer();
        DefaultRendererFactory rf = new DefaultRendererFactory((Renderer)this.m_nodeRenderer);
        rf.add((Predicate)new InGroupPredicate(treeEdges), (Renderer)this.m_edgeRenderer);
        this.m_vis.setRendererFactory((RendererFactory)rf);
        NodeColorAction nodeColor = new NodeColorAction(treeNodes);
        TextColorAction textColor = new TextColorAction(treeNodes);
        this.m_vis.putAction("textColor", (Action)textColor);
        ColorAction edgeColor = new ColorAction(treeEdges, VisualItem.STROKECOLOR, ColorLib.rgb((int)200, (int)200, (int)200));
        FontAction fonts = new FontAction(treeNodes, FontLib.getFont((String)"Tahoma", (double)10.0));
        fonts.add("ingroup('_focus_')", FontLib.getFont((String)"Tahoma", (double)11.0));
        ActionList recolor = new ActionList();
        recolor.add((Action)nodeColor);
        recolor.add((Action)textColor);
        this.m_vis.putAction("recolor", (Action)recolor);
        ActionList repaint = new ActionList();
        repaint.add((Action)recolor);
        repaint.add((Action)new RepaintAction());
        this.m_vis.putAction("repaint", (Action)repaint);
        ActionList animatePaint = new ActionList(400L);
        animatePaint.add((Action)new ColorAnimator(treeNodes));
        animatePaint.add((Action)new RepaintAction());
        this.m_vis.putAction("animatePaint", (Action)animatePaint);
        RadialTreeLayout treeLayout = new RadialTreeLayout(tree);
        this.m_vis.putAction("treeLayout", (Action)treeLayout);
        CollapsedSubtreeLayout subLayout = new CollapsedSubtreeLayout(tree);
        this.m_vis.putAction("subLayout", (Action)subLayout);
        ActionList filter = new ActionList();
        filter.add((Action)new TreeRootAction(tree));
        filter.add((Action)fonts);
        filter.add((Action)treeLayout);
        filter.add((Action)subLayout);
        filter.add((Action)textColor);
        filter.add((Action)nodeColor);
        filter.add((Action)edgeColor);
        this.m_vis.putAction("filter", (Action)filter);
        ActionList animate = new ActionList(1250L);
        animate.setPacingFunction((Pacer)new SlowInSlowOutPacer());
        animate.add((Action)new QualityControlAnimator());
        animate.add((Action)new VisibilityAnimator(tree));
        animate.add((Action)new PolarLocationAnimator(treeNodes, linear));
        animate.add((Action)new ColorAnimator(treeNodes));
        animate.add((Action)new RepaintAction());
        this.m_vis.putAction("animate", (Action)animate);
        this.m_vis.alwaysRunAfter("filter", "animate");
        this.setSize(600, 600);
        this.setItemSorter((ItemSorter)new TreeDepthItemSorter());
        this.addControlListener((Control)new DragControl());
        this.addControlListener((Control)new ZoomToFitControl());
        this.addControlListener((Control)new ZoomControl());
        this.addControlListener((Control)new PanControl());
        this.addControlListener((Control)new FocusControl(1, "filter"));
        this.addControlListener((Control)new HoverActionControl("repaint"));
        this.m_vis.run("filter");
        this.m_vis.addFocusGroup(linear, (TupleSet)new DefaultTupleSet());
        this.m_vis.getGroup(Visualization.FOCUS_ITEMS).addTupleSetListener(new TupleSetListener(){

            public void tupleSetChanged(TupleSet t, Tuple[] add, Tuple[] rem) {
                TupleSet linearInterp = RadialGraphView.this.m_vis.getGroup(RadialGraphView.linear);
                if (add.length < 1) {
                    return;
                }
                linearInterp.clear();
                Node n = (Node)add[0];
                while (n != null) {
                    linearInterp.addTuple((Tuple)n);
                    n = n.getParent();
                }
            }
        });
        PrefixSearchTupleSet search = new PrefixSearchTupleSet();
        this.m_vis.addFocusGroup(Visualization.SEARCH_ITEMS, (TupleSet)search);
        search.addTupleSetListener(new TupleSetListener(){

            public void tupleSetChanged(TupleSet t, Tuple[] add, Tuple[] rem) {
                RadialGraphView.this.m_vis.cancel("animatePaint");
                RadialGraphView.this.m_vis.run("recolor");
                RadialGraphView.this.m_vis.run("animatePaint");
            }
        });
    }

    public static void main(String[] argv) {
        String infile = DATA_FILE;
        String label = "name";
        if (argv.length > 1) {
            infile = argv[0];
            label = argv[1];
        }
        UILib.setPlatformLookAndFeel();
        JFrame frame = new JFrame("p r e f u s e  |  r a d i a l g r a p h v i e w");
        frame.setDefaultCloseOperation(3);
        frame.setContentPane(RadialGraphView.demo(infile, label));
        frame.pack();
        frame.setVisible(true);
    }

    public static JPanel demo() {
        return RadialGraphView.demo(DATA_FILE, "name");
    }

    public static JPanel demo(String datafile, String label) {
        Graph g = null;
        try {
            g = new GraphMLReader().readGraph(datafile);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
        return RadialGraphView.demo(g, label);
    }

    public static JPanel demo(Graph g, final String label) {
        RadialGraphView gview = new RadialGraphView(g, label);
        Visualization vis = gview.getVisualization();
        SearchQueryBinding sq = new SearchQueryBinding((TupleSet)((Table)vis.getGroup(treeNodes)), label, (SearchTupleSet)vis.getGroup(Visualization.SEARCH_ITEMS));
        JSearchPanel search = sq.createSearchPanel();
        search.setShowResultCount(true);
        search.setBorder(BorderFactory.createEmptyBorder(5, 5, 4, 0));
        search.setFont(FontLib.getFont((String)"Tahoma", (int)0, (int)11));
        final JFastLabel title = new JFastLabel("                 ");
        title.setPreferredSize(new Dimension(350, 20));
        title.setVerticalAlignment(3);
        title.setBorder(BorderFactory.createEmptyBorder(3, 0, 0, 0));
        title.setFont(FontLib.getFont((String)"Tahoma", (int)0, (int)16));
        gview.addControlListener((Control)new ControlAdapter(){

            public void itemEntered(VisualItem item, MouseEvent e) {
                if (item.canGetString(label)) {
                    title.setText(item.getString(label));
                }
            }

            public void itemExited(VisualItem item, MouseEvent e) {
                title.setText(null);
            }
        });
        Box box = new Box(0);
        box.add(Box.createHorizontalStrut(10));
        box.add((Component)title);
        box.add(Box.createHorizontalGlue());
        box.add((Component)search);
        box.add(Box.createHorizontalStrut(3));
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)((Object)gview), "Center");
        panel.add((Component)box, "South");
        Color BACKGROUND = Color.WHITE;
        Color FOREGROUND = Color.DARK_GRAY;
        UILib.setColor((Component)panel, (Color)BACKGROUND, (Color)FOREGROUND);
        return panel;
    }

    public static class NodeColorAction
    extends ColorAction {
        public NodeColorAction(String group) {
            super(group, VisualItem.FILLCOLOR, ColorLib.rgba((int)255, (int)255, (int)255, (int)0));
            this.add("_hover", ColorLib.gray((int)220, (int)230));
            this.add("ingroup('_search_')", ColorLib.rgb((int)255, (int)190, (int)190));
            this.add("ingroup('_focus_')", ColorLib.rgb((int)198, (int)229, (int)229));
        }
    }

    public static class TextColorAction
    extends ColorAction {
        public TextColorAction(String group) {
            super(group, VisualItem.TEXTCOLOR, ColorLib.gray((int)0));
            this.add("_hover", ColorLib.rgb((int)255, (int)0, (int)0));
        }
    }

    public static class TreeRootAction
    extends GroupAction {
        public TreeRootAction(String graphGroup) {
            super(graphGroup);
        }

        public void run(double frac) {
            TupleSet focus = this.m_vis.getGroup(Visualization.FOCUS_ITEMS);
            if (focus == null || focus.getTupleCount() == 0) {
                return;
            }
            Graph g = (Graph)this.m_vis.getGroup(this.m_group);
            Node f = null;
            Iterator tuples = focus.tuples();
            while (tuples.hasNext() && !g.containsTuple((Tuple)(f = (Node)tuples.next()))) {
                f = null;
            }
            if (f == null) {
                return;
            }
            g.getSpanningTree(f);
        }
    }
}

