/*
 * Decompiled with CFR 0.152.
 */
package prefuse.demos;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JToolBar;
import prefuse.Display;
import prefuse.Visualization;
import prefuse.action.Action;
import prefuse.action.ActionList;
import prefuse.action.RepaintAction;
import prefuse.action.assignment.ColorAction;
import prefuse.action.assignment.DataShapeAction;
import prefuse.action.layout.AxisLayout;
import prefuse.controls.Control;
import prefuse.controls.ToolTipControl;
import prefuse.data.Table;
import prefuse.data.io.DelimitedTextTableReader;
import prefuse.render.DefaultRendererFactory;
import prefuse.render.Renderer;
import prefuse.render.RendererFactory;
import prefuse.render.ShapeRenderer;
import prefuse.util.ColorLib;
import prefuse.visual.VisualItem;
import prefuse.visual.expression.VisiblePredicate;

public class ScatterPlot
extends Display {
    private static final String group = "data";
    private ShapeRenderer m_shapeR = new ShapeRenderer(2);

    public ScatterPlot(Table t, String xfield, String yfield) {
        this(t, xfield, yfield, null);
    }

    public ScatterPlot(Table t, String xfield, String yfield, String sfield) {
        super(new Visualization());
        this.m_vis.addTable(group, t);
        DefaultRendererFactory rf = new DefaultRendererFactory((Renderer)this.m_shapeR);
        this.m_vis.setRendererFactory((RendererFactory)rf);
        AxisLayout x_axis = new AxisLayout(group, xfield, 0, VisiblePredicate.TRUE);
        this.m_vis.putAction("x", (Action)x_axis);
        AxisLayout y_axis = new AxisLayout(group, yfield, 1, VisiblePredicate.TRUE);
        this.m_vis.putAction("y", (Action)y_axis);
        ColorAction color = new ColorAction(group, VisualItem.STROKECOLOR, ColorLib.rgb((int)100, (int)100, (int)255));
        this.m_vis.putAction("color", (Action)color);
        DataShapeAction shape = new DataShapeAction(group, sfield);
        this.m_vis.putAction("shape", (Action)shape);
        ActionList draw = new ActionList();
        draw.add((Action)x_axis);
        draw.add((Action)y_axis);
        if (sfield != null) {
            draw.add((Action)shape);
        }
        draw.add((Action)color);
        draw.add((Action)new RepaintAction());
        this.m_vis.putAction("draw", (Action)draw);
        this.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.setSize(700, 450);
        this.setHighQuality(true);
        ToolTipControl ttc = new ToolTipControl(new String[]{xfield, yfield});
        this.addControlListener((Control)ttc);
        this.m_vis.run("draw");
    }

    public int getPointSize() {
        return this.m_shapeR.getBaseSize();
    }

    public void setPointSize(int size) {
        this.m_shapeR.setBaseSize(size);
        this.repaint();
    }

    public static void main(String[] argv) {
        String data = "/fisher.iris.txt";
        String xfield = "SepalLength";
        String yfield = "PetalLength";
        String sfield = "Species";
        if (argv.length >= 3) {
            data = argv[0];
            xfield = argv[1];
            yfield = argv[2];
            sfield = argv.length > 3 ? argv[3] : null;
        }
        ScatterPlot sp = ScatterPlot.demo(data, xfield, yfield, sfield);
        JToolBar toolbar = ScatterPlot.getEncodingToolbar(sp, xfield, yfield, sfield);
        JFrame frame = new JFrame("p r e f u s e  |  s c a t t e r");
        frame.setDefaultCloseOperation(3);
        frame.getContentPane().add((Component)toolbar, "North");
        frame.getContentPane().add((Component)((Object)sp), "Center");
        frame.pack();
        frame.setVisible(true);
    }

    public static ScatterPlot demo(String data, String xfield, String yfield) {
        return ScatterPlot.demo(data, xfield, yfield, null);
    }

    public static ScatterPlot demo(String data, String xfield, String yfield, String sfield) {
        Table table = null;
        try {
            table = new DelimitedTextTableReader().readTable(data);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        ScatterPlot scatter = new ScatterPlot(table, xfield, yfield, sfield);
        scatter.setPointSize(10);
        return scatter;
    }

    private static JToolBar getEncodingToolbar(ScatterPlot sp, String xfield, String yfield, String sfield) {
        int spacing = 10;
        Table t = (Table)sp.getVisualization().getSourceData(group);
        String[] colnames = new String[t.getColumnCount()];
        int i = 0;
        while (i < colnames.length) {
            colnames[i] = t.getColumnName(i);
            ++i;
        }
        JToolBar toolbar = new JToolBar();
        toolbar.setLayout(new BoxLayout(toolbar, 0));
        toolbar.add(Box.createHorizontalStrut(spacing));
        final JComboBox<String> xcb = new JComboBox<String>(colnames);
        xcb.setSelectedItem(xfield);
        xcb.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Visualization vis = ScatterPlot.this.getVisualization();
                AxisLayout xaxis = (AxisLayout)vis.getAction("x");
                xaxis.setDataField((String)xcb.getSelectedItem());
                vis.run("draw");
            }
        });
        toolbar.add(new JLabel("X: "));
        toolbar.add(xcb);
        toolbar.add(Box.createHorizontalStrut(2 * spacing));
        final JComboBox<String> ycb = new JComboBox<String>(colnames);
        ycb.setSelectedItem(yfield);
        ycb.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Visualization vis = ScatterPlot.this.getVisualization();
                AxisLayout yaxis = (AxisLayout)vis.getAction("y");
                yaxis.setDataField((String)ycb.getSelectedItem());
                vis.run("draw");
            }
        });
        toolbar.add(new JLabel("Y: "));
        toolbar.add(ycb);
        toolbar.add(Box.createHorizontalStrut(2 * spacing));
        final JComboBox<String> scb = new JComboBox<String>(colnames);
        scb.setSelectedItem(sfield);
        scb.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Visualization vis = ScatterPlot.this.getVisualization();
                DataShapeAction s = (DataShapeAction)vis.getAction("shape");
                s.setDataField((String)scb.getSelectedItem());
                vis.run("draw");
            }
        });
        toolbar.add(new JLabel("Shape: "));
        toolbar.add(scb);
        toolbar.add(Box.createHorizontalStrut(spacing));
        toolbar.add(Box.createHorizontalGlue());
        return toolbar;
    }
}

