/*
 * Decompiled with CFR 0.152.
 */
package prefuse.demos;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import prefuse.Display;
import prefuse.Visualization;
import prefuse.action.Action;
import prefuse.action.ActionList;
import prefuse.action.RepaintAction;
import prefuse.action.animate.ColorAnimator;
import prefuse.action.animate.LocationAnimator;
import prefuse.action.animate.QualityControlAnimator;
import prefuse.action.animate.VisibilityAnimator;
import prefuse.action.assignment.ColorAction;
import prefuse.action.assignment.FontAction;
import prefuse.action.filter.FisheyeTreeFilter;
import prefuse.action.layout.CollapsedSubtreeLayout;
import prefuse.action.layout.graph.NodeLinkTreeLayout;
import prefuse.activity.Pacer;
import prefuse.activity.SlowInSlowOutPacer;
import prefuse.controls.Control;
import prefuse.controls.ControlAdapter;
import prefuse.controls.FocusControl;
import prefuse.controls.PanControl;
import prefuse.controls.WheelZoomControl;
import prefuse.controls.ZoomControl;
import prefuse.controls.ZoomToFitControl;
import prefuse.data.Tree;
import prefuse.data.Tuple;
import prefuse.data.event.TupleSetListener;
import prefuse.data.expression.Predicate;
import prefuse.data.io.TreeMLReader;
import prefuse.data.search.PrefixSearchTupleSet;
import prefuse.data.tuple.TupleSet;
import prefuse.render.DefaultRendererFactory;
import prefuse.render.EdgeRenderer;
import prefuse.render.LabelRenderer;
import prefuse.render.Renderer;
import prefuse.render.RendererFactory;
import prefuse.util.ColorLib;
import prefuse.util.FontLib;
import prefuse.util.ui.JFastLabel;
import prefuse.util.ui.JSearchPanel;
import prefuse.visual.VisualItem;
import prefuse.visual.expression.InGroupPredicate;
import prefuse.visual.sort.ItemSorter;
import prefuse.visual.sort.TreeDepthItemSorter;

public class TreeView
extends Display {
    public static final String TREE_CHI = "/chi-ontology.xml.gz";
    private static final String tree = "tree";
    private static final String treeNodes = "tree.nodes";
    private static final String treeEdges = "tree.edges";
    private LabelRenderer m_nodeRenderer;
    private EdgeRenderer m_edgeRenderer;
    private String m_label = "label";
    private int m_orientation = 0;

    public TreeView(Tree t, String label) {
        super(new Visualization());
        this.m_label = label;
        this.m_vis.add(tree, (TupleSet)t);
        this.m_nodeRenderer = new LabelRenderer(this.m_label);
        this.m_nodeRenderer.setRenderType(2);
        this.m_nodeRenderer.setHorizontalAlignment(0);
        this.m_nodeRenderer.setRoundedCorner(8, 8);
        this.m_edgeRenderer = new EdgeRenderer(1);
        DefaultRendererFactory rf = new DefaultRendererFactory((Renderer)this.m_nodeRenderer);
        rf.add((Predicate)new InGroupPredicate(treeEdges), (Renderer)this.m_edgeRenderer);
        this.m_vis.setRendererFactory((RendererFactory)rf);
        NodeColorAction nodeColor = new NodeColorAction(treeNodes);
        ColorAction textColor = new ColorAction(treeNodes, VisualItem.TEXTCOLOR, ColorLib.rgb((int)0, (int)0, (int)0));
        this.m_vis.putAction("textColor", (Action)textColor);
        ColorAction edgeColor = new ColorAction(treeEdges, VisualItem.STROKECOLOR, ColorLib.rgb((int)200, (int)200, (int)200));
        ActionList repaint = new ActionList();
        repaint.add((Action)nodeColor);
        repaint.add((Action)new RepaintAction());
        this.m_vis.putAction("repaint", (Action)repaint);
        ActionList fullPaint = new ActionList();
        fullPaint.add((Action)nodeColor);
        this.m_vis.putAction("fullPaint", (Action)fullPaint);
        ActionList animatePaint = new ActionList(400L);
        animatePaint.add((Action)new ColorAnimator(treeNodes));
        animatePaint.add((Action)new RepaintAction());
        this.m_vis.putAction("animatePaint", (Action)animatePaint);
        NodeLinkTreeLayout treeLayout = new NodeLinkTreeLayout(tree, this.m_orientation, 50.0, 0.0, 8.0);
        treeLayout.setLayoutAnchor((Point2D)new Point2D.Double(25.0, 300.0));
        this.m_vis.putAction("treeLayout", (Action)treeLayout);
        CollapsedSubtreeLayout subLayout = new CollapsedSubtreeLayout(tree, this.m_orientation);
        this.m_vis.putAction("subLayout", (Action)subLayout);
        AutoPanAction autoPan = new AutoPanAction();
        ActionList filter = new ActionList();
        filter.add((Action)new FisheyeTreeFilter(tree, 2));
        filter.add((Action)new FontAction(treeNodes, FontLib.getFont((String)"Tahoma", (double)16.0)));
        filter.add((Action)treeLayout);
        filter.add((Action)subLayout);
        filter.add((Action)textColor);
        filter.add((Action)nodeColor);
        filter.add((Action)edgeColor);
        this.m_vis.putAction("filter", (Action)filter);
        ActionList animate = new ActionList(1000L);
        animate.setPacingFunction((Pacer)new SlowInSlowOutPacer());
        animate.add((Action)autoPan);
        animate.add((Action)new QualityControlAnimator());
        animate.add((Action)new VisibilityAnimator(tree));
        animate.add((Action)new LocationAnimator(treeNodes));
        animate.add((Action)new ColorAnimator(treeNodes));
        animate.add((Action)new RepaintAction());
        this.m_vis.putAction("animate", (Action)animate);
        this.m_vis.alwaysRunAfter("filter", "animate");
        ActionList orient = new ActionList(2000L);
        orient.setPacingFunction((Pacer)new SlowInSlowOutPacer());
        orient.add((Action)autoPan);
        orient.add((Action)new QualityControlAnimator());
        orient.add((Action)new LocationAnimator(treeNodes));
        orient.add((Action)new RepaintAction());
        this.m_vis.putAction("orient", (Action)orient);
        this.setSize(700, 600);
        this.setItemSorter((ItemSorter)new TreeDepthItemSorter());
        this.addControlListener((Control)new ZoomToFitControl());
        this.addControlListener((Control)new ZoomControl());
        this.addControlListener((Control)new WheelZoomControl());
        this.addControlListener((Control)new PanControl());
        this.addControlListener((Control)new FocusControl(1, "filter"));
        this.registerKeyboardAction(new OrientAction(0), "left-to-right", KeyStroke.getKeyStroke("ctrl 1"), 0);
        this.registerKeyboardAction(new OrientAction(2), "top-to-bottom", KeyStroke.getKeyStroke("ctrl 2"), 0);
        this.registerKeyboardAction(new OrientAction(1), "right-to-left", KeyStroke.getKeyStroke("ctrl 3"), 0);
        this.registerKeyboardAction(new OrientAction(3), "bottom-to-top", KeyStroke.getKeyStroke("ctrl 4"), 0);
        this.setOrientation(this.m_orientation);
        this.m_vis.run("filter");
        PrefixSearchTupleSet search = new PrefixSearchTupleSet();
        this.m_vis.addFocusGroup(Visualization.SEARCH_ITEMS, (TupleSet)search);
        search.addTupleSetListener(new TupleSetListener(){

            public void tupleSetChanged(TupleSet t, Tuple[] add, Tuple[] rem) {
                TreeView.this.m_vis.cancel("animatePaint");
                TreeView.this.m_vis.run("fullPaint");
                TreeView.this.m_vis.run("animatePaint");
            }
        });
    }

    public void setOrientation(int orientation) {
        NodeLinkTreeLayout rtl = (NodeLinkTreeLayout)this.m_vis.getAction("treeLayout");
        CollapsedSubtreeLayout stl = (CollapsedSubtreeLayout)this.m_vis.getAction("subLayout");
        switch (orientation) {
            case 0: {
                this.m_nodeRenderer.setHorizontalAlignment(0);
                this.m_edgeRenderer.setHorizontalAlignment1(1);
                this.m_edgeRenderer.setHorizontalAlignment2(0);
                this.m_edgeRenderer.setVerticalAlignment1(2);
                this.m_edgeRenderer.setVerticalAlignment2(2);
                break;
            }
            case 1: {
                this.m_nodeRenderer.setHorizontalAlignment(1);
                this.m_edgeRenderer.setHorizontalAlignment1(0);
                this.m_edgeRenderer.setHorizontalAlignment2(1);
                this.m_edgeRenderer.setVerticalAlignment1(2);
                this.m_edgeRenderer.setVerticalAlignment2(2);
                break;
            }
            case 2: {
                this.m_nodeRenderer.setHorizontalAlignment(2);
                this.m_edgeRenderer.setHorizontalAlignment1(2);
                this.m_edgeRenderer.setHorizontalAlignment2(2);
                this.m_edgeRenderer.setVerticalAlignment1(3);
                this.m_edgeRenderer.setVerticalAlignment2(4);
                break;
            }
            case 3: {
                this.m_nodeRenderer.setHorizontalAlignment(2);
                this.m_edgeRenderer.setHorizontalAlignment1(2);
                this.m_edgeRenderer.setHorizontalAlignment2(2);
                this.m_edgeRenderer.setVerticalAlignment1(4);
                this.m_edgeRenderer.setVerticalAlignment2(3);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unrecognized orientation value: " + orientation);
            }
        }
        this.m_orientation = orientation;
        rtl.setOrientation(orientation);
        stl.setOrientation(orientation);
    }

    public int getOrientation() {
        return this.m_orientation;
    }

    public static void main(String[] argv) {
        String infile = "D:\\download\\javaapi\\prefuse-beta\\data\\test1.xml";
        String label = "name";
        if (argv.length > 1) {
            infile = argv[0];
            label = argv[1];
        }
        JComponent treeview = TreeView.demo(infile, label);
        JFrame frame = new JFrame("p r e f u s e  |  t r e e v i e w");
        frame.setDefaultCloseOperation(3);
        frame.setContentPane(treeview);
        frame.pack();
        frame.setVisible(true);
    }

    public static JComponent demo() {
        return TreeView.demo(TREE_CHI, "name");
    }

    public static JComponent demo(String datafile, final String label) {
        Color BACKGROUND = Color.WHITE;
        Color FOREGROUND = Color.BLACK;
        Tree t = null;
        try {
            t = (Tree)new TreeMLReader().readGraph(datafile);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
        TreeView tview = new TreeView(t, label);
        tview.setBackground(BACKGROUND);
        tview.setForeground(FOREGROUND);
        JSearchPanel search = new JSearchPanel(tview.getVisualization(), treeNodes, Visualization.SEARCH_ITEMS, label, true, true);
        search.setShowResultCount(true);
        search.setBorder(BorderFactory.createEmptyBorder(5, 5, 4, 0));
        search.setFont(FontLib.getFont((String)"Tahoma", (int)0, (int)11));
        search.setBackground(BACKGROUND);
        search.setForeground(FOREGROUND);
        final JFastLabel title = new JFastLabel("                 ");
        title.setPreferredSize(new Dimension(350, 20));
        title.setVerticalAlignment(3);
        title.setBorder(BorderFactory.createEmptyBorder(3, 0, 0, 0));
        title.setFont(FontLib.getFont((String)"Tahoma", (int)0, (int)16));
        title.setBackground(BACKGROUND);
        title.setForeground(FOREGROUND);
        tview.addControlListener((Control)new ControlAdapter(){

            public void itemEntered(VisualItem item, MouseEvent e) {
                if (item.canGetString(label)) {
                    title.setText(item.getString(label));
                }
            }

            public void itemExited(VisualItem item, MouseEvent e) {
                title.setText(null);
            }
        });
        Box box = new Box(0);
        box.add(Box.createHorizontalStrut(10));
        box.add((Component)title);
        box.add(Box.createHorizontalGlue());
        box.add((Component)search);
        box.add(Box.createHorizontalStrut(3));
        box.setBackground(BACKGROUND);
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBackground(BACKGROUND);
        panel.setForeground(FOREGROUND);
        panel.add((Component)((Object)tview), "Center");
        panel.add((Component)box, "South");
        return panel;
    }

    public class AutoPanAction
    extends Action {
        private Point2D m_start = new Point2D.Double();
        private Point2D m_end = new Point2D.Double();
        private Point2D m_cur = new Point2D.Double();
        private int m_bias = 150;

        public void run(double frac) {
            TupleSet ts = this.m_vis.getFocusGroup(Visualization.FOCUS_ITEMS);
            if (ts.getTupleCount() == 0) {
                return;
            }
            if (frac == 0.0) {
                int xbias = 0;
                int ybias = 0;
                switch (TreeView.this.m_orientation) {
                    case 0: {
                        xbias = this.m_bias;
                        break;
                    }
                    case 1: {
                        xbias = -this.m_bias;
                        break;
                    }
                    case 2: {
                        ybias = this.m_bias;
                        break;
                    }
                    case 3: {
                        ybias = -this.m_bias;
                    }
                }
                VisualItem vi = (VisualItem)ts.tuples().next();
                this.m_cur.setLocation(TreeView.this.getWidth() / 2, TreeView.this.getHeight() / 2);
                TreeView.this.getAbsoluteCoordinate(this.m_cur, this.m_start);
                this.m_end.setLocation(vi.getX() + (double)xbias, vi.getY() + (double)ybias);
            } else {
                this.m_cur.setLocation(this.m_start.getX() + frac * (this.m_end.getX() - this.m_start.getX()), this.m_start.getY() + frac * (this.m_end.getY() - this.m_start.getY()));
                TreeView.this.panToAbs(this.m_cur);
            }
        }
    }

    public static class NodeColorAction
    extends ColorAction {
        public NodeColorAction(String group) {
            super(group, VisualItem.FILLCOLOR);
        }

        public int getColor(VisualItem item) {
            if (this.m_vis.isInGroup(item, Visualization.SEARCH_ITEMS)) {
                return ColorLib.rgb((int)255, (int)190, (int)190);
            }
            if (this.m_vis.isInGroup(item, Visualization.FOCUS_ITEMS)) {
                return ColorLib.rgb((int)198, (int)229, (int)229);
            }
            if (item.getDOI() > -1.0) {
                return ColorLib.rgb((int)164, (int)193, (int)193);
            }
            return ColorLib.rgba((int)255, (int)255, (int)255, (int)0);
        }
    }

    public class OrientAction
    extends AbstractAction {
        private int orientation;

        public OrientAction(int orientation) {
            this.orientation = orientation;
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            TreeView.this.setOrientation(this.orientation);
            TreeView.this.getVisualization().cancel("orient");
            TreeView.this.getVisualization().run("treeLayout");
            TreeView.this.getVisualization().run("orient");
        }
    }
}

