/*
 * Decompiled with CFR 0.152.
 */
package prefuse.demos;

import java.awt.Component;
import java.awt.Font;
import java.awt.Shape;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import prefuse.Constants;
import prefuse.Display;
import prefuse.Visualization;
import prefuse.action.Action;
import prefuse.action.ActionList;
import prefuse.action.RepaintAction;
import prefuse.action.animate.ColorAnimator;
import prefuse.action.animate.LocationAnimator;
import prefuse.action.assignment.ColorAction;
import prefuse.action.layout.AxisLayout;
import prefuse.activity.Activity;
import prefuse.activity.ActivityAdapter;
import prefuse.activity.ActivityListener;
import prefuse.activity.Pacer;
import prefuse.activity.SlowInSlowOutPacer;
import prefuse.data.Schema;
import prefuse.data.Table;
import prefuse.data.Tuple;
import prefuse.data.event.TupleSetListener;
import prefuse.data.expression.FunctionExpression;
import prefuse.data.expression.FunctionTable;
import prefuse.data.expression.Predicate;
import prefuse.data.expression.parser.ExpressionParser;
import prefuse.data.io.DataIOException;
import prefuse.data.io.DelimitedTextTableReader;
import prefuse.data.query.SearchQueryBinding;
import prefuse.data.search.SearchTupleSet;
import prefuse.data.tuple.TupleSet;
import prefuse.render.DefaultRendererFactory;
import prefuse.render.LabelRenderer;
import prefuse.render.Renderer;
import prefuse.render.RendererFactory;
import prefuse.render.ShapeRenderer;
import prefuse.util.ColorLib;
import prefuse.util.FontLib;
import prefuse.util.PrefuseLib;
import prefuse.util.ui.JSearchPanel;
import prefuse.visual.VisualItem;
import prefuse.visual.VisualTable;

public class ZipDecode
extends Display
implements Constants {
    public static final String ZIPCODES = "/zipcode.txt";
    public static final String STATES = "/state.txt";
    private static final String DATA = "data";
    private static final String LABELS = "labels";
    private static final String FOCUS = Visualization.FOCUS_ITEMS;

    static {
        FunctionTable.addFunction((String)"STATE", StateLookupFunction.class);
    }

    public ZipDecode(Table t) {
        super(new Visualization());
        Predicate filter = (Predicate)ExpressionParser.parse((String)"state >= 1 && state <= 56 && state != 2 && state != 15");
        VisualTable vt = this.m_vis.addTable(DATA, t, filter, ZipDecode.getDataSchema());
        vt.addColumn("zipstr", "LPAD(zip,5,'0')");
        vt.addColumn("label", "CONCAT(CAP(city),', ',STATE(state),' ',zipstr)");
        Predicate loneResult = (Predicate)ExpressionParser.parse((String)"INGROUP('_search_') AND GROUPSIZE('_search_')=1 AND LENGTH(QUERY('_search_'))=5");
        this.m_vis.addDerivedTable(LABELS, DATA, loneResult, ZipDecode.getLabelSchema());
        DefaultRendererFactory rf = new DefaultRendererFactory();
        rf.setDefaultRenderer((Renderer)new ShapeRenderer(1));
        rf.add("INGROUP('labels')", (Renderer)new LabelRenderer("label"){

            public Shape getShape(VisualItem item) {
                this.setHorizontalAlignment(item.getX() > (double)(ZipDecode.this.getWidth() / 2) ? 1 : 0);
                return super.getShape(item);
            }
        });
        this.m_vis.setRendererFactory((RendererFactory)rf);
        ActionList layout = new ActionList();
        layout.add((Action)new AxisLayout(DATA, "lat", 1));
        layout.add((Action)new AxisLayout(DATA, "lon", 0));
        this.m_vis.putAction("layout", (Action)layout);
        ZipColorAction update = new ZipColorAction(FOCUS);
        this.m_vis.putAction("update", (Action)update);
        ActionList animate = new ActionList(200L);
        animate.add((Action)new ColorAnimator(FOCUS, VisualItem.FILLCOLOR));
        animate.add((Action)new ColorAnimator(LABELS, VisualItem.TEXTCOLOR));
        animate.add((Action)new RepaintAction());
        animate.addActivityListener((ActivityListener)new ActivityAdapter((Action)update){
            private final /* synthetic */ Action val$update;
            {
                this.val$update = action;
            }

            public void activityCancelled(Activity a) {
                this.val$update.run(1.0);
            }
        });
        this.m_vis.putAction("animate", (Action)animate);
        ActionList resize = new ActionList(1500L);
        resize.setPacingFunction((Pacer)new SlowInSlowOutPacer());
        resize.add((Action)new LocationAnimator(DATA));
        resize.add((Action)new LocationAnimator(LABELS));
        resize.add((Action)new RepaintAction());
        this.m_vis.putAction("resize", (Action)resize);
        this.setSize(720, 360);
        this.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.setBackground(ColorLib.getGrayscale((int)50));
        this.setFocusable(false);
        final TupleSet focus = this.m_vis.getFocusGroup(FOCUS);
        SearchQueryBinding searchQ = new SearchQueryBinding((TupleSet)vt, "zipstr");
        SearchTupleSet search = searchQ.getSearchSet();
        search.addTupleSetListener(new TupleSetListener(){

            public void tupleSetChanged(TupleSet t, Tuple[] add, Tuple[] rem) {
                ZipDecode.this.m_vis.cancel("animate");
                focus.clear();
                int i = 0;
                while (i < add.length) {
                    ((VisualItem)add[i]).setValidated(false);
                    focus.addTuple(add[i]);
                    ++i;
                }
                i = 0;
                while (i < rem.length) {
                    ((VisualItem)rem[i]).setValidated(false);
                    focus.addTuple(rem[i]);
                    ++i;
                }
                ZipDecode.this.m_vis.run("update");
                ZipDecode.this.m_vis.run("animate");
            }
        });
        this.m_vis.addFocusGroup(Visualization.SEARCH_ITEMS, (TupleSet)search);
        final JSearchPanel searcher = searchQ.createSearchPanel();
        searcher.setLabelText("zip>");
        searcher.setShowCancel(false);
        searcher.setShowBorder(false);
        searcher.setFont(FontLib.getFont((String)"Georgia", (int)0, (int)22));
        searcher.setBackground(ColorLib.getGrayscale((int)50));
        searcher.setForeground(ColorLib.getColor((int)100, (int)100, (int)75));
        this.add((Component)searcher);
        searcher.setBounds(10, this.getHeight() - 40, 120, 30);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                ZipDecode.this.m_vis.run("layout");
                ZipDecode.this.m_vis.run("update");
                ZipDecode.this.m_vis.run("resize");
                searcher.setBounds(10, ZipDecode.this.getHeight() - 40, 120, 30);
                ZipDecode.this.invalidate();
            }
        });
        this.m_vis.run("layout");
        this.m_vis.run("animate");
    }

    private static Schema getDataSchema() {
        Schema s = PrefuseLib.getVisualItemSchema();
        s.setDefault(VisualItem.INTERACTIVE, false);
        s.setDefault(VisualItem.FILLCOLOR, ColorLib.rgb((int)100, (int)100, (int)75));
        return s;
    }

    private static Schema getLabelSchema() {
        Schema s = PrefuseLib.getMinimalVisualSchema();
        s.setDefault(VisualItem.INTERACTIVE, false);
        s.addInterpolatedColumn(VisualItem.FONT, Font.class, (Object)FontLib.getFont((String)"Georgia", (double)16.0));
        s.addInterpolatedColumn(VisualItem.FILLCOLOR, Integer.TYPE);
        s.setInterpolatedDefault(VisualItem.FILLCOLOR, 0);
        s.addInterpolatedColumn(VisualItem.TEXTCOLOR, Integer.TYPE);
        s.setInterpolatedDefault(VisualItem.TEXTCOLOR, ColorLib.gray((int)255));
        s.setDefault(VisualItem.STARTTEXTCOLOR, ColorLib.gray((int)255, (int)0));
        return s;
    }

    public static void main(String[] args) {
        String datafile = ZIPCODES;
        if (args.length > 0) {
            datafile = args[0];
        }
        try {
            JFrame frame = ZipDecode.demo(datafile);
            frame.setDefaultCloseOperation(3);
            frame.setVisible(true);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    public static JFrame demo() {
        try {
            return ZipDecode.demo(ZIPCODES);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static JFrame demo(String table) throws DataIOException {
        DelimitedTextTableReader tr = new DelimitedTextTableReader();
        Table t = tr.readTable(table);
        ZipDecode zd = new ZipDecode(t);
        JFrame frame = new JFrame("p r e f u s e  |  z i p d e c o d e");
        frame.getContentPane().add((Component)((Object)zd));
        frame.pack();
        return frame;
    }

    public static class StateLookupFunction
    extends FunctionExpression {
        private static Table s_states;

        static {
            try {
                s_states = new DelimitedTextTableReader().readTable(ZipDecode.STATES);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public StateLookupFunction() {
            super(1);
        }

        public String getName() {
            return "STATE";
        }

        public Class getType(Schema s) {
            return String.class;
        }

        public Object get(Tuple t) {
            int code = s_states.index("code").get(this.param(0).getInt(t));
            return s_states.getString(code, "alpha");
        }
    }

    public static class ZipColorAction
    extends ColorAction {
        public ZipColorAction(String group) {
            super(group, VisualItem.FILLCOLOR);
        }

        public int getColor(VisualItem item) {
            if (item.isInGroup(Visualization.SEARCH_ITEMS)) {
                return ColorLib.gray((int)255);
            }
            return ColorLib.rgb((int)100, (int)100, (int)75);
        }
    }
}

