/*
 * Decompiled with CFR 0.152.
 */
package prefuse.demos.applets;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JSplitPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import prefuse.Display;
import prefuse.Visualization;
import prefuse.action.Action;
import prefuse.action.ActionList;
import prefuse.action.RepaintAction;
import prefuse.action.assignment.ColorAction;
import prefuse.action.filter.GraphDistanceFilter;
import prefuse.action.layout.graph.ForceDirectedLayout;
import prefuse.controls.Control;
import prefuse.controls.DragControl;
import prefuse.controls.FocusControl;
import prefuse.controls.NeighborHighlightControl;
import prefuse.controls.PanControl;
import prefuse.controls.WheelZoomControl;
import prefuse.controls.ZoomControl;
import prefuse.controls.ZoomToFitControl;
import prefuse.data.Graph;
import prefuse.data.Tuple;
import prefuse.data.event.TupleSetListener;
import prefuse.data.io.GraphMLReader;
import prefuse.data.tuple.TupleSet;
import prefuse.render.DefaultRendererFactory;
import prefuse.render.LabelRenderer;
import prefuse.render.Renderer;
import prefuse.render.RendererFactory;
import prefuse.util.ColorLib;
import prefuse.util.GraphLib;
import prefuse.util.PrefuseLib;
import prefuse.util.force.ForceSimulator;
import prefuse.util.ui.JForcePanel;
import prefuse.util.ui.JPrefuseApplet;
import prefuse.util.ui.JValueSlider;
import prefuse.util.ui.UILib;
import prefuse.visual.NodeItem;
import prefuse.visual.VisualGraph;
import prefuse.visual.VisualItem;

public class GraphView
extends JPrefuseApplet {
    private static final String graph = "graph";
    private static final String nodes = "graph.nodes";
    private static final String edges = "graph.edges";

    public void init() {
        UILib.setPlatformLookAndFeel();
        JComponent graphview = GraphView.demo("/socialnet.xml", "name");
        this.getContentPane().add(graphview);
    }

    public static JComponent demo(String datafile, String label) {
        Graph g = null;
        if (datafile == null) {
            g = GraphLib.getGrid((int)15, (int)15);
        } else {
            try {
                g = new GraphMLReader().readGraph(datafile);
            }
            catch (Exception e) {
                e.printStackTrace();
                System.exit(1);
            }
        }
        return GraphView.demo(g, label);
    }

    public static JComponent demo(Graph g, String label) {
        final Visualization vis = new Visualization();
        VisualGraph vg = vis.addGraph(graph, g);
        vis.setValue(edges, null, VisualItem.INTERACTIVE, (Object)Boolean.FALSE);
        TupleSet focusGroup = vis.getGroup(Visualization.FOCUS_ITEMS);
        focusGroup.addTupleSetListener(new TupleSetListener(){

            public void tupleSetChanged(TupleSet ts, Tuple[] add, Tuple[] rem) {
                int i = 0;
                while (i < rem.length) {
                    ((VisualItem)rem[i]).setFixed(false);
                    ++i;
                }
                i = 0;
                while (i < add.length) {
                    ((VisualItem)add[i]).setFixed(false);
                    ((VisualItem)add[i]).setFixed(true);
                    ++i;
                }
                vis.run("draw");
            }
        });
        LabelRenderer tr = new LabelRenderer(label);
        tr.setRoundedCorner(8, 8);
        vis.setRendererFactory((RendererFactory)new DefaultRendererFactory((Renderer)tr));
        int maxhops = 4;
        int hops = 4;
        final GraphDistanceFilter filter = new GraphDistanceFilter(graph, hops);
        ActionList draw = new ActionList();
        draw.add((Action)filter);
        draw.add((Action)new ColorAction(nodes, VisualItem.FILLCOLOR, ColorLib.rgb((int)200, (int)200, (int)255)));
        draw.add((Action)new ColorAction(nodes, VisualItem.STROKECOLOR, 0));
        draw.add((Action)new ColorAction(nodes, VisualItem.TEXTCOLOR, ColorLib.rgb((int)0, (int)0, (int)0)));
        draw.add((Action)new ColorAction(edges, VisualItem.FILLCOLOR, ColorLib.gray((int)200)));
        draw.add((Action)new ColorAction(edges, VisualItem.STROKECOLOR, ColorLib.gray((int)200)));
        ColorAction fill = new ColorAction(nodes, VisualItem.FILLCOLOR, ColorLib.rgb((int)200, (int)200, (int)255));
        fill.add("_fixed", ColorLib.rgb((int)255, (int)100, (int)100));
        fill.add("_highlight", ColorLib.rgb((int)255, (int)200, (int)125));
        ForceDirectedLayout fdl = new ForceDirectedLayout(graph);
        ForceSimulator fsim = fdl.getForceSimulator();
        fsim.getForces()[0].setParameter(0, -1.2f);
        ActionList animate = new ActionList(-1L);
        animate.add((Action)fdl);
        animate.add((Action)fill);
        animate.add((Action)new RepaintAction());
        vis.putAction("draw", (Action)draw);
        vis.putAction("layout", (Action)animate);
        vis.runAfter("draw", "layout");
        Display display = new Display(vis);
        display.setSize(500, 500);
        display.setForeground(Color.GRAY);
        display.setBackground(Color.WHITE);
        display.addControlListener((Control)new FocusControl(1));
        display.addControlListener((Control)new DragControl());
        display.addControlListener((Control)new PanControl());
        display.addControlListener((Control)new ZoomControl());
        display.addControlListener((Control)new WheelZoomControl());
        display.addControlListener((Control)new ZoomToFitControl());
        display.addControlListener((Control)new NeighborHighlightControl());
        display.setForeground(Color.GRAY);
        display.setBackground(Color.WHITE);
        JForcePanel fpanel = new JForcePanel(fsim);
        final JValueSlider slider = new JValueSlider("Distance", 0, maxhops, hops);
        slider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                filter.setDistance(slider.getValue().intValue());
                vis.run("draw");
            }
        });
        slider.setBackground(Color.WHITE);
        slider.setPreferredSize(new Dimension(300, 30));
        slider.setMaximumSize(new Dimension(300, 30));
        Box cf = new Box(1);
        cf.add((Component)slider);
        cf.setBorder(BorderFactory.createTitledBorder("Connectivity Filter"));
        fpanel.add((Component)cf);
        fpanel.add(Box.createVerticalGlue());
        JSplitPane split = new JSplitPane();
        split.setLeftComponent((Component)display);
        split.setRightComponent((Component)fpanel);
        split.setOneTouchExpandable(true);
        split.setContinuousLayout(false);
        split.setDividerLocation(530);
        split.setDividerLocation(800);
        NodeItem focus = (NodeItem)vg.getNode(0);
        PrefuseLib.setX((VisualItem)focus, null, (double)400.0);
        PrefuseLib.setY((VisualItem)focus, null, (double)250.0);
        focusGroup.setTuple((Tuple)focus);
        return split;
    }
}

