/*
 * Decompiled with CFR 0.152.
 */
package threadframe;

import bean.CheckModule;
import bean.CmdExec;
import bean.DosCmdEncode;
import bean.Helpclass;
import bean.ReadFile;
import data.Foldingdata;
import data.Projectdata;
import data.Sequencedata;
import java.io.File;
import java.util.ArrayList;
import java.util.TreeMap;
import java.util.regex.Pattern;

public class BlastProgressBar
extends Thread {
    TreeMap<String, Sequencedata> tmclone;
    ArrayList<Thread> listt;
    int selectsize;
    TreeMap<String, String> listmap;
    boolean recovery;

    public void setListt(ArrayList<Thread> listt) {
        this.listt = listt;
    }

    public BlastProgressBar(TreeMap<String, Sequencedata> tmclone, int selectsize, boolean recovery, TreeMap<String, String> listmap) {
        this.tmclone = tmclone;
        this.selectsize = selectsize;
        this.recovery = recovery;
        this.listmap = listmap;
    }

    @Override
    public void run() {
        Foldingdata foldparamenter = Projectdata.fd;
        String blastnsta = "NA";
        String blastxsta = "NA";
        int size = this.tmclone.size();
        Projectdata.plfoldingdes.setLogtxt("BLAST " + size + " distinct sequences from " + this.selectsize + " records");
        int countsq = 1;
        int tmpcounsq = 0;
        ArrayList<Sequencedata> ppnewsm = new ArrayList<Sequencedata>();
        ArrayList<String> nameblast = new ArrayList<String>();
        int loop = (int)Math.ceil((double)this.tmclone.size() / 100.0);
        if (loop < 10) {
            loop = 10;
        } else if (loop > 50) {
            loop = 50;
        }
        int allblastsize = this.tmclone.size();
        int countpp = 1;
        boolean ppblast = true;
        while (this.tmclone.size() != 0) {
            File testexist;
            String f1out;
            String f1;
            String output;
            Sequencedata data;
            boolean test;
            String filename;
            String cmd;
            String pathexc;
            if (ppblast) {
                if (countpp == loop) {
                    ppblast = false;
                } else if (this.tmclone.size() != 0) {
                    String firstkey = this.tmclone.firstKey();
                    Sequencedata data2 = this.tmclone.get(firstkey);
                    data2.loadSqtxt();
                    ppnewsm.add(data2);
                    nameblast.add(data2.getName());
                    this.tmclone.remove(firstkey);
                    ++countpp;
                    ++countsq;
                }
                if (this.tmclone.size() == 0) {
                    ppblast = false;
                }
            }
            if (ppblast) continue;
            boolean runcmd = true;
            ppblast = true;
            String filenamewrite = "allsq" + countpp;
            countpp = 0;
            Sequencedata.writeallsqfile(Projectdata.getPathSep("tmp"), filenamewrite, ppnewsm, ">");
            if (foldparamenter.isIsblastn()) {
                pathexc = CheckModule.getPathReg("python");
                cmd = String.valueOf(pathexc) + "python python" + System.getProperty("file.separator") + "main_02_sub_04_blastn_with_rfam.py  " + DosCmdEncode.premakecmdread(Projectdata.getPathSep("tmp")) + " " + DosCmdEncode.premakecmdread(Projectdata.getPathSep("tmp")) + "  " + filenamewrite + " " + foldparamenter.getBlasndb() + ".fasta " + foldparamenter.getEvalue2() + "   " + foldparamenter.getThread();
                if (!this.recovery) {
                    runcmd = false;
                    for (String name : nameblast) {
                        filename = String.valueOf(Projectdata.getPathSep("tmp")) + name + ".blastnout";
                        test = Projectdata.checkRecovery(filename, filename, this.listmap);
                        if (!test) continue;
                        runcmd = true;
                    }
                }
                if (runcmd) {
                    CmdExec.runExec(cmd, true);
                }
                for (String name : nameblast) {
                    data = new Sequencedata();
                    data.setName(name);
                    String filename2 = String.valueOf(Projectdata.getPathSep("tmp")) + data.getName() + ".blastnout";
                    if (runcmd) {
                        Projectdata.saveRecoveryandcheck(filename2, filename2);
                    }
                    if (Pattern.matches(".*keep folding.*", (output = ReadFile.readfile(filename2, "Load blastn result", "FoldingProgessBar.java")).trim())) {
                        blastnsta = "NO HIT";
                    } else {
                        blastnsta = "HIT";
                        f1 = String.valueOf(Projectdata.getPathSep("tmp")) + data.getName() + ".blastnout";
                        f1out = String.valueOf(Projectdata.outfileSep("foldingoutput")) + data.getName() + ".blastnout";
                        testexist = new File(f1);
                        if (testexist.exists()) {
                            Helpclass.copyfile(f1, f1out);
                        }
                    }
                    Projectdata.plfoldingdes.setBlastValue(data.getName(), blastnsta);
                }
            }
            if (foldparamenter.isIsblastx()) {
                pathexc = CheckModule.getPathReg("python");
                cmd = String.valueOf(pathexc) + "python python" + System.getProperty("file.separator") + "main_02_sub_03_blastx_with_uniprot.py  " + DosCmdEncode.premakecmdread(Projectdata.getPathSep("tmp")) + " " + DosCmdEncode.premakecmdread(Projectdata.getPathSep("tmp")) + "  " + filenamewrite + " " + foldparamenter.getBlasxdb() + ".fasta " + foldparamenter.getEvalue1() + "   " + foldparamenter.getThread();
                if (!this.recovery) {
                    runcmd = false;
                    for (String name : nameblast) {
                        filename = String.valueOf(Projectdata.getPathSep("tmp")) + name + ".blastxout";
                        test = Projectdata.checkRecovery(filename, filename, this.listmap);
                        if (!test) continue;
                        runcmd = true;
                    }
                }
                if (runcmd) {
                    CmdExec.runExec(cmd, true);
                }
                for (String name : nameblast) {
                    data = new Sequencedata();
                    data.setName(name);
                    String filename3 = String.valueOf(Projectdata.getPathSep("tmp")) + data.getName() + ".blastxout";
                    output = ReadFile.readfile(filename3, "Load blastx result", "FoldingProgessBar.java");
                    if (runcmd) {
                        Projectdata.saveRecoveryandcheck(filename3, filename3);
                    }
                    if (Pattern.matches(".*keep folding.*", output.trim())) {
                        blastxsta = "NO HIT";
                    } else {
                        blastxsta = "HIT";
                        f1 = String.valueOf(Projectdata.getPathSep("tmp")) + data.getName() + ".blastxout";
                        f1out = String.valueOf(Projectdata.outfileSep("foldingoutput")) + data.getName() + ".blastxout";
                        testexist = new File(f1);
                        if (testexist.exists()) {
                            Helpclass.copyfile(f1, f1out);
                        }
                    }
                    Projectdata.plfoldingdes.setBlastxValue(data.getName(), blastxsta);
                }
            }
            int status = countsq * 100 / allblastsize;
            int addzero = String.valueOf(allblastsize).length() - String.valueOf(tmpcounsq + 1).length();
            String tmpaddzero = "";
            int i = 0;
            while (i < addzero) {
                tmpaddzero = String.valueOf(tmpaddzero) + "0";
                ++i;
            }
            int addzero1 = String.valueOf(allblastsize).length() - String.valueOf(countsq + 1).length();
            String tmpaddzero1 = "";
            int i2 = 0;
            while (i2 < addzero1) {
                tmpaddzero1 = String.valueOf(tmpaddzero1) + "0";
                ++i2;
            }
            Projectdata.plfoldingdes.incStatusBlast(status);
            String msg = "Blast sequences \t" + tmpaddzero + (tmpcounsq + 1) + "     to     " + tmpaddzero1 + countsq + "\t ... done";
            tmpcounsq = countsq;
            Projectdata.plfoldingdes.setLogtxt(msg);
            ppnewsm.clear();
            nameblast.clear();
        }
        Projectdata.plfoldingdes.blastFin();
        Projectdata.plfoldingdes.setLogtxt("Fold sequences from " + this.selectsize + " records");
        for (Thread thread : this.listt) {
            thread.start();
        }
    }
}

