/*
 * Decompiled with CFR 0.152.
 */
package threadframe;

import bean.Helpclass;
import bean.ReadFile;
import bean.ZipClass;
import data.Foldingdata;
import data.Homologoutputdata;
import data.Projectdata;
import data.Sequencedata;
import frame.ExportPrefolding;
import frame.ViewFold;
import java.io.File;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JProgressBar;
import javax.swing.JTable;
import javax.swing.JTextArea;

public class ExportProgressBar
extends Thread {
    JProgressBar progressBar;
    JTable table;
    JFileChooser jf;
    JTextArea talog;
    JLabel jtsta;
    ExportPrefolding ex;

    public ExportProgressBar(JProgressBar progressBar, JTable table, JFileChooser jf, JTextArea talog, ExportPrefolding ex, JLabel jtsta) {
        this.progressBar = progressBar;
        this.table = table;
        this.jf = jf;
        this.talog = talog;
        this.ex = ex;
        this.jtsta = jtsta;
    }

    @Override
    public void run() {
        int percent = 0;
        int i = 0;
        while (i < this.table.getRowCount()) {
            if (this.table.getValueAt(i, 0) == Boolean.TRUE) {
                ++percent;
            }
            ++i;
        }
        String ftfilename = String.valueOf(Projectdata.outfileSep("prefolding")) + "foldingtrack";
        String foldingtrack = ReadFile.readfile(ftfilename, "read track folding", "viewfold.java");
        foldingtrack = foldingtrack.trim();
        String hfilename = String.valueOf(Projectdata.outfileSep("foldingoutput", foldingtrack)) + "homologdetail";
        ArrayList<Homologoutputdata> list = Projectdata.plhomologdes.loaddata(hfilename, true);
        String miRNASequence = "NA";
        String inputSequence = "NA";
        TreeMap<String, Homologoutputdata> exportdic = new TreeMap<String, Homologoutputdata>();
        for (Homologoutputdata homologoutputdata : list) {
            String key = String.valueOf(homologoutputdata.getPotential_miRNA().trim()) + "-" + homologoutputdata.getInput_sequence_name().trim() + "-" + homologoutputdata.getStrand().trim();
            exportdic.put(key, homologoutputdata);
        }
        double inc = 98.0 / (double)percent;
        ArrayList<String> prifilelist = new ArrayList<String>();
        ArrayList<String> prefilelist = new ArrayList<String>();
        ArrayList<String> prictfilelist = new ArrayList<String>();
        ArrayList<String> prectfilelist = new ArrayList<String>();
        String savepath = this.jf.getSelectedFile().getParent();
        String savefilename = this.jf.getSelectedFile().getName();
        String savefile = String.valueOf(Projectdata.getPathSep("tmp")) + savefilename;
        String savepathtmp = Projectdata.getPath("tmp");
        boolean tmp = Projectdata.isbusy;
        Projectdata.chgcurrentproject(Projectdata.projectname, "mirna", true);
        Projectdata.isbusy = tmp;
        double progressvalue = 0.0;
        this.talog.setText("Start ..\n");
        StringBuffer sq = new StringBuffer();
        StringBuffer sq1 = new StringBuffer();
        StringBuffer sb = new StringBuffer();
        TreeSet<String> sqchk = new TreeSet<String>();
        TreeSet<String> sqchk1 = new TreeSet<String>();
        Foldingdata pmdata = Foldingdata.loadparameter("prefolding", Projectdata.prefoldingname);
        sb.append(String.valueOf(pmdata.getParameterTxt()) + "\n");
        sb.append("Known mature miRNA\tInput sequence name\tInput sequence name mapping\tNumber of mismatches between miRNA and miRNA*\tNumber of bulges\tBulge size\tNumber of flanked bases\tMode\tPrecursor start\tPrecursor stop\tPrimary miRNA MFE(kcal/mol)\tPrecursor miRNA MFE(kcal/mol)\tPrecursor miRNA MFEI(kcal/mol)\tNumber of homolog mismatches\tKnown mature miRNA sequence\tPredicted miRNA sequence\n");
        int count = 1;
        int i2 = 0;
        while (i2 < this.table.getRowCount()) {
            String key = String.valueOf(this.table.getValueAt(i2, 2).toString().trim()) + "-" + this.table.getValueAt(i2, 3).toString().trim() + "-" + this.table.getValueAt(i2, 4).toString().trim();
            if (this.table.getValueAt(i2, 0) == Boolean.TRUE) {
                String pathprefold;
                String f1out;
                String ctfilepath;
                String ctoutfile;
                String ctfile;
                String f1out2;
                String path;
                String psfilepath;
                String fullname = Sequencedata.getFullname(Projectdata.sm, this.table.getValueAt(i2, 3).toString());
                if (Projectdata.prisqexp && Projectdata.sqtm.get(">" + this.table.getValueAt(i2, 3).toString()) != null) {
                    Sequencedata data = Projectdata.sqtm.get(">" + this.table.getValueAt(i2, 3).toString());
                    String sqexportname = String.valueOf(this.table.getValueAt(i2, 3).toString()) + "_" + this.table.getValueAt(i2, 4);
                    if (!sqchk.contains(sqexportname)) {
                        sq.append(">" + sqexportname + " (" + fullname + ")\n");
                        sq.append(String.valueOf(data.getexportsq()) + "\n");
                        sqchk.add(sqexportname);
                    }
                }
                if (Projectdata.prisqexp1 && exportdic.get(key) != null) {
                    Homologoutputdata homologoutputdata = (Homologoutputdata)exportdic.get(key);
                    String hitposition = homologoutputdata.getHit_position();
                    int pos1 = Integer.parseInt(hitposition.split("_")[0]) - 1;
                    int pos2 = Integer.parseInt(hitposition.split("_")[1]) - 1;
                    Sequencedata data = Projectdata.sqtm.get(">" + this.table.getValueAt(i2, 3).toString());
                    String sequences = data.getexportsq();
                    StringBuffer sbnew = new StringBuffer();
                    int j = 0;
                    while (j < sequences.length()) {
                        if (j == pos1) {
                            sbnew.append("(start)");
                            sbnew.append(sequences.charAt(j));
                        } else if (j == pos2) {
                            sbnew.append(sequences.charAt(j));
                            sbnew.append("(stop)");
                        } else {
                            sbnew.append(sequences.charAt(j));
                        }
                        ++j;
                    }
                    sequences = sbnew.toString();
                    String sqexportname = String.valueOf(this.table.getValueAt(i2, 3).toString()) + "_" + this.table.getValueAt(i2, 4);
                    if (!sqchk1.contains(sqexportname)) {
                        sq1.append(">" + sqexportname + " (" + fullname + ")\n");
                        sq1.append(String.valueOf(sequences) + "\n");
                        sqchk1.add(sqexportname);
                    }
                }
                String ctfilepath1 = String.valueOf(Projectdata.outfileSep("foldingoutput", foldingtrack)) + this.table.getValueAt(i2, 13).toString().split("#")[1].trim() + "_1.ct";
                String ctfilepath2 = String.valueOf(Projectdata.outfileSep("prefolding")) + this.table.getValueAt(i2, 13).toString().split("#")[1].trim() + "_1.ct";
                String line = String.valueOf(this.table.getValueAt(i2, 2).toString()) + "\t" + fullname + "\t" + this.table.getValueAt(i2, 3).toString() + "\t" + this.table.getValueAt(i2, 5).toString() + "\t" + this.table.getValueAt(i2, 6).toString() + "\t" + this.table.getValueAt(i2, 7).toString() + "\t" + this.table.getValueAt(i2, 8).toString() + "\t" + this.table.getValueAt(i2, 9).toString() + "\t" + this.table.getValueAt(i2, 10).toString() + "\t" + this.table.getValueAt(i2, 11).toString() + "\t" + ViewFold.getMFE(ctfilepath1).replaceAll("kcal/mol", "").trim() + "\t" + ViewFold.getMFE(ctfilepath2).replaceAll("kcal/mol", "").trim() + "\t" + this.table.getValueAt(i2, 12).toString();
                if (exportdic.get(key) != null) {
                    Homologoutputdata homologoutputdata = (Homologoutputdata)exportdic.get(key);
                    String[] tmpsequences = homologoutputdata.getSequence_alignment().split("\n");
                    miRNASequence = tmpsequences[0].trim();
                    inputSequence = tmpsequences[2].trim();
                    line = String.valueOf(line) + "\t" + homologoutputdata.getNumber_of_mismatch() + "\t" + miRNASequence + "\t" + inputSequence + "\t";
                } else {
                    line = String.valueOf(line) + "\t" + "NA" + "\t" + "NA" + "\t" + "NA" + "\t";
                }
                sb.append(String.valueOf(line) + "\n");
                String psfile = String.valueOf(this.table.getValueAt(i2, 13).toString().split("#")[1].trim()) + "_1.ps";
                if (Projectdata.pripdfexp && new File(psfilepath = String.valueOf(path = Projectdata.outfileSep("foldingoutput", foldingtrack)) + psfile).exists()) {
                    f1out2 = String.valueOf(savepathtmp) + System.getProperty("file.separator") + "fold-" + psfile;
                    if (ZipClass.fexist(psfilepath)) {
                        Helpclass.copyfile(psfilepath, f1out2);
                        prifilelist.add("fold-" + psfile);
                    }
                }
                if (Projectdata.prictexp) {
                    path = Projectdata.outfileSep("foldingoutput", foldingtrack);
                    ctfile = String.valueOf(this.table.getValueAt(i2, 13).toString().split("#")[1].trim()) + "_1.ct";
                    ctoutfile = String.valueOf(this.table.getValueAt(i2, 13).toString().split("#")[1].trim()) + "_1-fold.ct";
                    ctfilepath = String.valueOf(path) + ctfile;
                    f1out = String.valueOf(savepathtmp) + System.getProperty("file.separator") + ctoutfile;
                    if (ZipClass.fexist(ctfilepath)) {
                        Helpclass.copyfile(ctfilepath, f1out);
                        prictfilelist.add(ctoutfile);
                    }
                }
                if (Projectdata.prepdfexp1 && new File(psfilepath = String.valueOf((pathprefold = Projectdata.outfileSep("prefolding")).trim()) + psfile.trim()).exists()) {
                    f1out2 = String.valueOf(savepathtmp) + System.getProperty("file.separator") + "prefold-" + psfile.trim();
                    if (ZipClass.fexist(psfilepath)) {
                        Helpclass.copyfile(psfilepath, f1out2);
                        prefilelist.add("prefold-" + psfile.trim());
                    }
                }
                if (Projectdata.prictexp1) {
                    path = Projectdata.outfileSep("prefolding");
                    ctfile = String.valueOf(this.table.getValueAt(i2, 13).toString().split("#")[1].trim()) + "_1.ct";
                    ctoutfile = String.valueOf(this.table.getValueAt(i2, 13).toString().split("#")[1].trim()) + "_1-prefold.ct";
                    ctfilepath = String.valueOf(path) + ctfile;
                    f1out = String.valueOf(savepathtmp) + System.getProperty("file.separator") + ctoutfile;
                    if (ZipClass.fexist(ctfilepath)) {
                        Helpclass.copyfile(ctfilepath, f1out);
                        prectfilelist.add(ctoutfile);
                    }
                }
                ArrayList<String> msgs = new ArrayList<String>();
                msgs.add("Summary");
                if (Projectdata.prisqexp) {
                    msgs.add("Sequences");
                }
                if (Projectdata.pripdfexp || Projectdata.prepdfexp1) {
                    msgs.add("pdf file");
                }
                if (Projectdata.prictexp || Projectdata.prictexp1) {
                    msgs.add("ct file");
                }
                String msg = "[";
                for (String string : msgs) {
                    msg = String.valueOf(msg) + " " + string + ",";
                }
                msg = msg.substring(0, msg.length() - 1);
                msg = String.valueOf(msg) + " ]";
                this.progressBar.setValue((int)(progressvalue += inc));
                this.talog.setText(String.valueOf(this.talog.getText()) + "Export " + msg + " sequence " + count + "\tdone\n");
                ++count;
                String msgsta = String.valueOf((int)progressvalue) + " %";
                this.ex.setsta(msgsta);
            }
            ++i2;
        }
        boolean exprt = true;
        try {
            File f = new File(savefile);
            PrintWriter pw = new PrintWriter(f);
            pw.println(sb.toString().trim());
            pw.close();
            String sqname = String.valueOf(savefilename) + "-" + "input_sequence.fasta";
            if (Projectdata.prisqexp) {
                String sqsavefile = String.valueOf(savepathtmp) + System.getProperty("file.separator") + sqname;
                File sqf = new File(sqsavefile);
                PrintWriter pwsq = new PrintWriter(sqf);
                pwsq.println(sq.toString());
                pwsq.close();
            }
            String sqname1 = String.valueOf(savefilename) + "-" + "input_sequence_with_start_and_stop.fasta";
            if (Projectdata.prisqexp1) {
                String sqsavefile = String.valueOf(savepathtmp) + System.getProperty("file.separator") + sqname1;
                File sqf = new File(sqsavefile);
                PrintWriter pwsq = new PrintWriter(sqf);
                pwsq.println(sq1.toString());
                pwsq.close();
            }
            this.talog.setText(String.valueOf(this.talog.getText()) + "Now Zip file \n");
            ZipClass.prefoldzip(savepathtmp, savepath, savefilename, sqname, sqname1, prifilelist, prefilelist, prictfilelist, prectfilelist, String.valueOf(savefilename) + ".zip");
            this.talog.setText(String.valueOf(this.talog.getText()) + "Done .. \n");
            this.progressBar.setValue(100);
            this.ex.setsta("100 %");
        }
        catch (Exception e1) {
            exprt = false;
        }
        if (exprt) {
            JOptionPane.showMessageDialog(null, "Export complete.");
        } else {
            JOptionPane.showMessageDialog(null, "Error while export", "Error", 0);
        }
        this.ex.dispose();
    }
}

