/*
 * Decompiled with CFR 0.152.
 */
package threadframe;

import bean.CheckModule;
import bean.CmdExec;
import bean.DosCmdEncode;
import bean.SaveCPList;
import data.Homologdata;
import data.Projectdata;
import data.Sequencedata;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.TreeMap;

public class HomologProgressBar
extends Thread {
    Homologdata hm;
    ArrayList<Sequencedata> sm;
    int tcount;
    int tsplit;
    int cpuselect;
    int start = 1;
    int stop = 0;
    ArrayList<String> rmlist;
    ArrayList<SaveCPList> cplist;
    TreeMap<String, String> listmap;
    boolean recovery;

    public HomologProgressBar(Homologdata hmin, ArrayList<Sequencedata> newsm, int inputtcount, int inputtsplit, int cpuselect, ArrayList<SaveCPList> cplist, boolean recovery, TreeMap<String, String> listmap) {
        this.hm = hmin;
        this.sm = newsm;
        this.tcount = inputtcount;
        this.tsplit = inputtsplit;
        this.rmlist = new ArrayList();
        this.cpuselect = cpuselect;
        this.cplist = cplist;
        this.recovery = recovery;
        this.listmap = listmap;
    }

    synchronized void incfinthread() {
        Projectdata.plhomologdes.incTmpnumthread(this.hm, this.rmlist, this.cplist);
    }

    synchronized void addlist(String path, String desname, String strname) {
        String str = String.valueOf(path) + desname + ".scan";
        String des = String.valueOf(Projectdata.getPathSep("homolog")) + strname + ".scan";
        SaveCPList cpl = new SaveCPList();
        cpl.setStr(str);
        cpl.setDes(des);
        this.cplist.add(cpl);
    }

    synchronized void appendfile(String path, String desname, String strname) {
        String str = String.valueOf(path) + desname + ".scan";
        String des = String.valueOf(Projectdata.getPathSep("homolog")) + strname + ".scan";
        try {
            String output;
            FileWriter fw = new FileWriter(des, true);
            PrintWriter pw = new PrintWriter(fw);
            FileReader fr = new FileReader(str);
            BufferedReader bfr = new BufferedReader(fr);
            while ((output = bfr.readLine()) != null) {
                pw.println(output);
            }
            pw.flush();
            pw.close();
            fw.close();
            bfr.close();
            fr.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        String sq = String.valueOf(Projectdata.sequencepath) + System.getProperty("file.separator") + desname + ".seq";
        this.rmlist.add(sq);
    }

    @Override
    public void run() {
        int count = 0;
        int count1 = 0;
        Projectdata.plhomologdes.setLogtxt("Run homolog search for " + this.sm.size() + " records");
        int all = 0;
        int bugcount = 0;
        ArrayList<Sequencedata> newsm = new ArrayList<Sequencedata>();
        for (Sequencedata data : this.sm) {
            ++this.stop;
            boolean doit = false;
            if (count1 != this.tsplit) {
                newsm.add(data);
                ++count1;
                if (this.sm.size() - this.stop == 0) {
                    doit = true;
                }
            }
            if (count1 == this.tsplit) {
                doit = true;
            }
            if (!doit) continue;
            boolean runcmd = true;
            all += newsm.size();
            ++bugcount;
            String filenamewrite = String.valueOf(Projectdata.sequencename) + "." + this.tcount + count;
            ++count;
            String chkexist = String.valueOf(Projectdata.getPathSep("tmp")) + filenamewrite + ".scan";
            if (!this.recovery) {
                runcmd = Projectdata.checkRecovery(chkexist, filenamewrite, this.listmap);
            }
            String searchmt = "S";
            if (this.hm.getSearchmethod().equals("BLAST + SCAN")) {
                searchmt = "BS";
            }
            String pathexc = CheckModule.getPathReg("python");
            String cmd = String.valueOf(pathexc) + "python python" + System.getProperty("file.separator") + "main_02_sub_02_blast_scan.py " + DosCmdEncode.premakecmdread(Projectdata.getPathSep("tmp"));
            cmd = String.valueOf(cmd) + "  " + DosCmdEncode.premakecmdread(Projectdata.getPathSep("tmp")) + "  " + filenamewrite + "  " + this.hm.getEvalue() + " " + this.hm.getWordsize() + "  " + this.hm.getMismatch() + "  " + this.cpuselect + "  " + searchmt + "   " + this.hm.getMirnaselectedlist();
            Sequencedata.writeallsqfile(Projectdata.getPathSep("tmp"), String.valueOf(filenamewrite) + ".seq", newsm);
            int indexkey = newsm.size();
            Sequencedata msgdata = newsm.get(0);
            String msg = msgdata.getName();
            msgdata = newsm.get(--indexkey);
            int startsq = this.start;
            int addzero = String.valueOf(this.sm.size()).length() - String.valueOf(startsq).length();
            String tmpaddzero = "";
            int i = 0;
            while (i < addzero) {
                tmpaddzero = String.valueOf(tmpaddzero) + "0";
                ++i;
            }
            int stopsq = this.stop;
            int addzero1 = String.valueOf(this.sm.size()).length() - String.valueOf(stopsq).length();
            String tmpaddzero1 = "";
            int i2 = 0;
            while (i2 < addzero1) {
                tmpaddzero1 = String.valueOf(tmpaddzero1) + "0";
                ++i2;
            }
            msg = "Sequences \t" + tmpaddzero + startsq + "     to     " + tmpaddzero1 + stopsq + "\t... done";
            this.start = this.stop + 1;
            try {
                if (runcmd) {
                    CmdExec.runExec(cmd, true);
                    Projectdata.saveRecoveryandcheck(chkexist, filenamewrite);
                }
                this.addlist(Projectdata.getPathSep("tmp"), filenamewrite, Projectdata.sequencename);
                Projectdata.plhomologdes.incprogress(msg);
            }
            catch (Exception exception) {
                // empty catch block
            }
            newsm.clear();
            count1 = 0;
        }
        this.incfinthread();
    }

    public static Homologdata Load(String path) {
        Homologdata data = new Homologdata();
        try {
            String output;
            File f = new File(path);
            FileReader fr = new FileReader(f);
            BufferedReader br = new BufferedReader(fr);
            while ((output = br.readLine()) != null) {
                String[] tmp = output.split(";");
                if (tmp[0].equals("evalue")) {
                    data.setEvalue(tmp[1]);
                }
                if (tmp[0].equals("mismatch")) {
                    data.setMismatch(Integer.parseInt(tmp[1]));
                }
                if (tmp[0].equals("wordsize")) {
                    data.setWordsize(Integer.parseInt(tmp[1]));
                }
                if (tmp[0].equals("searchmethod")) {
                    data.setSearchmethod(tmp[1]);
                }
                if (tmp[0].equals("noofthread")) {
                    data.setNothread(tmp[1].trim());
                }
                if (!tmp[0].equals("mirnaselecte")) continue;
                data.setMirnaselectedlist(tmp[1].trim());
            }
            br.close();
            fr.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return data;
    }

    public static void savehomologparamenter(String filename, Homologdata data) {
        BufferedWriter bufferedWriter = null;
        try {
            try {
                bufferedWriter = new BufferedWriter(new FileWriter(filename));
                String str = "evalue;" + data.getEvalue();
                bufferedWriter.write(str);
                bufferedWriter.newLine();
                str = "mismatch;" + data.getMismatch();
                bufferedWriter.write(str);
                bufferedWriter.newLine();
                str = "wordsize;" + data.getWordsize();
                bufferedWriter.write(str);
                bufferedWriter.newLine();
                str = "searchmethod;" + data.getSearchmethod();
                bufferedWriter.write(str);
                bufferedWriter.newLine();
                str = "noofthread;" + data.getNothread();
                bufferedWriter.write(str);
                bufferedWriter.newLine();
                str = "mirnaselecte;" + data.getMirnaselectedlist();
                bufferedWriter.write(str);
                bufferedWriter.newLine();
            }
            catch (FileNotFoundException ex) {
                ex.printStackTrace();
                try {
                    if (bufferedWriter != null) {
                        bufferedWriter.flush();
                        bufferedWriter.close();
                    }
                }
                catch (IOException ex2) {
                    ex2.printStackTrace();
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
                try {
                    if (bufferedWriter != null) {
                        bufferedWriter.flush();
                        bufferedWriter.close();
                    }
                }
                catch (IOException ex3) {
                    ex3.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (bufferedWriter != null) {
                    bufferedWriter.flush();
                    bufferedWriter.close();
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    public static void main(String[] args) {
    }
}

