/*
 * Decompiled with CFR 0.152.
 */
package threadframe;

import bean.CheckModule;
import bean.CmdExec;
import bean.DosCmdEncode;
import bean.SaveCPList;
import data.Homologdata;
import data.Projectdata;
import data.Sequencedata;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.TreeMap;
import java.util.regex.Pattern;

public class HomologSplitThreadProgressBar
extends Thread {
    Homologdata hm;
    int tcount;
    ArrayList<String> rmlist;
    ArrayList<SaveCPList> cplist;
    TreeMap<String, String> listmap;
    boolean recovery;

    public HomologSplitThreadProgressBar(Homologdata hmin, int tcount, ArrayList<SaveCPList> cplist, boolean recovery, TreeMap<String, String> listmap) {
        this.hm = hmin;
        this.tcount = tcount;
        this.rmlist = new ArrayList();
        this.cplist = cplist;
        this.recovery = recovery;
        this.listmap = listmap;
    }

    synchronized void incfinthread() {
        Projectdata.plhomologdes.incTmpnumthread(this.hm, this.rmlist, this.cplist);
    }

    synchronized void addlist(String path, String desname, String strname) {
        String str = String.valueOf(path) + desname + ".scan";
        String des = String.valueOf(Projectdata.getPathSep("homolog")) + strname + ".scan";
        SaveCPList cpl = new SaveCPList();
        cpl.setStr(str);
        cpl.setDes(des);
        if (!this.cplist.contains(cpl)) {
            this.cplist.add(cpl);
        }
    }

    synchronized void appendfile(String path, String desname, String strname) {
        String str = String.valueOf(path) + desname + ".scan";
        String des = String.valueOf(Projectdata.getPathSep("homolog")) + strname + ".scan";
        try {
            String output;
            FileWriter fw = new FileWriter(des, true);
            PrintWriter pw = new PrintWriter(fw);
            FileReader fr = new FileReader(str);
            BufferedReader bfr = new BufferedReader(fr);
            while ((output = bfr.readLine()) != null) {
                pw.println(output);
                if (output.split("\t").length != 6) continue;
                String cmp = output.split("\t")[0].trim();
                String cmp1 = output.split("\t")[1].trim();
                if (Pattern.matches(".*-.*", cmp) || !Pattern.matches(".*input_sequence.*", cmp1)) continue;
                System.out.println(output);
            }
            pw.flush();
            pw.close();
            fw.close();
            bfr.close();
            fr.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        String sq = String.valueOf(Projectdata.sequencepath) + System.getProperty("file.separator") + desname + ".seq";
        this.rmlist.add(sq);
    }

    @Override
    public void run() {
        Sequencedata data;
        int count = 0;
        while ((data = Projectdata.plhomologdes.getSq()) != null) {
            boolean runcmd = true;
            ArrayList<Sequencedata> newsm = new ArrayList<Sequencedata>();
            newsm.add(data);
            String filenamewrite = String.valueOf(Projectdata.sequencename) + "." + data.getSaveName();
            ++count;
            String chkexist = String.valueOf(Projectdata.getPathSep("tmp")) + filenamewrite + ".scan";
            if (!this.recovery) {
                runcmd = Projectdata.checkRecovery(chkexist, filenamewrite, this.listmap);
            }
            String searchmt = "S";
            String pathexc = CheckModule.getPathReg("python");
            String cmd = String.valueOf(pathexc) + "python python" + System.getProperty("file.separator") + "main_02_sub_02_blast_scan.py " + DosCmdEncode.premakecmdread(Projectdata.getPathSep("tmp"));
            cmd = String.valueOf(cmd) + "  " + DosCmdEncode.premakecmdread(Projectdata.getPathSep("tmp")) + "  " + filenamewrite + "  " + this.hm.getEvalue() + " " + this.hm.getWordsize() + "  " + this.hm.getMismatch() + "  2  " + searchmt + " " + this.hm.getMirnaselectedlist();
            Sequencedata.writeallsqfile(Projectdata.getPathSep("tmp"), String.valueOf(filenamewrite) + ".seq", newsm);
            int indexkey = newsm.size();
            Sequencedata msgdata = newsm.get(0);
            String msg = msgdata.getName();
            msgdata = newsm.get(--indexkey);
            msg = "Sequence \t" + count + "\t done\t in Thread " + this.tcount;
            try {
                if (runcmd) {
                    CmdExec.runExec(cmd, true);
                    Projectdata.saveRecoveryandcheck(chkexist, filenamewrite);
                }
                this.addlist(Projectdata.getPathSep("tmp"), filenamewrite, Projectdata.sequencename);
                Projectdata.plhomologdes.incprogressThread(msg);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.incfinthread();
    }

    public static Homologdata Load(String path) {
        Homologdata data = new Homologdata();
        try {
            String output;
            File f = new File(path);
            FileReader fr = new FileReader(f);
            BufferedReader br = new BufferedReader(fr);
            while ((output = br.readLine()) != null) {
                String[] tmp = output.split(";");
                if (tmp[0].equals("evalue")) {
                    data.setEvalue(tmp[1]);
                }
                if (tmp[0].equals("mismatch")) {
                    data.setMismatch(Integer.parseInt(tmp[1]));
                }
                if (tmp[0].equals("wordsize")) {
                    data.setWordsize(Integer.parseInt(tmp[1]));
                }
                if (!tmp[0].equals("searchmethod")) continue;
                data.setSearchmethod(tmp[1]);
            }
            br.close();
            fr.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return data;
    }

    public static void savehomologparamenter(String filename, Homologdata data) {
        BufferedWriter bufferedWriter = null;
        try {
            try {
                bufferedWriter = new BufferedWriter(new FileWriter(filename));
                String str = "evalue;" + data.getEvalue();
                bufferedWriter.write(str);
                bufferedWriter.newLine();
                str = "mismatch;" + data.getMismatch();
                bufferedWriter.write(str);
                bufferedWriter.newLine();
                str = "wordsize;" + data.getWordsize();
                bufferedWriter.write(str);
                bufferedWriter.newLine();
                str = "searchmethod;" + data.getSearchmethod();
                bufferedWriter.write(str);
                bufferedWriter.newLine();
            }
            catch (FileNotFoundException ex) {
                ex.printStackTrace();
                try {
                    if (bufferedWriter != null) {
                        bufferedWriter.flush();
                        bufferedWriter.close();
                    }
                }
                catch (IOException ex2) {
                    ex2.printStackTrace();
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
                try {
                    if (bufferedWriter != null) {
                        bufferedWriter.flush();
                        bufferedWriter.close();
                    }
                }
                catch (IOException ex3) {
                    ex3.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (bufferedWriter != null) {
                    bufferedWriter.flush();
                    bufferedWriter.close();
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    public static void main(String[] args) {
    }
}

