/*
 * Decompiled with CFR 0.152.
 */
package threadframe;

import bean.CheckModule;
import bean.CmdExec;
import bean.DosCmdEncode;
import bean.ReadFile;
import bean.SaveCPList;
import data.Homologdata;
import data.Projectdata;
import data.RNAmap;
import data.Sequencedata;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.TreeMap;

public class ScanningProgressBar
extends Thread {
    ArrayList<String> outputs;
    Homologdata hm;
    ArrayList<RNAmap> sm;
    int tcount;
    int tsplit;
    int start = 1;
    int stop = 0;
    int cpuselect;
    ArrayList<SaveCPList> cplist;
    TreeMap<String, String> listmap;
    boolean recovery;

    public ScanningProgressBar(Homologdata hmin, ArrayList<RNAmap> newsm, int inputtcount, int inputtsplit, int cpuselect, ArrayList<SaveCPList> cplist, boolean recovery, TreeMap<String, String> listmap) {
        this.hm = hmin;
        this.sm = newsm;
        this.tcount = inputtcount;
        this.tsplit = inputtsplit;
        this.outputs = new ArrayList();
        this.cpuselect = cpuselect;
        this.cplist = cplist;
        this.recovery = recovery;
        this.listmap = listmap;
    }

    synchronized void incfinthread() {
        Projectdata.plscanningdes.incTmpnumthread(this.hm, this.cplist);
    }

    synchronized void addlist(String path, String desname, String strname) {
        String str = String.valueOf(path) + desname.trim() + ".target";
        String des = String.valueOf(Projectdata.getPathSep("scanning")) + strname.trim() + ".target";
        SaveCPList cpl = new SaveCPList();
        cpl.setStr(str);
        cpl.setDes(des);
        this.cplist.add(cpl);
    }

    synchronized void appendfile(String path, String desname, String strname) {
        String str = String.valueOf(path) + desname.trim() + ".target";
        String des = String.valueOf(Projectdata.getPathSep("scanning")) + strname.trim() + ".target";
        String xmlfile = String.valueOf(path) + System.getProperty("file.separator") + desname + "_result.xml";
        try {
            String output;
            FileWriter fw = new FileWriter(des, true);
            PrintWriter pw = new PrintWriter(fw);
            FileReader fr = new FileReader(str);
            BufferedReader bfr = new BufferedReader(fr);
            while ((output = bfr.readLine()) != null) {
                pw.println(output);
            }
            pw.flush();
            pw.close();
            fw.close();
            bfr.close();
            fr.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void run() {
        int count = 0;
        int count1 = 0;
        int all = 0;
        int bugcount = 0;
        String sqfile = String.valueOf(Projectdata.getPath("targetsequence")) + System.getProperty("file.separator") + Projectdata.targetsequencename;
        String summary = ReadFile.readfile(String.valueOf(sqfile) + ".status", "Load target sequence status", "ScanningProgressBar.java").trim();
        String[] tmps = summary.split("\n");
        String numofsq = tmps[1].split(":")[1];
        Projectdata.plscanningdes.setLogtxt("Run target scanning for " + this.sm.size() + " miRNAs on " + numofsq + " input sequences");
        ArrayList<RNAmap> newsm = new ArrayList<RNAmap>();
        for (RNAmap data : this.sm) {
            ++this.stop;
            boolean doit = false;
            if (count1 != this.tsplit) {
                newsm.add(data);
                ++count1;
                doit = false;
                if (this.sm.size() - this.stop == 0) {
                    doit = true;
                }
            }
            if (count1 == this.tsplit) {
                doit = true;
            }
            if (!doit) continue;
            boolean runcmd = true;
            ++bugcount;
            all += newsm.size();
            String filenamewrite = String.valueOf(Projectdata.targetsequencename) + "." + this.tcount + count;
            ++count;
            String chkexist = String.valueOf(Projectdata.getPathSep("tmp")) + filenamewrite + ".query";
            if (!this.recovery) {
                runcmd = Projectdata.checkRecovery(chkexist, filenamewrite, this.listmap);
            }
            String searchmt = "S";
            if (this.hm.getSearchmethod().equals("BLAST + SCAN")) {
                searchmt = "BS";
            }
            String pathexc = CheckModule.getPathReg("python");
            String cmd = String.valueOf(pathexc) + "python python" + System.getProperty("file.separator") + "main_03_sub_02_blast_scan_target.py " + DosCmdEncode.premakecmdread(Projectdata.getPathSep("targetsequence"));
            cmd = String.valueOf(cmd) + "  " + DosCmdEncode.premakecmdread(Projectdata.getPathSep("tmp")) + "  " + Projectdata.targetsequencename + "  " + filenamewrite + ".query " + " " + this.hm.getMismatch() + "  " + this.cpuselect + "  " + searchmt;
            Sequencedata.writealltargetsqfile(Projectdata.getPathSep("tmp"), String.valueOf(filenamewrite) + ".query", newsm);
            int indexkey = newsm.size();
            RNAmap msgdata = newsm.get(--indexkey);
            String msg = msgdata.getName();
            int startsq = this.start;
            int addzero = String.valueOf(this.sm.size()).length() - String.valueOf(startsq).length();
            String tmpaddzero = "";
            int i = 0;
            while (i < addzero) {
                tmpaddzero = String.valueOf(tmpaddzero) + "0";
                ++i;
            }
            int stopsq = this.stop;
            int addzero1 = String.valueOf(this.sm.size()).length() - String.valueOf(stopsq).length();
            String tmpaddzero1 = "";
            int i2 = 0;
            while (i2 < addzero1) {
                tmpaddzero1 = String.valueOf(tmpaddzero1) + "0";
                ++i2;
            }
            msg = "MiRNAs \t" + tmpaddzero + startsq + "     to     " + tmpaddzero1 + stopsq + "\t... done";
            this.start = this.stop + 1;
            try {
                if (runcmd) {
                    CmdExec.runExec(cmd, true);
                    Projectdata.saveRecoveryandcheck(chkexist, filenamewrite);
                }
                this.addlist(Projectdata.getPathSep("tmp"), String.valueOf(filenamewrite) + ".query", Projectdata.targetsequencename);
                Projectdata.plscanningdes.incprogress(msg);
            }
            catch (Exception e) {
                System.out.println("Error ");
            }
            newsm.clear();
            count1 = 0;
        }
        this.incfinthread();
    }

    public static Homologdata Load(String path) {
        Homologdata data = new Homologdata();
        try {
            String output;
            File f = new File(path);
            FileReader fr = new FileReader(f);
            BufferedReader br = new BufferedReader(fr);
            while ((output = br.readLine()) != null) {
                String[] tmp = output.split(";");
                if (tmp[0].equals("evalue")) {
                    data.setEvalue(tmp[1]);
                }
                if (tmp[0].equals("mismatch")) {
                    data.setMismatch(Integer.parseInt(tmp[1]));
                }
                if (tmp[0].equals("wordsize")) {
                    data.setWordsize(Integer.parseInt(tmp[1]));
                }
                if (!tmp[0].equals("searchmethod")) continue;
                data.setSearchmethod(tmp[1]);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return data;
    }

    public static void savescanparamenter(String filename, Homologdata data) {
        BufferedWriter bufferedWriter = null;
        try {
            try {
                bufferedWriter = new BufferedWriter(new FileWriter(filename));
                String str = "evalue;" + data.getEvalue();
                bufferedWriter.write(str);
                bufferedWriter.newLine();
                str = "mismatch;" + data.getMismatch();
                bufferedWriter.write(str);
                bufferedWriter.newLine();
                str = "wordsize;" + data.getWordsize();
                bufferedWriter.write(str);
                bufferedWriter.newLine();
                str = "searchmethod;" + data.getSearchmethod();
                bufferedWriter.write(str);
                bufferedWriter.newLine();
            }
            catch (FileNotFoundException ex) {
                ex.printStackTrace();
                try {
                    if (bufferedWriter != null) {
                        bufferedWriter.flush();
                        bufferedWriter.close();
                    }
                }
                catch (IOException ex2) {
                    ex2.printStackTrace();
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
                try {
                    if (bufferedWriter != null) {
                        bufferedWriter.flush();
                        bufferedWriter.close();
                    }
                }
                catch (IOException ex3) {
                    ex3.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (bufferedWriter != null) {
                    bufferedWriter.flush();
                    bufferedWriter.close();
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    public static void main(String[] args) {
        System.out.println("finish");
    }
}

