/*
 * Decompiled with CFR 0.152.
 */
package threadframe;

import bean.CheckModule;
import bean.CmdExec;
import bean.DosCmdEncode;
import bean.SaveCPList;
import data.Homologdata;
import data.Projectdata;
import data.RNAmap;
import data.Sequencedata;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.TreeMap;

public class ScanningSplitThreadProgressBar
extends Thread {
    ArrayList<String> outputs;
    Homologdata hm;
    int tcount;
    ArrayList<SaveCPList> cplist;
    TreeMap<String, String> listmap;
    boolean recovery;

    public ScanningSplitThreadProgressBar(Homologdata hmin, int inputtcount, ArrayList<SaveCPList> cplist, boolean recovery, TreeMap<String, String> listmap) {
        this.hm = hmin;
        this.tcount = inputtcount;
        this.outputs = new ArrayList();
        this.cplist = cplist;
        this.recovery = recovery;
        this.listmap = listmap;
    }

    synchronized void incfinthread() {
        Projectdata.plscanningdes.incTmpnumthread(this.hm, this.cplist);
    }

    synchronized void addlist(String path, String desname, String strname) {
        String str = String.valueOf(path) + desname.trim() + ".target";
        String des = String.valueOf(Projectdata.getPathSep("scanning")) + strname.trim() + ".target";
        SaveCPList cpl = new SaveCPList();
        cpl.setStr(str);
        cpl.setDes(des);
        this.cplist.add(cpl);
    }

    synchronized void appendfile(String path, String desname, String strname) {
        String str = String.valueOf(path) + desname.trim() + ".target";
        String des = String.valueOf(Projectdata.getPathSep("scanning")) + strname.trim() + ".target";
        try {
            String output;
            FileWriter fw = new FileWriter(des, true);
            PrintWriter pw = new PrintWriter(fw);
            FileReader fr = new FileReader(str);
            BufferedReader bfr = new BufferedReader(fr);
            while ((output = bfr.readLine()) != null) {
                pw.println(output);
            }
            pw.flush();
            pw.close();
            fw.close();
            bfr.close();
            fr.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void run() {
        RNAmap data;
        int count = 0;
        int count1 = 0;
        while ((data = Projectdata.plscanningdes.getSq()) != null) {
            boolean runcmd = true;
            ArrayList<RNAmap> newsm = new ArrayList<RNAmap>();
            newsm.add(data);
            ++count1;
            String filenamewrite = String.valueOf(Projectdata.targetsequencename) + "." + data.getSaveName();
            ++count;
            String chkexist = String.valueOf(Projectdata.getPathSep("tmp")) + filenamewrite + ".query";
            if (!this.recovery) {
                runcmd = Projectdata.checkRecovery(chkexist, filenamewrite, this.listmap);
            }
            String searchmt = "S";
            String pathexc = CheckModule.getPathReg("python");
            String cmd = String.valueOf(pathexc) + "python python" + System.getProperty("file.separator") + "main_03_sub_02_blast_scan_target.py " + DosCmdEncode.premakecmdread(Projectdata.getPathSep("targetsequence"));
            cmd = String.valueOf(cmd) + "  " + DosCmdEncode.premakecmdread(Projectdata.getPathSep("tmp")) + "  " + Projectdata.targetsequencename + "  " + filenamewrite + ".query " + " " + this.hm.getMismatch() + "  2  " + searchmt;
            Sequencedata.writealltargetsqfile(Projectdata.getPathSep("tmp"), String.valueOf(filenamewrite) + ".query", newsm);
            int indexkey = newsm.size();
            RNAmap msgdata = newsm.get(--indexkey);
            String msg = msgdata.getName();
            msg = "MiRNA \t" + count1 + "\t done\t in Thread " + this.tcount;
            try {
                if (runcmd) {
                    CmdExec.runExec(cmd, true);
                    Projectdata.saveRecoveryandcheck(chkexist, filenamewrite);
                }
                this.addlist(Projectdata.getPathSep("tmp"), String.valueOf(filenamewrite) + ".query", Projectdata.targetsequencename);
                Projectdata.plscanningdes.incprogressThread(msg);
            }
            catch (Exception e) {
                System.out.println("Error ");
            }
        }
        this.incfinthread();
    }

    public static Homologdata Load(String path) {
        Homologdata data = new Homologdata();
        try {
            String output;
            File f = new File(path);
            FileReader fr = new FileReader(f);
            BufferedReader br = new BufferedReader(fr);
            while ((output = br.readLine()) != null) {
                String[] tmp = output.split(";");
                if (tmp[0].equals("evalue")) {
                    data.setEvalue(tmp[1]);
                }
                if (tmp[0].equals("mismatch")) {
                    data.setMismatch(Integer.parseInt(tmp[1]));
                }
                if (tmp[0].equals("wordsize")) {
                    data.setWordsize(Integer.parseInt(tmp[1]));
                }
                if (!tmp[0].equals("searchmethod")) continue;
                data.setSearchmethod(tmp[1]);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return data;
    }

    public static void savescanparamenter(String filename, Homologdata data) {
        BufferedWriter bufferedWriter = null;
        try {
            try {
                bufferedWriter = new BufferedWriter(new FileWriter(filename));
                String str = "evalue;" + data.getEvalue();
                bufferedWriter.write(str);
                bufferedWriter.newLine();
                str = "mismatch;" + data.getMismatch();
                bufferedWriter.write(str);
                bufferedWriter.newLine();
                str = "wordsize;" + data.getWordsize();
                bufferedWriter.write(str);
                bufferedWriter.newLine();
                str = "searchmethod;" + data.getSearchmethod();
                bufferedWriter.write(str);
                bufferedWriter.newLine();
            }
            catch (FileNotFoundException ex) {
                ex.printStackTrace();
                try {
                    if (bufferedWriter != null) {
                        bufferedWriter.flush();
                        bufferedWriter.close();
                    }
                }
                catch (IOException ex2) {
                    ex2.printStackTrace();
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
                try {
                    if (bufferedWriter != null) {
                        bufferedWriter.flush();
                        bufferedWriter.close();
                    }
                }
                catch (IOException ex3) {
                    ex3.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (bufferedWriter != null) {
                    bufferedWriter.flush();
                    bufferedWriter.close();
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    public static void main(String[] args) {
        System.out.println("finish");
    }
}

