/*
 * Decompiled with CFR 0.152.
 */
package threadframe;

import bean.CheckModule;
import bean.CmdExec;
import bean.DosCmdEncode;
import bean.ReadFile;
import data.ProjectTree;
import data.Projectdata;
import data.TargetSequencedata;
import frame.TargetSequencestatus;
import java.awt.Color;
import java.awt.Component;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import javax.swing.JFrame;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;

public class TargetCopyFileProgressBar
extends Thread {
    private static int DELAY = 1;
    JProgressBar progressBar;
    String f1;
    String f2;
    String nodename;
    TargetSequencestatus sp;
    ArrayList<String> multimiran;
    ArrayList<String> usrmultimiran;

    public TargetCopyFileProgressBar(JProgressBar bar, String in, String out, String name, TargetSequencestatus spin, ArrayList<String> inmultimiran, ArrayList<String> inusrmultimiran) {
        this.progressBar = bar;
        this.f1 = in;
        this.f2 = out;
        this.nodename = name;
        this.sp = spin;
        this.multimiran = inmultimiran;
        this.usrmultimiran = inusrmultimiran;
    }

    @Override
    public void run() {
        Projectdata.isbusy = false;
        this.sp.openloadsta();
        boolean enbmenu = false;
        int maximum = this.progressBar.getMaximum();
        Runnable runner = new Runnable(){

            @Override
            public void run() {
                int value = TargetCopyFileProgressBar.this.progressBar.getValue();
                TargetCopyFileProgressBar.this.progressBar.setValue(value + 1);
            }
        };
        try {
            File f1 = new File(this.f1);
            File f2 = new File(this.f2);
            FileInputStream in = new FileInputStream(f1);
            FileOutputStream out = new FileOutputStream(f2);
            float max = (float)f1.length() / 100.0f;
            int progress = 0;
            double f_max = Math.ceil(max);
            int i_max = (int)f_max;
            byte[] buf = new byte[i_max];
            this.sp.setLogtxt("   Start loading sequences to project\t\t [wait]");
            int tt = 0;
            while (tt < (int)f1.length()) {
                int len = ((InputStream)in).read(buf);
                ((OutputStream)out).write(buf, 0, len);
                tt += len;
                this.sp.setMsg(String.valueOf(++progress) + " %");
                SwingUtilities.invokeAndWait(runner);
            }
            ((InputStream)in).close();
            ((OutputStream)out).close();
            this.sp.setRPLogtxt("   Start loading sequences to project\t\t [done] ");
            this.sp.setMsg("100 %");
            if (Projectdata.isloadsamesta) {
                this.sp.setMsgCheck("Now, preparing sequences for the identification");
                this.sp.setLogtxt("   Preparing sequences for the identification\t\t [wait]");
            } else {
                this.sp.setMsgCheck("Now, checking sequence format");
                this.sp.setLogtxt("   Start validing fasta format\t\t\t [wait]");
            }
            Projectdata.targetsequencename = this.nodename;
            this.sp.setCheckfastavisble(true);
            this.sp.setPbcheckValue(25);
            String filesep = System.getProperty("file.separator");
            String parm = TargetSequencedata.getMultiRna(this.multimiran, "#");
            String usrparm = TargetSequencedata.getMultiRna(this.usrmultimiran, "#");
            String pathexc = CheckModule.getPathReg("python");
            String cmd = new String(String.valueOf(pathexc) + "python python" + filesep + "main_03_sub_01_load_sequence.py  " + DosCmdEncode.premakecmdread(String.valueOf(Projectdata.getPath("targetsequence")) + filesep) + "  " + DosCmdEncode.premakecmdread(String.valueOf(Projectdata.getPath("targetsequence")) + filesep) + "  " + this.nodename + "   " + parm + "  " + usrparm);
            boolean cmdsta = CmdExec.runExec(cmd);
            this.sp.setPbcheckValue(100);
            if (Projectdata.isloadsamesta) {
                this.sp.setMsgCheck("Now, preparing sequences for the identification [done]");
                this.sp.setLogtxt("   Preparing sequences for the identification\t\t [done] ");
            } else {
                this.sp.setMsgCheck("Now checking sequence format [done]");
                this.sp.setLogtxt("   Check valid fasta format done\t\t [done] ");
            }
            boolean chk = false;
            String filestatus = String.valueOf(Projectdata.getPath("targetsequence")) + filesep + this.nodename;
            String summary = ReadFile.readfile(String.valueOf(filestatus) + ".status", "Load target sequence status", "TargetCopyFileProgressBar.java");
            if (!summary.substring(0, 17).equals("Please check form")) {
                chk = true;
            }
            ArrayList expandedPaths = ProjectTree.getExpandedPaths(Projectdata.jtall);
            if (Projectdata.isloadtargetsequence) {
                ProjectTree.removesequence(Projectdata.targetsequencename, "target");
            } else {
                ProjectTree.removesequence("NA", "target");
            }
            ProjectTree.expandPaths(expandedPaths, Projectdata.jtall);
            if (chk) {
                this.sp.closeloadsta();
                ProjectTree.insertNode(this.nodename, Projectdata.projectname, "sequencetarget");
                Projectdata.isloadtargetsequence = true;
                enbmenu = true;
            } else {
                ProjectTree.insertNode("NA", Projectdata.projectname, "sequencetarget");
                Projectdata.isloadtargetsequence = false;
                this.sp.setLogtxt("   * Your input is not fasta format\t", "[Error]", "red");
                enbmenu = false;
            }
            System.gc();
            final boolean tmpenbmenu = enbmenu;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Projectdata.unfreez();
                    if (tmpenbmenu) {
                        Projectdata.isbusy = true;
                        ProjectTree.setfoucusnode1leve3("Sequence file", "target");
                    } else {
                        ProjectTree.setfoucusnode("Sequence file", "target");
                        Projectdata.isbusy = true;
                    }
                }
            });
        }
        catch (Exception ep) {
            ep.printStackTrace();
        }
    }

    public static void main(String[] args) {
        JFrame f = new JFrame();
        JProgressBar aJProgressBar = new JProgressBar(0, 50);
        aJProgressBar.setStringPainted(true);
        f.add((Component)aJProgressBar, "North");
        f.setSize(700, 600);
        f.getContentPane().setBackground(Color.white);
        f.setDefaultCloseOperation(3);
        f.setVisible(true);
    }
}

