/*
 * Decompiled with CFR 0.152.
 */
package visualizeation;

import data.Projectdata;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.io.File;
import java.io.PrintWriter;
import java.util.ArrayList;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import listener.GGListener;
import listener.NewGGListener;
import visualizeation.GoBuildPath;
import visualizeation.TreeView;

public class DemoGG {
    public static void main(String[] args) {
    }

    public static JPanel getGG(String filename, String seqname, String infile) {
        String label = "name";
        String xmlstring = GoBuildPath.getXML(filename, seqname);
        int maxpath = GoBuildPath.maxpath;
        int c = GoBuildPath.c;
        int p = GoBuildPath.p;
        int f = GoBuildPath.f;
        String cpfmsg = "[  C : " + c + "  P: " + p + "  F: " + f + "  ]";
        DemoGG.writefile(infile, xmlstring);
        Box menu = Box.createHorizontalBox();
        ArrayList<String> al = new ArrayList<String>();
        al.add("All");
        al.add("level-by-level");
        Object[] ts = al.toArray();
        JComboBox<Object> tcb = new JComboBox<Object>(ts);
        tcb.setFont(Projectdata.fnornmal);
        tcb.setSelectedItem("All");
        JButton btlvl = new JButton("view");
        btlvl.setFont(Projectdata.fnornmal);
        JPanel control = new JPanel();
        control.setLayout(new FlowLayout(0));
        control.add(tcb);
        control.add(btlvl);
        JComponent treeview2 = TreeView.demo(infile, label, 20);
        JPanel dispaly = new JPanel();
        dispaly.setLayout(new BorderLayout());
        dispaly.add((Component)treeview2, "Center");
        JPanel frame = new JPanel();
        GGListener gglistener = new GGListener(treeview2, frame, tcb, infile, label, menu);
        btlvl.addActionListener(gglistener);
        NewGGListener newgg = new NewGGListener(tcb, infile, label);
        JButton opennew = new JButton("Open in new window");
        opennew.setFont(Projectdata.fnornmal);
        opennew.addActionListener(newgg);
        control.add(opennew);
        control.add(new JLabel(cpfmsg));
        menu.add(control);
        frame.setLayout(new BorderLayout());
        frame.add((Component)menu, "North");
        frame.add((Component)dispaly, "Center");
        return frame;
    }

    public static void writefile(String filename, String output) {
        try {
            File f = new File(filename);
            PrintWriter pw = new PrintWriter(f);
            pw.write(output);
            pw.flush();
            pw.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

