/*
 * Decompiled with CFR 0.152.
 */
package visualizeation;

import bean.Countpath;
import data.GoMap;
import data.Projectdata;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import visualizeation.MakeXML;

public class GoBuildPath {
    public static int maxpath = 0;
    public static int c = 0;
    public static int p = 0;
    public static int f = 0;

    public static void main(String[] args) {
        String filename = "D:\\javaworkspace\\RNAProject\\Projects\\Test_far_again2\\Target_sequence\\Target_annotation\\output1";
        String seqname = "input_sequence_00105-plus";
        GoBuildPath gg = new GoBuildPath();
        TreeMap<String, GoMap> godic = gg.loadDic();
        TreeMap<String, String> pathtree = new TreeMap<String, String>();
        TreeSet<String> golist = gg.loadGo(filename, seqname);
        TreeMap<String, String> godicmap = new TreeMap<String, String>();
        maxpath = 0;
        TreeMap<String, String> gomapcpf = GoBuildPath.loadGoCPF();
        ArrayList<String> countcpf = new ArrayList<String>();
        for (String name : golist) {
            Countpath cp = new Countpath();
            GoBuildPath.findPath(godic, name, pathtree, cp);
            godicmap.put(name, name);
            if (cp.getResult() > maxpath) {
                maxpath = cp.getResult();
            }
            if (gomapcpf.get(name) == null) continue;
            countcpf.add(gomapcpf.get(name));
        }
        Projectdata.golist = godicmap;
        TreeMap<String, String> gomapfunction = GoBuildPath.loadMapFunction();
        Projectdata.gomapfunction = gomapfunction;
        c = 0;
        p = 0;
        f = 0;
        for (String string : countcpf) {
            if (string.equals("C")) {
                ++c;
            }
            if (string.equals("P")) {
                ++p;
            }
            if (!string.equals("F")) continue;
            ++f;
        }
        pathtree = GoBuildPath.makeDepend(pathtree);
        pathtree.put("Go", "GO:0003674,GO:0005575,GO:0008150");
        TreeMap<String, String> newpathtree = new TreeMap<String, String>();
        Set<String> keys = pathtree.keySet();
        for (String key : keys) {
            String path = pathtree.get(key);
            String newpath = GoBuildPath.mapGo2Function(gomapfunction, path);
            if (key.equals("Go")) {
                newpathtree.put("Go", newpath);
                continue;
            }
            String newkey = gomapfunction.get(key);
            if (newkey != null) {
                newpathtree.put(newkey, newpath);
                continue;
            }
            newpathtree.put(key, newpath);
        }
        String output = MakeXML.buildXML(newpathtree, "Go");
    }

    public static String mapGo2Function(TreeMap<String, String> gomapfunction, String golists) {
        String[] golists_split = golists.split(",");
        StringBuffer sb = new StringBuffer();
        String[] stringArray = golists_split;
        int n = golists_split.length;
        int n2 = 0;
        while (n2 < n) {
            String golist = stringArray[n2];
            if (gomapfunction.get(golist).trim() != null) {
                sb.append(String.valueOf(gomapfunction.get(golist).trim().replaceAll(",", ";")) + ",");
            } else {
                sb.append(String.valueOf(golist.trim().replaceAll(",", ";")) + ",");
            }
            ++n2;
        }
        return sb.toString().substring(0, sb.toString().length() - 1);
    }

    public static String getXML(String filename, String seqname) {
        GoBuildPath gg = new GoBuildPath();
        TreeMap<String, GoMap> godic = gg.loadDic();
        TreeMap<String, String> pathtree = new TreeMap<String, String>();
        TreeSet<String> golist = gg.loadGo(filename, seqname);
        TreeMap<String, String> godicmap = new TreeMap<String, String>();
        maxpath = 0;
        TreeMap<String, String> gomapcpf = GoBuildPath.loadGoCPF();
        ArrayList<String> countcpf = new ArrayList<String>();
        for (String name : golist) {
            Countpath cp = new Countpath();
            GoBuildPath.findPath(godic, name, pathtree, cp);
            godicmap.put(name, name);
            if (cp.getResult() > maxpath) {
                maxpath = cp.getResult();
            }
            if (gomapcpf.get(name) == null) continue;
            countcpf.add(gomapcpf.get(name));
        }
        Projectdata.golist = godicmap;
        TreeMap<String, String> gomapfunction = GoBuildPath.loadMapFunction();
        Projectdata.go2function = gomapfunction;
        TreeMap<String, String> gomapfunction2go = GoBuildPath.loadMapFunction2Go();
        Projectdata.gomapfunction = gomapfunction2go;
        c = 0;
        p = 0;
        f = 0;
        for (String string : countcpf) {
            if (string.equals("C")) {
                ++c;
            }
            if (string.equals("P")) {
                ++p;
            }
            if (!string.equals("F")) continue;
            ++f;
        }
        pathtree = GoBuildPath.makeDepend(pathtree);
        pathtree.put("Go", "GO:0003674,GO:0005575,GO:0008150");
        TreeMap<String, String> newpathtree = new TreeMap<String, String>();
        Set<String> keys = pathtree.keySet();
        for (String key : keys) {
            String path = pathtree.get(key);
            String newpath = GoBuildPath.mapGo2Function(gomapfunction, path);
            if (key.equals("Go")) {
                newpathtree.put("Go", newpath);
                continue;
            }
            String newkey = gomapfunction.get(key);
            if (newkey != null) {
                newpathtree.put(newkey, newpath);
                continue;
            }
            newpathtree.put(key, newpath);
        }
        String output = MakeXML.buildXML(newpathtree, "Go");
        return output;
    }

    public static TreeMap<String, String> makeDepend(TreeMap<String, String> pathtree) {
        ArrayList<String> altmp = new ArrayList<String>();
        Set<String> keys = pathtree.keySet();
        for (String key : keys) {
            String path = pathtree.get(key);
            GoBuildPath.goConvert(key, path, altmp);
        }
        TreeMap<String, String> newpathtree = new TreeMap<String, String>();
        for (String line : altmp) {
            String[] lines = line.split(",");
            String key = lines[0].trim();
            String value = lines[1].trim();
            if (newpathtree.containsKey(key)) {
                value = String.valueOf(newpathtree.get(key).toString().trim()) + "," + value;
                newpathtree.put(key, value);
                continue;
            }
            newpathtree.put(key, value);
        }
        return newpathtree;
    }

    public static void goConvert(String m1, String m2, ArrayList<String> altmp) {
        String[] m2s;
        String[] stringArray = m2s = m2.split(",");
        int n = m2s.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            altmp.add(String.valueOf(string) + "," + m1);
            ++n2;
        }
    }

    public static void findPath(TreeMap<String, GoMap> godic, String goname, TreeMap<String, String> pathtree, Countpath cp) {
        String[] isa;
        GoMap gm = godic.get(goname);
        if (gm == null) {
            return;
        }
        pathtree.put(goname, gm.getIsa().replace(";", ","));
        if (gm.getIsa().split(";").length > 1) {
            cp.incMulti();
        }
        if (cp.checkKey(goname)) {
            cp.breackcount();
        } else {
            cp.addDic(goname);
            cp.incCount();
        }
        String[] stringArray = isa = gm.getIsa().split(";");
        int n = isa.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            GoBuildPath.findPath(godic, string, pathtree, cp);
            ++n2;
        }
    }

    public static TreeMap<String, TreeSet<String>> loadGo2SEQDic(String filename) {
        TreeMap<String, TreeSet<String>> gomap = new TreeMap<String, TreeSet<String>>();
        try {
            String line;
            File f = new File(filename);
            FileReader fr = new FileReader(f);
            BufferedReader br = new BufferedReader(fr);
            while ((line = br.readLine()) != null) {
                String[] gos;
                String[] lines = line.split("\t");
                if (lines.length != 11) continue;
                String seq = lines[0].trim();
                String[] stringArray = gos = lines[5].trim().split(";");
                int n = gos.length;
                int n2 = 0;
                while (n2 < n) {
                    String string = stringArray[n2];
                    if (!string.trim().equals("unknown")) {
                        TreeSet<Object> seqlist;
                        String key = string.trim();
                        if (gomap.containsKey(key)) {
                            seqlist = gomap.get(key);
                            seqlist.add(seq);
                            gomap.put(key, seqlist);
                        } else {
                            seqlist = new TreeSet();
                            seqlist.add(seq);
                            gomap.put(key, seqlist);
                        }
                    }
                    ++n2;
                }
            }
            br.close();
            fr.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return gomap;
    }

    public TreeMap<String, TreeSet<String>> loadGoDic(String filename) {
        TreeMap<String, TreeSet<String>> gomap = new TreeMap<String, TreeSet<String>>();
        try {
            String line;
            File f = new File(filename);
            FileReader fr = new FileReader(f);
            BufferedReader br = new BufferedReader(fr);
            while ((line = br.readLine()) != null) {
                String string;
                int n;
                int n2;
                String[] stringArray;
                String[] gos;
                TreeSet<Object> golist;
                String[] lines = line.split("\t");
                if (lines.length != 11) continue;
                String key = lines[0].trim();
                if (gomap.containsKey(key)) {
                    golist = gomap.get(key);
                    stringArray = gos = lines[5].trim().split(";");
                    n2 = gos.length;
                    n = 0;
                    while (n < n2) {
                        string = stringArray[n];
                        if (!string.trim().equals("unknown")) {
                            golist.add(string.trim());
                        }
                        ++n;
                    }
                    gomap.put(key, golist);
                    continue;
                }
                golist = new TreeSet();
                stringArray = gos = lines[5].trim().split(";");
                n2 = gos.length;
                n = 0;
                while (n < n2) {
                    string = stringArray[n];
                    if (!string.trim().equals("unknown")) {
                        golist.add(string.trim());
                    }
                    ++n;
                }
                gomap.put(key, golist);
            }
            br.close();
            fr.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return gomap;
    }

    public TreeSet<String> loadGo(String filename, String seqname) {
        TreeSet<String> golist = new TreeSet<String>();
        try {
            String line;
            File f = new File(filename);
            FileReader fr = new FileReader(f);
            BufferedReader br = new BufferedReader(fr);
            while ((line = br.readLine()) != null) {
                String[] gos;
                String[] lines = line.split("\t");
                if (!lines[0].trim().equals(seqname)) continue;
                String[] stringArray = gos = lines[5].trim().split(";");
                int n = gos.length;
                int n2 = 0;
                while (n2 < n) {
                    String string = stringArray[n2];
                    if (!string.trim().equals("unknown")) {
                        golist.add(string.trim());
                    }
                    ++n2;
                }
            }
            br.close();
            fr.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return golist;
    }

    public TreeMap<String, GoMap> loadDic() {
        TreeMap<String, GoMap> godic = new TreeMap<String, GoMap>();
        String filename = String.valueOf(System.getProperty("user.dir")) + System.getProperty("file.separator") + "database" + System.getProperty("file.separator") + "go_path_mapping.txt";
        try {
            String line;
            File f = new File(filename);
            FileReader fr = new FileReader(f);
            BufferedReader br = new BufferedReader(fr);
            while ((line = br.readLine()) != null) {
                String[] lines = line.split("\t");
                GoMap gm = new GoMap();
                gm.setName(lines[0].trim());
                gm.setIsa(lines[1].trim());
                if (lines.length == 3) {
                    gm.setPartof(lines[2].trim());
                    gm.setHavepartof(true);
                }
                godic.put(lines[0].trim(), gm);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return godic;
    }

    public static TreeMap<String, String> loadGoCPF() {
        TreeMap<String, String> godic = new TreeMap<String, String>();
        String filename = String.valueOf(System.getProperty("user.dir")) + System.getProperty("file.separator") + "database" + System.getProperty("file.separator") + "GO.terms_and_ids";
        Projectdata.savecmdlog("Read gomaing", "GoBuildPath.java");
        try {
            String line;
            File f = new File(filename);
            FileReader fr = new FileReader(f);
            BufferedReader br = new BufferedReader(fr);
            while ((line = br.readLine()) != null) {
                String[] lines = line.split("\t");
                godic.put(lines[0].trim(), lines[2].trim());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return godic;
    }

    public static TreeMap<String, String> loadMapFunction() {
        TreeMap<String, String> godic = new TreeMap<String, String>();
        String filename = String.valueOf(System.getProperty("user.dir")) + System.getProperty("file.separator") + "database" + System.getProperty("file.separator") + "GO.terms_and_ids";
        try {
            String line;
            File f = new File(filename);
            FileReader fr = new FileReader(f);
            BufferedReader br = new BufferedReader(fr);
            while ((line = br.readLine()) != null) {
                String[] lines = line.split("\t");
                godic.put(lines[0].trim(), lines[1].trim());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return godic;
    }

    public static TreeMap<String, String> loadMapFunction2Go() {
        TreeMap<String, String> godic = new TreeMap<String, String>();
        String filename = String.valueOf(System.getProperty("user.dir")) + System.getProperty("file.separator") + "database" + System.getProperty("file.separator") + "GO.terms_and_ids";
        try {
            String line;
            File f = new File(filename);
            FileReader fr = new FileReader(f);
            BufferedReader br = new BufferedReader(fr);
            while ((line = br.readLine()) != null) {
                String[] lines = line.split("\t");
                godic.put(lines[1].trim(), lines[0].trim());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return godic;
    }
}

